﻿---
title: Visualizing monitoring data
description: From within the Stack Monitoring section of Kibana, you can view health and performance data for Elasticsearch, Logstash, Kibana, and Beats in real time,...
url: https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/visualizing-monitoring-data
products:
  - Kibana
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Visualizing monitoring data
From within the **Stack Monitoring** section of Kibana, you can view health and performance data for Elasticsearch, Logstash, Kibana, and Beats in real time, as well as analyze past performance.
Before you can see this data inside of Kibana, you need to [configure stack monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring) and, for Elastic Cloud on Kubernetes and self-managed deployments, [configure Kibana to retrieve and display monitoring data](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-data).
Review the following topics to learn more about the metrics and visualizations available in the **Stack Monitoring** area:
- [Elasticsearch metrics](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/elasticsearch-metrics)
- [Kibana metrics](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/kibana-page)
- [Integrations Server metrics](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/integrations-server-page) <applies-to>Elastic Cloud Hosted: Generally available</applies-to> <applies-to>Elastic Cloud Enterprise: Generally available</applies-to>
- [Beats metrics](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/beats-page)
- [Logstash metrics](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/logstash-page)

From the **Stack Monitoring** section, you can also configure [Kibana alerts](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/configure-stack-monitoring-alerts) for stack monitoring metrics.
If you're having trouble accessing your monitoring data within the **Stack Monitoring** section, then refer to [Troubleshooting visualizing monitoring data in Kibana](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/monitor-troubleshooting).
If you enable monitoring across the Elastic Stack, each monitored component is considered unique based on its persistent UUID, which is written to the [`path.data`](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings#path-data) directory when the node or instance starts.