﻿---
title: Integrations Server metrics
description: Integrations Server is available in Elastic Cloud Hosted and Elastic Cloud Enterprise deployments as a combined offering of Application Performance Monitoring...
url: https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/integrations-server-page
products:
  - Kibana
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud Enterprise: Generally available
---

# Integrations Server metrics
Integrations Server is available in Elastic Cloud Hosted and Elastic Cloud Enterprise deployments as a combined offering of [Application Performance Monitoring (APM) Server](https://www.elastic.co/docs/solutions/observability/apm) and [Fleet Server](https://www.elastic.co/docs/reference/fleet):
- Use APM Server to monitor your software services and applications in real time.
- Use Fleet Server to manage your Elastic Agents running on one or more hosts, and the policies that the agents run under.

**To view an overview of Integrations Server health:**
1. In the Integrations Server section of the **Stack Monitoring** page, click **Integrations server overview**.
   The **APM server overview** page opens, showing both resource usage for Integrations Server and various metrics for APM Server.
   ![Integrations Server Overview](https://www.elastic.co/docs/deploy-manage/images/kibana-monitoring-integrations-server-overview.png)
2. Adjust the time period for the visualizations as needed.
3. From this page you can also [create alerts](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/create-manage-rules) to be triggered when the Integrations Server metrics meet a defined set of conditions.

**To view metrics for a specific Integrations Server instance:**
1. In the Integrations Server section of the **Stack Monitoring** page, click **Integrations Servers**.
   The **APM server instances** page opens, showing the status of each instance, including both resource usage for Integrations Server and metrics data for [APM Server](https://www.elastic.co/docs/solutions/observability/apm).
2. Click the name of an instance to view its statistics over time.
3. Adjust the time period for the visualizations as needed.
4. As with the **APM server overview** page, you can also [create alerts](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/create-manage-rules) to be triggered when the instance metrics meet a defined set of conditions.