﻿---
title: Configuring monitoring data streams and indices
description: Monitoring data is stored in data streams or indices in Elasticsearch. The default data stream or index settings may not work for your situation. For...
url: https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/configuring-data-streamsindices-for-monitoring
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Configuring monitoring data streams and indices
Monitoring data is stored in data streams or indices in Elasticsearch. The default data stream or index settings may not work for your situation. For example, you might want to change index lifecycle management (ILM) settings, add custom mappings, or change the number of shards and replicas. The steps to change these settings depend on the monitoring method:
- [Configuring data streams created by Elastic Agent](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/config-monitoring-data-streams-elastic-agent)
- [Configuring data streams created by Metricbeat 8](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/config-monitoring-data-streams-metricbeat-8) (the default for ECH, ECE, and ECK deployments)
- [Configuring indices created by Metricbeat 7 or internal collection](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/config-monitoring-indices-metricbeat-7-internal-collection)

<important>
  Changing mappings or settings can cause your monitoring dashboards to stop working correctly.
</important>