﻿---
title: Configuring indices created by Metricbeat 7 or internal collection
description: When monitoring using Metricbeat 7 or internal collection, data is stored in a set of indices called either: .monitoring-{{product}}-7-mb-{{date}}, when...
url: https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/config-monitoring-indices-metricbeat-7-internal-collection
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Configuring indices created by Metricbeat 7 or internal collection
When monitoring [using Metricbeat 7](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-monitoring-data-with-metricbeat) or [internal collection](https://www.elastic.co/docs/reference/beats/filebeat/monitoring-internal-collection), data is stored in a set of indices called either:
- `.monitoring-{{product}}-7-mb-{{date}}`, when using Metricbeat 7.
- `.monitoring-{{product}}-7-{{date}}`, when using internal collection.

The settings and mappings for these indices are determined by [legacy index templates](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-template) named `.monitoring-{{product}}`.
You can retrieve these templates in Kibana. To manage index templates, go to the **Index Management** management page in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects), and then select **Index Templates**,
You can also use the Elasticsearch `_template` API:
```json
```

To change the settings of the indices, add a custom index template. You can do that in Kibana, or using the Elasticsearch API:
- Set `index_patterns` to match the `.monitoring-{{product}}-7-*` indices.
- Set the template `order` to `1`. This ensures your template is applied after the default template, which has an order of 0.
- Specify the `number_of_shards` and/or `number_of_replicas` in the `settings` section.

```json

{
  "index_patterns": [".monitoring-beats-7-*", ".monitoring-es-7-*", ".monitoring-kibana-7-*", ".monitoring-logstash-7-*"],
  "order": 1,
  "settings": {
    "number_of_shards": 5,
    "number_of_replicas": 2
  }
}
```

After changing the index template, the updated settings are only applied to new indices.