﻿---
title: Configuring data streams created by Elastic Agent
description: When monitoring using Elastic Agent, data is stored in a set of data streams with the following pattern: For example: The settings and mappings for these...
url: https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/config-monitoring-data-streams-elastic-agent
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Configuring data streams created by Elastic Agent
When [monitoring using Elastic Agent](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/collecting-monitoring-data-with-elastic-agent), data is stored in a set of data streams with the following pattern:
```
metrics-{{product}}.stack_monitoring.{{dataset}}-{namespace}
```

For example:
```
metrics-elasticsearch.stack_monitoring.shard-default
```

The settings and mappings for these data streams are determined by an index template with the following pattern:
```
metrics-{{product}}.stack_monitoring.{{dataset}}
```

For example:
```
metrics-elasticsearch.stack_monitoring.shard
```

To change the settings of each data stream, edit the `metrics-{{product}}.stack_monitoring.{{dataset}}@custom` component template that already exists. You can do this in Kibana:
- Go to the **Index Management** management page in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
- Select **Component Templates**.
- Search for the component template.
- Select the **Edit** action.

You can also use the Elasticsearch API:
- Retrieve the component template using the [get component template API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-get-component-template).
- Edit the component template.
- Store the updated component template using the [update component template API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-put-component-template).

After changing the component template, the updated settings are only applied to the data stream’s new backing indices. [Roll over the data stream](/docs/manage-data/data-store/data-streams/use-data-stream#manually-roll-over-a-data-stream) to immediately apply the updated settings to the data stream’s write index.