﻿---
title: Kibana logging
description: You do not need to configure any additional settings to use the logging features in Kibana. Logging is enabled by default. In all deployment types,...
url: https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/kibana-logging
products:
  - Kibana
applies_to:
  - Elastic Stack: Generally available
---

# Kibana logging
You do not need to configure any additional settings to use the logging features in Kibana. Logging is enabled by default.
In all deployment types, you might want to change the log level for Kibana. In a self-managed, ECE, or ECK deployment, you might want to further customize your logging settings to define where log messages are displayed, stored, and formatted, or provide granular settings for different loggers.
- [Set global log levels for Kibana](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/kibana-log-levels)
- [Advanced Kibana logging settings](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/kib-advanced-logging)

You can also configure [Kibana task manager health monitoring](https://www.elastic.co/docs/deploy-manage/monitor/kibana-task-manager-health-monitoring) using logging settings.
<tip>
  For additional information about the available logging settings, refer to the [Kibana configuration reference](https://www.elastic.co/docs/reference/kibana/configuration-reference/logging-settings).
</tip>


## Access Kibana logs

The way that you access your logs differs depending on your deployment method.

### Orchestrated deployments

Access your logs using one of the following options:
- All orchestrated deployments: [Stack monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring)
- Elastic Cloud Hosted: [Preconfigured logs and metrics](/docs/deploy-manage/monitor/cloud-health-perf#ec-es-health-preconfigured)
- Elastic Cloud Enterprise: [Platform monitoring](https://www.elastic.co/docs/deploy-manage/monitor/orchestrators/ece-platform-monitoring)


### Self-managed deployments

If you run Kibana as a service, the default location of the logs varies based on your platform and installation method:
<tab-set>
  <tab-item title="Docker">
    On [Docker](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-with-docker), log messages go to the console and are handled by the configured Docker logging driver. To access logs, run `docker logs`.
  </tab-item>

  <tab-item title="Debian (APT) and RPM">
    For [Debian](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-with-debian-package) and [RPM](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-with-rpm) installations, Elasticsearch writes logs to `/var/log/kibana`.
  </tab-item>

  <tab-item title="macOS and Linux">
    For [macOS and Linux `.tar.gz`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-from-archive-on-linux-macos) installations, Elasticsearch writes logs to `$KIBANA_HOME/logs`.Files in `$KIBANA_HOME` risk deletion during an upgrade. In production, you should configure a [different location for your logs](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/kib-advanced-logging).
  </tab-item>

  <tab-item title="Windows .zip">
    For [Windows `.zip`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-with-zip-on-windows) installations, Elasticsearch writes logs to `%KIBANA_HOME%\logs`.Files in `%KIBANA_HOME%` risk deletion during an upgrade. In production, you should configure a [different location for your logs](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/kib-advanced-logging).
  </tab-item>
</tab-set>

If you run Kibana from the command line, Elasticsearch prints logs to the standard output (`stdout`).
You can also consume logs using [stack monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-self-managed).