﻿---
title: Set global log levels for Kibana
description: Kibana logging supports the following log levels: off, fatal, error, warn, info, debug, trace, all. Levels are ordered, so off > fatal > error > warn...
url: https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/kibana-log-levels
applies_to:
  - Elastic Stack: Generally available
---

# Set global log levels for Kibana
Kibana logging supports the following log levels: `off`, `fatal`, `error`, `warn`, `info`, `debug`, `trace`, `all`.
Levels are ordered, so `off` > `fatal` > `error` > `warn` > `info` > `debug` > `trace` > `all`.
A record will be logged by the logger if its level is higher than or equal to the level of its logger. For example: If the output of an API call is configured to log at the `info` level and the parameters passed to the API call are set to `debug`, with a global logging configuration in [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) set to `debug`, both the output *and* parameters are logged. If the log level is set to `info`, the debug logs are ignored, meaning that you’ll only get a record for the API output and *not* for the parameters.
To set the log level, add the `logging.root.level` setting to [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings), specifying the log level that you want. `logging.root.level` defaults to `info`.
In a self-managed cluster, these levels can also be specified using [CLI arguments](/docs/deploy-manage/monitor/logging-configuration/kib-advanced-logging#logging-cli-migration), and different log levels can be set for various loggers. [Learn more](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/kib-advanced-logging).