﻿---
title: Logging
description: You can configure several types of logs in Elastic Stack that can help you to gain insight into Elastic Stack operations, diagnose issues, and track certain...
url: https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration
applies_to:
  - Elastic Stack: Generally available
---

# Logging
You can configure several types of logs in Elastic Stack that can help you to gain insight into Elastic Stack operations, diagnose issues, and track certain types of events.
The following logging features are available:

## For Elasticsearch

- **Application and component logging**: Logs messages related to running Elasticsearch.
  You can [configure the log level for Elasticsearch](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/update-elasticsearch-logging-levels), and, in self-managed clusters, [configure underlying Log4j settings](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/elasticsearch-log4j-configuration-self-managed) to customize logging behavior.
- [Deprecation logging](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/elasticsearch-deprecation-logs): Deprecation logs record a message to the Elasticsearch log directory when you use deprecated Elasticsearch functionality. You can use the deprecation logs to update your application before upgrading Elasticsearch to a new major version.
- [Audit logging](https://www.elastic.co/docs/deploy-manage/security/logging-configuration/enabling-audit-logs): Logs security-related events on your deployment.
- [Slow query and index logging](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/slow-logs): Helps find and debug slow queries and indexing.


## For Kibana

- **Application and component logging**: Logs messages related to running Kibana.
  You can [configure the log level for Kibana](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/kibana-log-levels), and, in self-managed, ECE, or ECK deployments, [configure advanced settings](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/kib-advanced-logging) to customize logging behavior.
- [Audit logging](https://www.elastic.co/docs/deploy-manage/security/logging-configuration/enabling-audit-logs): Logs security-related events on your deployment.


## Access Kibana and Elasticsearch logs

The way that you access your logs differs depending on your deployment method.

### Orchestrated deployments

Access your logs using one of the following options:
- All orchestrated deployments: [Stack monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring)
- Elastic Cloud Hosted: [Preconfigured logs and metrics](/docs/deploy-manage/monitor/cloud-health-perf#ec-es-health-preconfigured)
- Elastic Cloud Enterprise: [Platform monitoring](https://www.elastic.co/docs/deploy-manage/monitor/orchestrators/ece-platform-monitoring)


### Self-managed deployments


#### Kibana

If you run Kibana as a service, the default location of the logs varies based on your platform and installation method:
<tab-set>
  <tab-item title="Docker">
    On [Docker](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-with-docker), log messages go to the console and are handled by the configured Docker logging driver. To access logs, run `docker logs`.
  </tab-item>

  <tab-item title="Debian (APT) and RPM">
    For [Debian](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-with-debian-package) and [RPM](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-with-rpm) installations, Elasticsearch writes logs to `/var/log/kibana`.
  </tab-item>

  <tab-item title="macOS and Linux">
    For [macOS and Linux `.tar.gz`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-from-archive-on-linux-macos) installations, Elasticsearch writes logs to `$KIBANA_HOME/logs`.Files in `$KIBANA_HOME` risk deletion during an upgrade. In production, you should configure a [different location for your logs](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/kib-advanced-logging).
  </tab-item>

  <tab-item title="Windows .zip">
    For [Windows `.zip`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-with-zip-on-windows) installations, Elasticsearch writes logs to `%KIBANA_HOME%\logs`.Files in `%KIBANA_HOME%` risk deletion during an upgrade. In production, you should configure a [different location for your logs](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/kib-advanced-logging).
  </tab-item>
</tab-set>

If you run Kibana from the command line, Kibana prints logs to the standard output (`stdout`).
You can also consume logs using [stack monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/kibana-monitoring-self-managed).

#### Elasticsearch

If you run Elasticsearch as a service, the default location of the logs varies based on your platform and installation method:
<tab-set>
  <tab-item title="Docker">
    On [Docker](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-with-docker), log messages go to the console and are handled by the configured Docker logging driver. To access logs, run `docker logs`.
  </tab-item>

  <tab-item title="Debian (APT) and RPM">
    For [Debian](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-with-debian-package) and [RPM](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-with-rpm) installations, Elasticsearch writes logs to `/var/log/elasticsearch`.
  </tab-item>

  <tab-item title="macOS and Linux">
    For [macOS and Linux `.tar.gz`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-from-archive-on-linux-macos) installations, Elasticsearch writes logs to `$ES_HOME/logs`.Files in `$ES_HOME` risk deletion during an upgrade. In production, we strongly recommend you set `path.logs` to a location outside of `$ES_HOME`. See [Path settings](/docs/deploy-manage/deploy/self-managed/important-settings-configuration#path-settings).
  </tab-item>

  <tab-item title="Windows .zip">
    For [Windows `.zip`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-with-zip-on-windows) installations, Elasticsearch writes logs to `%ES_HOME%\logs`.Files in `%ES_HOME%` risk deletion during an upgrade. In production, we strongly recommend you set `path.logs` to a location outside of `%ES_HOME%`. See [Path settings](/docs/deploy-manage/deploy/self-managed/important-settings-configuration#path-settings).
  </tab-item>
</tab-set>

If you run Elasticsearch from the command line, Elasticsearch prints logs to the standard output (`stdout`).
You can also consume logs using [stack monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/elasticsearch-monitoring-self-managed).

## Other components

You can also collect and index the following types of logs from other components in your deployments:
[**APM**](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-logging)
- `apm*.log*`

[**Fleet and Elastic Agent**](https://www.elastic.co/docs/reference/fleet/monitor-elastic-agent)
- `fleet-server-json.log-*`
- `elastic-agent-json.log-*`

The `*` indicates that we also index the archived files of each type of log.
In Elastic Cloud Hosted and Elastic Cloud Enterprise, these types of logs are automatically ingested when [stack monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring) is enabled.