﻿---
title: AutoOps FAQ
description: Whether you are using AutoOps in your Elastic Cloud Hosted deployment, Serverless project, or ECE, ECK, or self-managed cluster, find answers to some...
url: https://www.elastic.co/docs/deploy-manage/monitor/autoops/ec-autoops-faq
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud Hosted
  - Elastic Cloud Serverless
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# AutoOps FAQ
Whether you are using AutoOps in your [Elastic Cloud Hosted deployment](https://www.elastic.co/docs/deploy-manage/monitor/autoops/ec-autoops-how-to-access), [Serverless project](https://www.elastic.co/docs/deploy-manage/monitor/autoops/autoops-for-serverless), or [ECE, ECK, or self-managed cluster](https://www.elastic.co/docs/deploy-manage/monitor/autoops/cc-autoops-as-cloud-connected), find answers to some common questions about it on this page.
**General AutoOps questions**
- [What does AutoOps do?](#what-is-autoops)
- [Is AutoOps available in all deployment types?](#autoops-deployment-types)
- [Why can't I see AutoOps in some deployments and projects?](#cant-see-autoops)
- [Can I use AutoOps if my environment is air-gapped?](#autoops-air-gapped)
- [How is AutoOps licensed?](#autoops-license)
- [Does AutoOps monitor the entire Elastic Stack?](#autoops-monitoring)
- [Can AutoOps automatically resolve issues?](#autoops-issue-resolution)
- [Which versions of Elasticsearch are supported in AutoOps for Elastic Cloud Hosted and ECE, ECK, and self-managed clusters?](#autoops-supported-versions)
- [How long does Elastic retain AutoOps data?](#autoops-data-retention)
- [Where are AutoOps metrics stored, and does AutoOps affect customer ECU usage?](#autoops-metrics-storage)
- [Has AutoOps replaced Stack Monitoring?](#autoops-vs-stack-monitoring)

**Questions about AutoOps for ECE, ECK, or self-managed clusters**
- [Does AutoOps for ECE, ECK, or self-managed clusters incur additional costs?](#additional-payment)
- [Does shipping metrics data to Elastic Cloud incur additional costs?](#autoops-metrics-cost)
- [Which deployment types can be connected to AutoOps through Cloud Connect?](#deployment-types)
- [Do I have to do any maintenance when using AutoOps for ECE, ECK, or self-managed clusters?](#maintenance)

**Setting up AutoOps for ECE, ECK, or self-managed clusters**
- [Can I use Cloud Connect to connect my Elastic Cloud Hosted clusters to AutoOps?](#cc-autoops-ech)
- [Can I use macOS to set up AutoOps for my ECE, ECK, or self-managed clusters?](#macos-install)
- [Do I have to define an Elastic IP address to enable the agent to send data to Elastic Cloud?](#elastic-ip-address)
- [Do I have to install Elastic Agent separately for each node in my cluster?](#agent-nodes)
- [Do I have to re-run the installation wizard to connect more clusters?](#connect-more-clusters)

**Collected metrics and data in AutoOps for ECE, ECK, or self-managed clusters**
- [Where are metrics stored in AutoOps for ECE, ECK, or self-managed clusters?](#sm-autoops-metrics-storage)
- [What information does Elastic Agent gather from my cluster?](#extracted-info)
- [How does AutoOps gather data from my cluster and ensure its security?](#data-gathering)
- [Can I view the data gathered by Elastic Agent?](#data-viewing-config)


## General AutoOps questions

<definitions>
  <definition term="What does AutoOps do?">
    AutoOps for Elasticsearch simplifies cluster management by providing performance recommendations, resource utilization and cost insights, real-time issue detection, and resolution paths. By analyzing hundreds of Elasticsearch metrics, your configuration, and usage patterns, AutoOps provides operational and monitoring recommendations that reduce administration time and hardware costs.
  </definition>
  <definition term="Is AutoOps available in all deployment types?">
    AutoOps is automatically available in [Elastic Cloud Hosted deployments](https://www.elastic.co/docs/deploy-manage/monitor/autoops/ec-autoops-how-to-access) and [Elastic Cloud Serverless projects](https://www.elastic.co/docs/deploy-manage/monitor/autoops/autoops-for-serverless), and can be set up for [ECE, ECK, and self-managed clusters](https://www.elastic.co/docs/deploy-manage/monitor/autoops/cc-autoops-as-cloud-connected) through Cloud Connect.
  </definition>
  <definition term="Why can't I see AutoOps in some deployments and projects?">
    AutoOps is rolling out in phases across CSPs and [regions](https://www.elastic.co/docs/deploy-manage/monitor/autoops/ec-autoops-regions), so you may not see it if your deployment or project is in a region where AutoOps is not available yet. AutoOps is currently not available in Azure and GCP.
  </definition>
  <definition term="Can I use AutoOps if my environment is air-gapped?">
    Not at this time. AutoOps is currently only available as a cloud service and you need an internet connection to send metrics to Elastic Cloud. For air-gapped environments, we plan to offer a locally deployable version in the future.
  </definition>
  <definition term="How is AutoOps licensed?">
    For Elastic Cloud Hosted deployments and Serverless projects, AutoOps is available to Elastic Cloud customers at all subscription levels at no additional cost, and it does not consume ECU.
    Using AutoOps for self-managed clusters (ECE, ECK, or standalone) on-premise or in private cloud environments through Cloud Connect is included with [self-managed Enterprise licenses](https://www.elastic.co/subscriptions) and self-managed free trials. This does not consume ECU.
  </definition>
  <definition term="Does AutoOps monitor the entire Elastic Stack?">
    AutoOps is currently limited to Elasticsearch (not Kibana, Logstash, or Beats).
  </definition>
  <definition term="Can AutoOps automatically resolve issues?">
    AutoOps only analyzes metrics and is a read-only solution.
  </definition>
  <definition term="Which versions of Elasticsearch are supported in AutoOps for Elastic Cloud Hosted and ECE, ECK, and self-managed clusters?">
    AutoOps is compatible with [supported Elasticsearch versions](https://www.elastic.co/support/eol) (7.17.x and above).
  </definition>
  <definition term="How long does Elastic retain AutoOps data?">
    AutoOps has a 10 day retention period.
  </definition>
  <definition term="Where are AutoOps metrics stored, and does AutoOps affect customer ECU usage?">
    AutoOps metrics are stored internally within the Elastic infrastructure, not on customer deployments. Using AutoOps does not consume customer ECU.
  </definition>
  <definition term="Has AutoOps replaced Stack Monitoring?">
    Currently, AutoOps has many of the same features as Stack Monitoring as well as several new ones. However, it only provides insights on Elasticsearch and analyzes metrics, not logs. Read more in [AutoOps and Stack Monitoring comparison](https://www.elastic.co/docs/deploy-manage/monitor/autoops-vs-stack-monitoring).
  </definition>
</definitions>


## Questions about AutoOps for ECE, ECK, or self-managed clusters

<definitions>
  <definition term="Does AutoOps for ECE, ECK, or self-managed clusters incur additional costs?">
    Using AutoOps for self-managed clusters (ECE, ECK, or standalone) on-premise or in private cloud environments through Cloud Connect is included with [self-managed Enterprise licenses](https://www.elastic.co/subscriptions) and self-managed free trials. This does not consume ECU.
  </definition>
  <definition term="Does shipping metrics data to Elastic Cloud incur additional costs?">
    Elastic does not charge extra for this service, but your cloud service provider (CSP) might. When sending metrics data from your cluster in a CSP region to Elastic Cloud, shipping costs are determined by your agreement with that CSP.
    You can [choose the CSP region where your data is stored](#sm-autoops-metrics-storage).
  </definition>
  <definition term="Which deployment types can be connected to AutoOps through Cloud Connect?">
    You can connect to AutoOps on a standalone Elastic Stack, ECE (Elastic Cloud Enterprise), or ECK (Elastic Cloud on Kubernetes) deployment, both on-premise and in private cloud environments.
  </definition>
  <definition term="Do I have to do any maintenance when using AutoOps for ECE, ECK, or self-managed clusters?">
    AutoOps is a cloud service, so you don't need to upgrade it yourself. However, we recommend keeping Elastic Agent upgraded to the latest version so you can access new features and fixes.
  </definition>
</definitions>


### Setting up AutoOps for ECE, ECK, or self-managed clusters

<definitions>
  <definition term="Can I use Cloud Connect to connect my Elastic Cloud Hosted clusters to AutoOps?">
    This path is not supported. Currently, we only support using Cloud Connect to connect ECE, ECK, and self-managed clusters to AutoOps.
    For Elastic Cloud Hosted deployments, AutoOps is set up and enabled automatically in all supported [regions](https://www.elastic.co/docs/deploy-manage/monitor/autoops/ec-autoops-regions), and can be [accessed](https://www.elastic.co/docs/deploy-manage/monitor/autoops/ec-autoops-how-to-access) from the deployment overview page.
  </definition>
  <definition term="Can I use macOS to install Elastic Agent to connect my ECE, ECK, or self-managed cluster to AutoOps?">
    No, macOS is not a supported platform for installing Elastic Agent and connecting an ECE, ECK, or self-managed cluster to AutoOps. Refer to [Install agent](/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops#install-agent) for a list of supported platforms. You can use macOS to [connect your local development cluster to AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops/cc-connect-local-dev-to-autoops).
  </definition>
  <definition term="Do I have to define an Elastic IP address to enable the agent to send data to Elastic Cloud?">
    You may need to define an IP address if your organization’s settings will block the agent from sending out data.
    To enable IP ranges, Elastic Cloud offers a selection of static IP addresses. All traffic directed to Elastic Cloud deployments, whether originating from the public internet, your private cloud network through the public internet, or your on-premise network through the public internet utilizes Ingress Static IPs as the network destination.
  </definition>
  <definition term="For more information, refer to Elastic Cloud Static IPs.">
  </definition>
  <definition term="Do I have to install Elastic Agent separately for each node in my cluster?">
    No, to run AutoOps in your ECE, ECK, or self-managed environment, you only have to install the agent once per cluster.
  </definition>
  <definition term="Do I have to re-run the installation wizard to connect more clusters?">
    Not necessarily. Refer to [Connect additional clusters](/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops#connect-additional-clusters) for more information.
  </definition>
</definitions>


### Collected metrics and data in AutoOps for ECE, ECK, or self-managed clusters

<definitions>
  <definition term="Where are metrics stored in AutoOps for ECE, ECK, or self-managed clusters?">
    You can choose where to store your metrics from the following AWS regions:
    | Region         | Name                     |
    |----------------|--------------------------|
    | us-east-2      | US East (Ohio)           |
    | us-west-2      | US West (Oregon)         |
    | eu-west-1      | EU (Ireland)             |
    | eu-west-2      | Europe (London)          |
    | eu-central-1   | Europe (Frankfurt)       |
    | ap-northeast-1 | Asia Pacific (Tokyo)     |
    | ap-southeast-1 | Asia Pacific (Singapore) |
    More cloud service providers and regions are coming soon.
  </definition>
  <definition term="What information does Elastic Agent gather from my cluster?">
    Elastic Agent only extracts and sends cluster metrics to Elastic Cloud, not the underlying data within your cluster. The following metrics are collected:
    | API                                                                                                                         | Description                                                                               | Collected data                                                             |
    |-----------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------|----------------------------------------------------------------------------|
    | [_cat/shards](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cat-shards)                             | Returns detailed information about the shards within the cluster                          | Shard states, node allocation, index names, sizes, and replica information |
    | [_nodes/stats](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-nodes-stats)                           | Retrieves statistics from cluster nodes including JVM, OS, process, and transport metrics | CPU usage, memory utilization, thread pools, file system stats             |
    | [_cluster/settings](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-get-settings)             | Returns the settings configured for the cluster                                           | Persistent and transient settings such as cluster-wide configurations      |
    | [_cluster/health](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-health)                     | Provides information about the overall health of the cluster                              | Status (green/yellow/red), number of nodes, number of shards               |
    | [_cat/template](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cat-templates)                        | Lists all index templates in the cluster                                                  | Template names, patterns, and basic settings                               |
    | [_index_template](https://www.elastic.co/docs/manage-data/data-store/templates)                                             | Retrieves composable index templates                                                      | Index settings, mappings, and aliases                                      |
    | [_component_template](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-get-component-template) | Fetches component templates used for building index templates                             | Metadata for re-usable mappings and settings                               |
    | [_tasks](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-tasks)                                            | Displays information about currently running tasks on the cluster                         | Task descriptions, start times, running nodes, and execution details       |
    | [_template](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-get-template)                     | Retrieves legacy index templates                                                          | Similar to composable index templates but in older format                  |
    | [_resolve/index/*](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-resolve-index)             | Resolves index, data stream, and alias names to their current definitions                 | Mappings between names and underlying data objects                         |
  </definition>
  <definition term="How does AutoOps gather data from my cluster and ensure its security?">
    AutoOps gathers data from your cluster using two protocols:
    - **HTTP request**: Made to our Cloud Connected API to register your cluster with Elastic Cloud and gather registration-related data.
    - **OpenTelemetry Protocol (OTLP)**: Used to gather all other operational data.
    Each channel is authenticated using an API key or token to ensure your data's security. The following table offers more details:
    | Protocol       | Data extracted                                                                                     | Port                         | Authentication method                                                           |
    |----------------|----------------------------------------------------------------------------------------------------|------------------------------|---------------------------------------------------------------------------------|
    | HTTP           | Basic cluster information from the `/` endpoint  License information from the `/_license` endpoint | **443**: standard HTTPS port | Uses an Elastic Cloud API key which is limited for use with Cloud Connect only. |
    | OTLP over HTTP | Operational information                                                                            | **443**: standard HTTPS port | Uses an AutoOps token which is functionally equivalent to an API key.           |
    <note>
      If your organization uses firewalls, you need to provide access to port 443 and allow the agent to send data to the following URLs:
      - `https://api.elastic-cloud.com`
      - `https://otel-auto-ops.${region}.${csp}.svc.elastic.cloud/`
        Replace `${region}` and `${csp}` with the region and cloud service provider you have selected as your [storage location](/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops#storage-location). For example:
        `https://otel-auto-ops.us-east-1.aws.svc.elastic.cloud/`
      Learn more about [defining an Elastic IP address](#elastic-ip-address) for AutoOps for ECE, ECK, or self-managed clusters.
    </note>
  </definition>
  <definition term="Can I view the data gathered by Elastic Agent?">
    Yes. AutoOps Elastic Agent comes bundled with the `autoops_es_debug.yml` configuration file, which you can use to view a sample of the data gathered from your cluster that would be sent to Elastic Cloud.
    Complete the following steps to view a sample of this data locally:
    1. Follow the steps to [connect to AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops) until you reach the [Install agent](/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops#install-agent) step.
    2. In the **Install agent** step, edit the installation command to replace `autoops_es.yml` with `autoops_es_debug.yml` as shown in the following code block:
    ```json
        --config otel_samples/autoops_es_debug.yml \
    ```
    1. Run the command to start the container.
    2. The data sample will be logged to the container's standard output in JSON format. To view the output, run the following command:
    ```json
    docker logs autoops-otel-agent
    ```
  </definition>
</definitions>