﻿---
title: Manage connected cluster users
description: Learn how to invite users to your Elastic Cloud organization and give them access to AutoOps on your connected ECE, ECK, or self-managed clusters. To...
url: https://www.elastic.co/docs/deploy-manage/monitor/autoops/cc-manage-users
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Manage connected cluster users
Learn how to invite users to your Elastic Cloud organization and give them access to AutoOps on your connected ECE, ECK, or self-managed clusters.

## Invite users

<note>
  Users can only belong to one Elastic Cloud organization at a time. If you want to create or join another organization, you must [leave the previous one](/docs/cloud-account/join-or-leave-an-organization#ec-leave-organization) or use a different email address.
</note>

To invite users to your organization and give them access to your cluster:
1. Log in to [Elastic Cloud](https://cloud.elastic.co/home).
2. In the **Connected clusters** section, select a cluster.
3. From the lower navigation menu, select **Organization**.
4. On the **Members** page, click **Invite members**.
5. Enter the email address of the user you want to invite.
   To add multiple users, enter their email addresses separated by a space.
6. In the **Assign roles** section, enable **Connected cluster access**.
7. Set roles for the users on all or selected clusters so that they have the appropriate permissions when they accept the invitation and sign in to Elastic Cloud.
   Learn more about roles and their levels of access to AutoOps in [Assign roles](#assign-roles).
8. Click **Send invites**.
   Invitations to join an organization are sent by email. Invited users have 72 hours to accept the invitation before it expires. If an invitation expires, an admin can resend it.

You can also [manage existing users](/docs/deploy-manage/users-roles/cloud-organization/manage-users#manage-existing-users) and [manage users through the Elastic Cloud API](/docs/deploy-manage/users-roles/cloud-organization/manage-users#ec-api-organizations).

## Assign roles

Assign the following roles to new or existing users based on levels of access to AutoOps:

| Role                         | Allowed actions in AutoOps                                                                                                                                                                                                                                                                            |
|------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Organization owner**       | View events and metrics reports  Add or edit customizations and notification preferences  Connect and disconnect clusters                                                                                                                                                                             |
| **Connected cluster access** | **Viewer**:  View events and metrics reports   **Admin** for all connected clusters:  View events and metrics reports  Add or edit customizations and notification preferences  Connect and disconnect clusters   **Admin** for selected clusters:  View events and metrics reports  Connect clusters |