﻿---
title: Connect your local development cluster to AutoOps
description: If you have an Elasticsearch cluster set up for local development or testing, you can connect it to AutoOps using Docker. Ensure your system meets the...
url: https://www.elastic.co/docs/deploy-manage/monitor/autoops/cc-connect-local-dev-to-autoops
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud on Kubernetes
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Connect your local development cluster to AutoOps
If you have an Elasticsearch cluster set up for local development or testing, you can connect it to AutoOps using Docker.

## Prerequisites

Ensure your system meets the following requirements before proceeding:
- You have set up [Elasticsearch for local development](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/local-development-installation-quickstart).
- Your local development cluster is on a [supported Elasticsearch version](https://www.elastic.co/support/eol) (7.17.x and above).
- You have installed [Docker Desktop](https://www.docker.com/products/docker-desktop).
- You have an Elastic Cloud account with the [Organization owner role](/docs/deploy-manage/monitor/autoops/cc-manage-users#assign-roles).


## Connect your local development cluster to AutoOps

Complete the following steps to connect your local development cluster to AutoOps.
1. Run the following command in your terminal to open the `/etc/hosts` file in a text editor with administrator privileges:

```sh
vim /etc/hosts
```

1. On a new line in the `/etc/hosts` file, add an entry to map the Elasticsearch cluster URL to the IP address representing the local development cluster.
   The entry should be formatted as `127.0.0.1 {{hostname}}`.
2. Save the changes.
3. In your terminal, run the following command to reload the hostname service:
   - For Linux:
   ```sh
   /bin/systemctl restart systemd-hostnamed
   ```
   - For macOS:
   ```sh
   sudo dscacheutil -flushcache
   ```
4. Follow the instructions to [Connect to AutoOps](/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops#connect-to-autoops) with the following differences:
   - In the [Select installation method](/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops#select-installation-method) step, select **Docker**.
- In the [Configure agent](/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops#configure-agent) step, when prompted to enter your **Elasticsearch endpoint URL**, enter the name of your local development cluster or enter the following:
  ```sh
  http://localhost:9200
  ```
- In the [Install agent](/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops#install-agent) step, paste the command into the text editor and replace `docker run -d \` with:
  ```sh
  docker run -d --network host \
  ```
  This replacement is also required if your cluster is running on macOS.

After completing all the steps, you can [Access AutoOps](/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops#access-autoops).