﻿---
title: AutoOps for ECE, ECK, or self-managed clusters troubleshooting
description: Learn about issues that might come up when connecting your clusters and using AutoOps. Use this guide to troubleshoot any issues you may encounter. I’m...
url: https://www.elastic.co/docs/deploy-manage/monitor/autoops/cc-cloud-connect-autoops-troubleshooting
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# AutoOps for ECE, ECK, or self-managed clusters troubleshooting
Learn about issues that might come up when connecting your clusters and using AutoOps.

## Troubleshoot issues

Use this guide to troubleshoot any issues you may encounter.
- [I’m trying to create a Cloud organization, but I’m already part of a different one.](#single-cloud-org)
- [I need to uninstall Elastic Agent.](#unistall-agent)
- [My cluster was disconnected from Elastic Cloud and I want to reconnect it.](#disconnected-cluster)
- [After running the installation command, I can't move on to the next steps.](#next-steps)
- [My organization's firewall may be preventing Elastic Agent from collecting and sending metrics.](#firewall)
- [Elastic Agent is failing to connect because it doesn't recognize my SSL certificate.](#custom-cert)
- [I went through the wizard with Elastic Cloud on Kubernetes (ECK) as my installation method, but I can't view any connected clusters in my account.](#eck-no-clusters) <applies-to>Elastic Cloud on Kubernetes: Generally available since 3.3</applies-to>

<definitions>
  <definition term="I’m trying to create a Cloud organization, but I’m already part of a different one.">
    Users can only belong to one Elastic Cloud organization at a time. If you want to create or join another organization, you must [leave the previous one](/docs/cloud-account/join-or-leave-an-organization#ec-leave-organization) or use a different email address.
  </definition>
  <definition term="I need to uninstall Elastic Agent.">
    Refer to [Uninstall Elastic Agent](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/uninstall-elastic-agent) for instructions.
  </definition>
  <definition term="My cluster was disconnected from Elastic Cloud and I want to reconnect it.">
    If the cluster was disconnected by one of the users in your Cloud organization, you can repeat the [installation process](https://www.elastic.co/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops) to reconnect. If not, explore [additional resources](/docs/troubleshoot#troubleshoot-additional-resources) or [contact us](/docs/troubleshoot#contact-us).
  </definition>
  <definition term="After running the installation command, I can't move on to the next steps.">
    If an error appears on the screen, follow the suggestion in the error message and try to run the command again. If the issue is not resolved, explore [additional resources](/docs/troubleshoot#troubleshoot-additional-resources) or [contact us](/docs/troubleshoot#contact-us).
  </definition>
  <definition term="My organization's firewall may be preventing Elastic Agent from collecting and sending metrics.">
    If you're having issues with connecting your cluster to AutoOps and you suspect that a firewall may be the reason, refer to [Troubleshoot firewalls blocking Elastic Agent](https://www.elastic.co/docs/deploy-manage/monitor/autoops/autoops-sm-troubleshoot-firewalls).
  </definition>
  <definition term="Elastic Agent is failing to connect because it doesn't recognize my SSL certificate.">
    If Elastic Agent is failing to connect your cluster to AutoOps because it doesn't recognize your SSL certificate, refer to [Configure AutoOps Elastic Agent with a custom SSL certificate](https://www.elastic.co/docs/deploy-manage/monitor/autoops/autoops-sm-custom-certification).
  </definition>
  <definition term="I went through the wizard with Elastic Cloud on Kubernetes (ECK) as my installation method, but I can't view any connected clusters in my account. Elastic Cloud on Kubernetes: Generally available since 3.3">
    Refer to [Troubleshoot connected clusters not appearing with ECK installation](https://www.elastic.co/docs/deploy-manage/monitor/autoops/autoops-sm-troubleshoot-eck-no-clusters) to diagnose and resolve common issues.
  </definition>
</definitions>


## Potential errors

The following table shows the errors you might encounter if something goes wrong while you set up and use AutoOps on your clusters.

| Error code                        | Error message                                                                  | Description                                                                                                                                                                                                                                                                                      |
|-----------------------------------|--------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `HTTP_401`                        | Authentication failed                                                          | Connection denied because of an authentication error. Verify that your API key and password are correct and all [necessary privileges](/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops#configure-agent) have been granted.                                                |
| `HTTP_502`                        | Server error                                                                   | Received an invalid response from the server. Verify the server status and network configuration.                                                                                                                                                                                                |
| `HTTP_503`                        | Server unavailable                                                             | Invalid or corrupt response received from the server. The server acting as a proxy may be busy or undergoing scheduled maintenance. If the issue persists, check the cluster's health and resource usage.                                                                                        |
| `HTTP_504`                        | Request timed out                                                              | Did not receive a response from the cluster within the expected time frame. Check the cluster's performance or consider changing your connection timeout settings.                                                                                                                               |
| `CLUSTER_ALREADY_CONNECTED`       | Cluster connected to another account                                           | This cluster is already connected to another Elastic Cloud organization. Disconnect it and then try again.                                                                                                                                                                                       |
| `CLUSTER_NOT_READY`               | Elasticsearch cluster is still connecting                                      | Your Elasticsearch cluster is not yet ready to connect. Wait a few moments for it to finish starting up and then try again.                                                                                                                                                                      |
| `HTTP_0`                          | Connection error                                                               | Elastic Agent couldn't connect to the cluster. There may be various reasons for this issue. Review the [documentation](https://www.elastic.co/docs/deploy-manage/monitor/autoops/cc-autoops-as-cloud-connected) or contact [Elastic support](https://support.elastic.co/) if the issue persists. |
| `LICENSE_EXPIRED`                 | Elastic license is expired                                                     | Contact [sales](https://www.elastic.co/contact#sales) to renew your license.                                                                                                                                                                                                                     |
| `LICENSE_USED_BY_ANOTHER_ACCOUNT` | License key connected to another account                                       | A license key can only be connected to one Elastic Cloud organization. Contact [Elastic support](https://support.elastic.co/) for help.                                                                                                                                                          |
| `VERSION_MISMATCH`                | Elasticsearch version is unsupported                                           | Upgrade your cluster to a [supported version](https://www.elastic.co/support/eol).                                                                                                                                                                                                               |
| `UNKNOWN_ERROR`                   | Installation failed                                                            | Elastic Agent couldn't be installed due to an unknown issue. Consult the troubleshooting guide or contact [Elastic support](https://support.elastic.co/) for more help.                                                                                                                          |
|                                   | Failed to register Cloud Connected Mode: cluster license type is not supported | The cluster you are trying to connect doesn't have the required license to connect to AutoOps. For more information, refer to the [prerequisites](/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops#prerequisites).                                                         |
| `x509`                            | Certificate signed by unknown authority                                        | Elastic Agent couldn't connect. SSL certificate signed by unknown authority.                                                                                                                                                                                                                     |