﻿---
title: AutoOps for ECE, ECK, and self-managed clusters
description: For ECE (Elastic Cloud Enterprise), ECK (Elastic Cloud on Kubernetes), and self-managed Elasticsearch clusters, AutoOps can be set up through Cloud Connect...
url: https://www.elastic.co/docs/deploy-manage/monitor/autoops/cc-autoops-as-cloud-connected
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# AutoOps for ECE, ECK, and self-managed clusters
For ECE (Elastic Cloud Enterprise), ECK (Elastic Cloud on Kubernetes), and self-managed Elasticsearch clusters, AutoOps can be set up through [Cloud Connect](https://www.elastic.co/docs/deploy-manage/cloud-connect).
Cloud Connect enables users of ECE, ECK, and self-managed clusters to use Elastic Cloud services. This means you can take advantage of the simplified cluster monitoring, real-time issue detection, and performance recommendations of AutoOps without having to run and manage the underlying infrastructure.

## How your cluster connects to AutoOps

To connect your ECE, ECK, or self-managed cluster to AutoOps, you have to use your Elastic Cloud account to install Elastic Agent. After that, the process can be broken down into three components:
1. Elastic Agent connects to your ECE, ECK, or self-managed Elasticsearch cluster.
2. The agent registers your cluster with Elastic Cloud using the Cloud Connect API.
3. The agent begins to send metrics from your cluster to AutoOps in your selected CSP region.

![Diagram depicting how AutoOps for ECE, ECK, and self-managed clusters works](https://www.elastic.co/docs/deploy-manage/images/self-managed-autoops-diagram.png)

For instructions on how to get started, refer to [Connect your ECE, ECK, or self-managed cluster to AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops).
After this setup is complete, you can start using AutoOps to monitor your cluster. Learn more about what you can do with AutoOps in [views](https://www.elastic.co/docs/deploy-manage/monitor/autoops/views) and [events](https://www.elastic.co/docs/deploy-manage/monitor/autoops/ec-autoops-events).

## Section overview

In this section, you'll find the following information:
- How to [connect your ECE, ECK, or self-managed cluster to AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops)
- How to [connect your local development cluster to AutoOps](https://www.elastic.co/docs/deploy-manage/monitor/autoops/cc-connect-local-dev-to-autoops)
- How to [manage users of your connected clusters](https://www.elastic.co/docs/deploy-manage/monitor/autoops/cc-manage-users)
- A [troubleshooting guide](https://www.elastic.co/docs/deploy-manage/monitor/autoops/cc-cloud-connect-autoops-troubleshooting) to help you with any issues you may encounter

<tip>
  Refer to our [FAQ](/docs/deploy-manage/monitor/autoops/ec-autoops-faq#questions-about-autoops-for-ece-eck-or-self-managed-clusters) for answers to frequently asked questions about AutoOps for ECE, ECK, or self-managed clusters.
</tip>