﻿---
title: Troubleshoot firewalls blocking Elastic Agent
description: If you are running into issues connecting your ECE, ECK, or self-managed cluster to AutoOps, a corporate firewall might be blocking Elastic Agent. Complete...
url: https://www.elastic.co/docs/deploy-manage/monitor/autoops/autoops-sm-troubleshoot-firewalls
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Troubleshoot firewalls blocking Elastic Agent
If you are running into issues connecting your ECE, ECK, or self-managed cluster to AutoOps, a corporate firewall might be blocking Elastic Agent.
Complete the steps on this page to test your setup and fix this issue.

## Confirm that Elastic Agent has appropriate access

If your organization uses firewalls, you have to [give Elastic Agent access to required ports and URLs](/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops#firewall-allowlist) during setup.
Ensure that you have allowed Elastic Agent the required level of access. If the problem persists, move on to the next section.

## Test Elastic Agent's connection with your system

There are [three main components](/docs/deploy-manage/monitor/autoops/cc-autoops-as-cloud-connected#how-your-cluster-connects-to-autoops) of Elastic Agent's connection with your system:
1. Elastic Agent connects to your ECE, ECK, or self-managed Elasticsearch cluster.
2. The agent registers your cluster with Elastic Cloud using the Cloud Connect API.
3. The agent begins to send metrics from your cluster to AutoOps in your selected CSP region.

The following subsections describe how to test each of these components to find out where the problem lies, and then implement an appropriate solution.
<tip>
  Run the following tests within the context of your execution environment. That is, if your chosen installation method is Kubernetes, run the commands from within the pod; for Docker, run the commands from within the container, and so on.
</tip>


### 1. Test Elastic Agent's connection with your cluster

If there is an issue with the first component, Elastic Agent cannot connect to your cluster.
To test if your organization is not allowing this connection, run the following command depending on your chosen authentication method:
<tab-set>
  <tab-item title="API key">
    ```json
    curl -XGET -i $AUTOOPS_ES_URL \
    -H "Authorization: ApiKey $AUTOOPS_ES_API_KEY"
    ```
  </tab-item>

  <tab-item title="Basic">
    ```json
    curl -XGET -i $AUTOOPS_ES_URL \
    -u $AUTOOPS_ES_USERNAME
    ```
  </tab-item>
</tab-set>

The command returns a response similar to the following:
```json
{
"name" : "1c72f00a6195",
"cluster_name" : "my-ccm-cluster",
"cluster_uuid" : "2O_EjO6kTR6AEVYwL5fPEw",
"version" : {
"number" : "9.1.3",
"build_flavor" : "default",
"build_type" : "docker",
"build_hash" : "0c781091a2f57de895a73a1391ff8426c0153c8d",
"build_date" : "2025-08-24T22:05:04.526302670Z",
"build_snapshot" : false,
"lucene_version" : "10.2.2",
"minimum_wire_compatibility_version" : "8.19.0",
"minimum_index_compatibility_version" : "8.0.0"
},
"tagline" : "You Know, for Search"
}
```

If you do not receive a similar response, your system returns an error indicating one or more reasons for the failure as outlined in the following table. Use the corresponding proposed solution to fix the issue.

| Reason for failure                                                                              | Proposed solution                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| The Elasticsearch endpoint URL you specified is incorrect/not reachable                         | - Make sure you are using the correct protocol in the cluster URL:`http` or `https`.  - Make sure you are providing the correct port. The default port is **9200**.  - If you have verified that the URL is correct, your network team might need to open the firewall to allow-list this URL.                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| Your API key is incorrect                                                                       | - Recheck for typos.  - If your cluster is on versions 9.1.0 through 9.1.3, ensure that you have the base64-decoded version of the key by running the following command:  `echo $AUTOOPS_ES_API_KEY | base64 -d`  If your key has a colon (:), it is not base64 encoded. If your key has an equal sign (=), it is base64 coded.  For versions 9.1.4 and above, both formats work.                                                                                                                                                                                                                                                                                                                                                                        |
| Your username or password is incorrect                                                          | - Recheck for typos.  - Ensure that your provided user has the [necessary privileges](/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops#configure-agent). We do not recommend providing a privileged superuser like `elastic` for this purpose.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| You are providing both the API key and username/password                                        | Choose one type of authentication only.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| A proxy is blocking communication with your Elasticsearch cluster                               | You might have to [configure `NO_PROXY`](https://www.elastic.co/docs/reference/fleet/host-proxy-env-vars).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| You are using a custom SSL/TLS configuration with Elasticsearch                                 | Disable SSL/TLS verification so that your system trusts all certificates. We do not recommend disabling verification in production environments.  If you are using API key authentication, run the following command: `curl -XGET --insecure -i $AUTOOPS_ES_URL \ -H "Authorization: ApiKey $AUTOOPS_ES_API_KEY"`.  If you are using username/password authentication, run the following command:  `curl -XGET --insecure -i $AUTOOPS_ES_URL \ -u $AUTOOPS_ES_USERNAME`  If the issue is resolved, you need to [configure Elastic Agent with your custom SSL/TLS certificate](https://www.elastic.co/docs/deploy-manage/monitor/autoops/autoops-sm-custom-certification). If the issue persists, contact [Elastic support](https://support.elastic.co/). |
| You are connecting a local development cluster using Docker without specifying `--network host` | - Make sure you are following all the steps to [connect your local development cluster to AutoOps](/docs/deploy-manage/monitor/autoops/cc-connect-local-dev-to-autoops#connect-your-local-development-cluster-to-autoops).  - In the [Install agent](/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops#install-agent) step, make sure you are replacing `docker run -d \` with `docker run -d --network host \`.                                                                                                                                                                                                                                                                                                                    |


### 2. Test your cluster's registration with Elastic Cloud

If there is an issue with the second component, the agent stops working and your logs might show the following error:
```sh
... failed to register Cloud Connected Mode: ... Post \"https://api.elastic-cloud.com/api/v1/cloud-connected/clusters\": ...
```

To test if your organization is not allowing the agent to register your cluster with Elastic Cloud, run the following command:
```json
curl -XPOST -i \
https://api.elastic-cloud.com/api/v1/cloud-connected/clusters \
-H 'Content-Type: application/json' \
-d '{"self_managed_cluster": {"id": "my-cluster-uuid", "name": "my-cluster-name", "version": "9.1.0"}, "license": {"uid": "my-license-id", "type": "basic"}}'
```

The command should return an HTTP 401 response:
```json
      {"UnauthorizedMessages":["Invalid credential headers"],"Cause":null}
```

If you do not receive a similar response, configure your HTTP proxy to allow it to reach the URL (with headers and a JSON body):
```json
      POST https://api.elastic-cloud.com/api/v1/cloud-connected/clusters
```

<note>
  If you are using Docker, you might need to complete this configuration directly using the `HTTP_PROXY`, `HTTPS_PROXY`, and `NO_PROXY` environment variables.
</note>


### 3. Test if Elastic Agent is able to send metrics

If there is an issue with the third component, the agent attempts to establish the connection and your logs might show the following error:
```sh
... Exporting failed. Dropping data. ... no more retries left: failed to make an HTTP request: Post \"https://otel-auto-ops.eu-west-1.aws.cloud.elastic.co:443/v1/logs\": ...
```

To test if your organization is not allowing the agent to send metrics from your cluster to Elastic Cloud, run the following command. The command uses AWS eu-west-1 as the CSP (cloud service provider) region, but you should replace it with your chosen CSP region before running the command.
```json
curl -XPOST -i \
https://otel-auto-ops.eu-west-1.aws.cloud.elastic.co:443/v1/logs \
-H 'Content-Type: application/json'
```

The command should return an HTTP 401 response:
```json
  {"code":16,"message":"no auth provided"}
```

If you do not receive a similar response, configure your HTTP proxy to allow it to reach the URL (with headers and an arbitrary body):
```json
  POST https://otel-auto-ops.${REGION}.${CSP}.cloud.elastic.co:443/v1/logs
```

<note>
  If you are using Docker, you might need to complete this configuration directly using the `HTTP_PROXY`, `HTTPS_PROXY`, and `NO_PROXY` environment variables.
</note>