﻿---
title: Troubleshoot connected clusters not appearing with ECK installation
description: If you are using the ECK installation method (AutoOpsAgentPolicy resource) to connect your Elasticsearch clusters to AutoOps, but you can't view any connected...
url: https://www.elastic.co/docs/deploy-manage/monitor/autoops/autoops-sm-troubleshoot-eck-no-clusters
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available since 3.3
---

# Troubleshoot connected clusters not appearing with ECK installation
If you are using the ECK installation method (`AutoOpsAgentPolicy` resource) to connect your Elasticsearch clusters to AutoOps, but you can't view any connected clusters in your account, go through this guide to diagnose and fix common issues.

## Verify `AutoOpsAgentPolicy` status

Check if the `AutoOpsAgentPolicy` resource was successfully created and the ECK operator is processing it correctly.
<stepper>
  <step title="Check if the policy was created">
    Run the following command.
    ```shell
    kubectl get autoopsagentpolicy <policy_name>
    ```
    If the policy doesn't appear, there was an issue with its creation.If the policy appears, run the following command to check its status and any associated events.
    ```shell
    kubectl describe autoopsagentpolicy <policy_name>
    ```
  </step>

  <step title="Confirm the issue by checking logs">
    Run the following command to show logs.
    ```shell
    kubectl logs -f -n <ECK_operator_namespace> -l control-plane=elastic-operator
    ```
    If the log contains any errors mentioning `AutoOpsAgentPolicy` or the policy's name, this confirms that the policy's creation and processing is causing the issue.
  </step>

  <step title="Re-add the YAML manifest to your configuration file">
    Repeat the steps to [install the agent](/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops#install-agent) with ECK as your installation method. This should resolve any issues with the policy.
  </step>
</stepper>


## Verify that Elastic Agent was deployed

Check if `AutoOpsAgentPolicy` successfully deployed Elastic Agent for your Elasticsearch clusters.
<stepper>
  <step title="List agent deployments">
    Run the following command.
    ```shell
    kubectl get deployments -l autoops.k8s.elastic.co/policy-name=<policy_name>
    ```
    If no deployments appear, there might be an issue with the `resourceSelector` label applied to your Elasticsearch clusters. If deployments appear but pods are not running, there might be an issue with a specific pod.
  </step>

  <step title="Check cluster labels and agent pods">
    If no deployments appeared in the previous step, run the following command to check your cluster labels.
    ```shell
    kubectl get elasticsearch <elasticsearch_cluster_name> --show-labels
    ```
    Make sure that the label you applied in the [Launch AutoOps](/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops#launch-autoops) step of the wizard appears correctly in the list.If deployments appeared in the previous step, run the following command to check pod status.
    ```shell
    kubectl get pods -l autoops.k8s.elastic.co/policy-name=<policy_name>
    ```
    If the status indicates that a pod is crashing or in a pending state, run the following command to inspect its events:
    ```shell
    kubectl describe pod <agent_pod_name>
    ```
  </step>
</stepper>


## Validate connection secrets

Make sure there are no errors in your secret keys.
<stepper>
  <step title="Verify secret content">
    Run the following command.
    ```shell
    kubectl get secret <secret_name> -o yaml
    ```
    Make sure the secret has the following required keys:
    - `autoops-token`
    - `autoops-otel-url`
    - `cloud-connected-mode-api-key`
  </step>

  <step title="Confirm secret reference">
    Run the following command to confirm that `AutoOpsAgentPolicy` is actually referencing the correct configuration.
    ```shell
    kubectl get autoopsagentpolicy <policy_name> -o jsonpath='{.spec.autoOpsRef.secretName}'
    ```
    The command should return the correct `.spec.autoOpsRef.secretName`.
  </step>
</stepper>


## Check for authorization errors

When you go through the installation wizard, the ECK operator attempts to create an API key for Elastic Agent within Elasticsearch. If there is an issue with this creation, authorization errors will appear in the operator logs.
<stepper>
  <step title="Pull operator logs">
    Run the following command.
    ```shell
    kubectl logs -f -n <ECK_operator_namespace> -l control-plane=elastic-operator
    ```
  </step>

  <step title="Inspect logs">
    If any errors in the logs mention "authorization" or "unauthorized connection", go through the installation wizard again so that the operator can reattempt creating a user or API key.
  </step>


  ## Ensure that Elastic Agent is allowed to send data to AutoOps

  If your organization uses firewalls, you need to provide access to port 443 and allow the agent to send data to the following URLs:
  - `https://api.elastic-cloud.com`
  - `https://otel-auto-ops.${region}.${csp}.svc.elastic.cloud/`
    Replace `${region}` and `${csp}` with the region and cloud service provider you have selected as your [storage location](/docs/deploy-manage/monitor/autoops/cc-connect-self-managed-to-autoops#storage-location). For example:
    `https://otel-auto-ops.us-east-1.aws.svc.elastic.cloud/`

  Learn more about [defining an Elastic IP address](/docs/deploy-manage/monitor/autoops/ec-autoops-faq#elastic-ip-address) for AutoOps for ECE, ECK, or self-managed clusters.

  ## Check cluster healthEnsure that the Elasticsearch clusters you are trying to connect to AutoOps are healthy. Elastic Agent may fail to connect clusters in a Red state.
</stepper>