﻿---
title: AutoOps
description: AutoOps diagnoses issues in Elasticsearch by analyzing hundreds of metrics, providing root-cause analysis and accurate resolution paths. With AutoOps,...
url: https://www.elastic.co/docs/deploy-manage/monitor/autoops
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud Hosted
  - Elastic Cloud Serverless
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# AutoOps
AutoOps diagnoses issues in Elasticsearch by analyzing hundreds of metrics, providing root-cause analysis and accurate resolution paths. With AutoOps, customers can prevent and resolve issues, cut down administration time, and optimize resource utilization.
![Screenshot showing the Overview page in AutoOps](https://www.elastic.co/docs/deploy-manage/images/cloud-autoops-overview-page.png)


## Key features in AutoOps

- Real-time root-cause analysis for hundreds of issues.
- Accurate resolution paths and customized recommendations.
- Insight into what occurred and detailed views into nodes, index, shards, and templates.
- Wide range of insights, including:
  - Cluster status, node failures, and shard sizes.
- High CPU, memory, disk usage, and other resource-related metrics.
- Misconfigurations and possible optimizations.
- Insights on data structure, shards, templates, and mapping optimizations.
- Unbalanced loads between nodes.
- Indexing latency, rejections, search latency, high index/search queues, and slow queries.
- Resource utilization.
- Multi-deployment dashboard to quickly spot issues across all clusters.
- Possibility to customize event triggers and connect to different notification services such as PagerDuty, Slack, MS Teams, and webhooks.
- Coming soon: Long-term reports for sustained evaluation.


## Regions where AutoOps is available

Depending on your deployment type, AutoOps has been rolled out across various [regions](https://www.elastic.co/docs/deploy-manage/monitor/autoops/ec-autoops-regions). More regions and CSPs are coming soon.

## Deployment types where AutoOps is available

AutoOps is automatically available in [Elastic Cloud Hosted deployments](https://www.elastic.co/docs/deploy-manage/monitor/autoops/ec-autoops-how-to-access) and [Elastic Cloud Serverless projects](https://www.elastic.co/docs/deploy-manage/monitor/autoops/autoops-for-serverless), and can be set up for [ECE, ECK, and self-managed clusters](https://www.elastic.co/docs/deploy-manage/monitor/autoops/cc-autoops-as-cloud-connected) through Cloud Connect.
AutoOps is currently not available for air-gapped environments because it's a cloud service and you need an internet connection to send metrics to Elastic Cloud. However, we plan to offer a locally deployable version in the future.

## How AutoOps is licensed

For Elastic Cloud Hosted deployments and Serverless projects, AutoOps is available to Elastic Cloud customers at all subscription levels at no additional cost, and it does not consume ECU.
Using AutoOps for self-managed clusters (ECE, ECK, or standalone) on-premise or in private cloud environments through Cloud Connect is included with [self-managed Enterprise licenses](https://www.elastic.co/subscriptions) and self-managed free trials. This does not consume ECU.

## How long AutoOps retains data

AutoOps currently has a 10 day retention period.

## What AutoOps monitors

AutoOps currently only monitors Elasticsearch, not the entire Elastic Stack. AutoOps is compatible with [supported Elasticsearch versions](https://www.elastic.co/support/eol)(7.17.x and above). We plan to expand AutoOps monitoring to the entire stack in the future.

## Section overview

In this section, you'll find the following information:
- How to [access AutoOps in your Elastic Cloud Hosted deployments](https://www.elastic.co/docs/deploy-manage/monitor/autoops/ec-autoops-how-to-access).
- How to [use AutoOps in your Elastic Cloud Serverless projects](https://www.elastic.co/docs/deploy-manage/monitor/autoops/autoops-for-serverless).
- How to [connect your ECE, ECK, or self-managed clusters](https://www.elastic.co/docs/deploy-manage/monitor/autoops/cc-autoops-as-cloud-connected) to AutoOps.
- [Regions](https://www.elastic.co/docs/deploy-manage/monitor/autoops/ec-autoops-regions) where AutoOps is available.
- Which [views](https://www.elastic.co/docs/deploy-manage/monitor/autoops/views) AutoOps offers to gain insight into your deployment.
- What AutoOps [events](https://www.elastic.co/docs/deploy-manage/monitor/autoops/ec-autoops-events) are and how you can configure [event settings](https://www.elastic.co/docs/deploy-manage/monitor/autoops/ec-autoops-event-settings) and [notifications](https://www.elastic.co/docs/deploy-manage/monitor/autoops/ec-autoops-notifications-settings).
- [Frequently asked questions](https://www.elastic.co/docs/deploy-manage/monitor/autoops/ec-autoops-faq) about AutoOps.