﻿---
title: Using Spaces with Fleet
description: Fleet supports a space-aware data model. You can use Kibana spaces to manage Agent policies and integrations per space. Combined with granular user roles,...
url: https://www.elastic.co/docs/deploy-manage/manage-spaces-fleet
products:
  - Elastic Agent
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.1
---

# Using Spaces with Fleet
Fleet supports a **space-aware** data model. You can use [Kibana spaces](https://www.elastic.co/docs/deploy-manage/manage-spaces) to manage Agent policies and integrations per space. Combined with granular [user roles](https://www.elastic.co/docs/reference/fleet/fleet-roles-privileges), this feature enables true role-based access control for Elastic Agent management.
For **new deployments** on Elastic Stack 9.1.0 or later, space awareness is enabled by default.
For **upgraded deployments** from earlier versions, you must explicitly [enable space awareness](#spaces-fleet-enable).
To use space awareness with Fleet:
- [Enable the space awareness feature](#spaces-fleet-enable) (for upgraded deployments)
- [Assign and manage Agent policies across spaces](#spaces-manage-policies)
- [Make integration assets available across spaces](#spaces-manage-assets)


## Enable space awareness in Fleet

You must enable space awareness for deployments upgraded to 9.1.0 or later. Space awareness requires a one-time migration that copies your existing Fleet data into a new, space-aware model. Previous data is preserved in snapshots in case you need to roll back.
To enable space awareness in upgraded deployments:
1. Navigate to the **Fleet** app.
2. Click the **Settings** tab.
3. Scroll to **Advanced settings**.
4. Under **Migrate to space-aware agent policies**, click **Start migration**.
5. Confirm the migration.


## Manage Agent policies across spaces

To control where an Agent Policy is available:
1. Navigate to the Agent Policy’s **Settings** tab.
   ![Agent Policy settings tab](https://www.elastic.co/docs/deploy-manage/images/kibana-space-fleet-policy.png)
2. Use the **Spaces** dropdown to select one or more spaces.
   ![Agent Policy spaces dropdown](https://www.elastic.co/docs/deploy-manage/images/kibana-space-policy-settings.png)

Agent policies can be assigned to multiple spaces. In this example, the policy is visible in both the "Default" space and "My second space."
![Policy in multiple spaces](https://www.elastic.co/docs/deploy-manage/images/kibana-space-multispace.png)

Access to a policy is still governed by each user's Fleet permissions within selected spaces.

## Manage integration assets across spaces

When you add an integration to an Agent policy, assets such as dashboards and visualizations are installed **only in the current space** by default.
If the Agent Policy spans multiple spaces, install the integration's assets in each space manually:
1. Switch to the desired Kibana space.
2. Go to the **Integrations** app > **Installed integrations** tab.
3. Click the name of the integration.
   ![Installed integrations list](https://www.elastic.co/docs/deploy-manage/images/kibana-space-integration.png)
4. Open the **Assets** tab.
   ![Kibana Assets tab](https://www.elastic.co/docs/deploy-manage/images/kibana-space-add-asset.png)
5. Click **Install Kibana assets in current space**.

This installs dashboards and other UI assets into the selected space.
<note>
  Due to limitations in Kibana’s saved object model, integration assets are copied per space. These saved objects are considered **managed** and are **readonly**.
</note>