﻿---
title: Start and stop Kibana
description: The method for starting and stopping Kibana varies depending on how you installed it.  If a password protected keystore is used, the environment variable...
url: https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/start-stop-kibana
products:
  - Kibana
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Start and stop Kibana
The method for starting and stopping Kibana varies depending on how you installed it.  If a password protected keystore is used, the environment variable `KBN_KEYSTORE_PASSPHRASE_FILE` can be used to point to a file containing the password, the environment variable `KEYSTORE_PASSWORD` can be defined, or you will be prompted to enter to enter the password on startup,

## Archive packages (`.tar.gz`)

If you installed Kibana on Linux or Darwin with a `.tar.gz` package, you can start and stop Kibana from the command line.

### Run Kibana from the command line

Kibana can be started from the command line as follows:
```sh
./bin/kibana
```

By default, Kibana runs in the foreground, prints its logs to the standard output (`stdout`), and can be stopped by pressing **Ctrl-C**.
If this is the first time you’re starting Kibana, this command generates a unique link in your terminal to enroll your Kibana instance with Elasticsearch.
1. In your terminal, click the generated link to open Kibana in your browser.
2. In your browser, paste the enrollment token that was generated in the terminal when you started Elasticsearch, and then click the button to connect your Kibana instance with Elasticsearch.
3. Log in to Kibana as the `elastic` user with the password that was generated when you started Elasticsearch.

<note>
  If you need to reset the password for the `elastic` user or other built-in users, run the [`elasticsearch-reset-password`](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/reset-password) tool. To generate new enrollment tokens for Kibana or Elasticsearch nodes, run the [`elasticsearch-create-enrollment-token`](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/create-enrollment-token) tool. These tools are available in the Elasticsearch `bin` directory.
</note>


## Archive packages (`.zip`)

If you installed Kibana on Windows with a `.zip` package, you can stop and start Kibana from the command line.

### Run Kibana from the command line

Kibana can be started from the command line as follows:
```sh
.\bin\kibana.bat
```

By default, Kibana runs in the foreground, prints its logs to `STDOUT`, and can be stopped by pressing **Ctrl-C**.
If this is the first time you’re starting Kibana, this command generates a unique link in your terminal to enroll your Kibana instance with Elasticsearch.
1. In your terminal, click the generated link to open Kibana in your browser.
2. In your browser, paste the enrollment token that was generated in the terminal when you started Elasticsearch, and then click the button to connect your Kibana instance with Elasticsearch.
3. Log in to Kibana as the `elastic` user with the password that was generated when you started Elasticsearch.

<note>
  If you need to reset the password for the `elastic` user or other built-in users, run the [`elasticsearch-reset-password`](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/reset-password) tool. To generate new enrollment tokens for Kibana or Elasticsearch nodes, run the [`elasticsearch-create-enrollment-token`](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/create-enrollment-token) tool. These tools are available in the Elasticsearch `bin` directory.
</note>


## Debian and RPM packages


### Run Kibana with `systemd`

To configure Kibana to start automatically when the system starts, run the following commands:
```sh
sudo /bin/systemctl daemon-reload
sudo /bin/systemctl enable kibana.service
```

Kibana can be started and stopped as follows:
```sh
sudo systemctl start kibana.service
sudo systemctl stop kibana.service
```

These commands provide no feedback as to whether Kibana was started successfully or not. Log information can be accessed via `journalctl -u kibana.service`.