﻿---
title: Start and stop Elasticsearch
description: Understanding how to properly start and stop Elasticsearch is essential for maintaining a stable and efficient cluster. This guide outlines the recommended...
url: https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/start-stop-elasticsearch
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Start and stop Elasticsearch
Understanding how to properly start and stop Elasticsearch is essential for maintaining a stable and efficient cluster. This guide outlines the recommended methods for starting and stopping Elasticsearch safely, considering the different installation types, including package-based installations, Docker containers, and manually extracted archives.

## Starting Elasticsearch

The method for starting Elasticsearch varies depending on how you installed it.

### Archive packages (`.tar.gz`)

If you installed Elasticsearch on Linux or MacOS with a `.tar.gz` package, you can start Elasticsearch from the command line.

#### Run Elasticsearch from the command line

Run the following command to start Elasticsearch from the command line:
```sh
./bin/elasticsearch
```

By default, Elasticsearch prints its logs to the console (`stdout`) and to the `<cluster name>.log` file within the [logs directory](/docs/deploy-manage/deploy/self-managed/important-settings-configuration#path-settings). Elasticsearch logs some information while it is starting, but after it has finished initializing it will continue to run in the foreground and won’t log anything further until something happens that is worth recording. While Elasticsearch is running you can interact with it through its HTTP interface which is on port `9200` by default.
To stop Elasticsearch, press `Ctrl-C`.
<note>
  All scripts packaged with Elasticsearch require a version of Bash that supports arrays and assume that Bash is available at `/bin/bash`. As such, Bash should be available at this path either directly or via a symbolic link.
</note>

If you're starting Elasticsearch for the first time, then Elasticsearch also enables and configures security. [Learn more](/docs/deploy-manage/deploy/self-managed/install-elasticsearch-from-archive-on-linux-macos#security-at-startup).

#### Run as a daemon

To run Elasticsearch as a daemon, specify `-d` on the command line, and record the process ID in a file using the `-p` option:
```sh
./bin/elasticsearch -d -p pid
```

If you have password-protected the Elasticsearch keystore, you will be prompted to enter the keystore’s password. See [Secure settings](https://www.elastic.co/docs/deploy-manage/security/secure-settings) for more details.
Log messages can be found in the `$ES_HOME/logs/` directory.
To shut down Elasticsearch, kill the process ID recorded in the `pid` file:
```sh
pkill -F pid
```

<note>
  The Elasticsearch `.tar.gz` package does not include the `systemd` module. To manage Elasticsearch as a service, use the [Debian](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-kibana-with-debian-package) or [RPM](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-kibana-with-rpm) package instead.
</note>


### Archive packages (`.zip`)

If you installed Elasticsearch on Windows with a `.zip` package, you can start Elasticsearch from the command line. If you want Elasticsearch to start automatically at boot time without any user interaction, [install Elasticsearch as a service](/docs/deploy-manage/deploy/self-managed/install-elasticsearch-with-zip-on-windows#windows-service).
Run the following command to start Elasticsearch from the command line:
```sh
.\bin\elasticsearch.bat
```

By default Elasticsearch prints its logs to the console (`STDOUT`) and to the `<cluster name>.log` file within the [logs directory](/docs/deploy-manage/deploy/self-managed/important-settings-configuration#path-settings). Elasticsearch logs some information while it is starting, but after it has finished initializing it will continue to run in the foreground and won’t log anything further until something happens that is worth recording. While Elasticsearch is running you can interact with it through its HTTP interface which is on port `9200` by default.
To stop Elasticsearch, press `Ctrl-C`.
If you're starting Elasticsearch for the first time, then Elasticsearch also enables and configures security. [Learn more](/docs/deploy-manage/deploy/self-managed/install-elasticsearch-with-zip-on-windows#security-at-startup).

### Debian or RPM packages (using `systemd`)

To configure Elasticsearch to start automatically when the system boots up, run the following commands:
```sh
sudo /bin/systemctl daemon-reload
sudo /bin/systemctl enable elasticsearch.service
```

Elasticsearch can be started and stopped as follows:
```sh
sudo systemctl start elasticsearch.service
sudo systemctl stop elasticsearch.service
```

These commands provide no feedback as to whether Elasticsearch was started successfully or not. Instead, this information will be written in the log files located in `/var/log/elasticsearch/`.
If you have password-protected your Elasticsearch keystore, you will need to provide `systemd` with the keystore password using a local file and systemd environment variables. This local file should be protected while it exists and may be safely deleted once Elasticsearch is up and running.
```sh
echo "keystore_password" > /path/to/my_pwd_file.tmp
chmod 600 /path/to/my_pwd_file.tmp
sudo systemctl set-environment ES_KEYSTORE_PASSPHRASE_FILE=/path/to/my_pwd_file.tmp
sudo systemctl start elasticsearch.service
```

<admonition title="Startup timeouts with older systemd versions">
  By default Elasticsearch sets the `TimeoutStartSec` parameter to `systemd` to `900s`. If you are running at least version 238 of `systemd`, then Elasticsearch can automatically extend the startup timeout, and will do so repeatedly until startup is complete even if it takes longer than 900s.Versions of `systemd` prior to 238 do not support the timeout extension mechanism and will terminate the Elasticsearch process if it has not fully started up within the configured timeout. If this happens, Elasticsearch will report in its logs that it was shut down normally a short time after it started:
  ```text
  [2022-01-31T01:22:31,077][INFO ][o.e.n.Node               ] [instance-0000000123] starting ...
  ...
  [2022-01-31T01:37:15,077][INFO ][o.e.n.Node               ] [instance-0000000123] stopping ...
  ```
  However the `systemd` logs will report that the startup timed out:
  ```text
  Jan 31 01:22:30 debian systemd[1]: Starting Elasticsearch...
  Jan 31 01:37:15 debian systemd[1]: elasticsearch.service: Start operation timed out. Terminating.
  Jan 31 01:37:15 debian systemd[1]: elasticsearch.service: Main process exited, code=killed, status=15/TERM
  Jan 31 01:37:15 debian systemd[1]: elasticsearch.service: Failed with result 'timeout'.
  Jan 31 01:37:15 debian systemd[1]: Failed to start Elasticsearch.
  ```
  To avoid this, upgrade your `systemd` to at least version 238. You can also temporarily work around the problem by extending the `TimeoutStartSec` parameter.
</admonition>


### Docker images

If you installed a Docker image, you can start Elasticsearch from the command line. There are different methods depending on whether you’re using development mode or production mode. See [Install Elasticsearch with Docker](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-with-docker).

## Stopping Elasticsearch

An orderly shutdown of Elasticsearch ensures that Elasticsearch has a chance to cleanup and close outstanding resources. For example, a node that is shutdown in an orderly fashion will remove itself from the cluster, sync translogs to disk, and perform other related cleanup activities. You can help ensure an orderly shutdown by properly stopping Elasticsearch.
If you’re running Elasticsearch as a service, you can stop Elasticsearch via the service management functionality provided by your installation.
If you’re running Elasticsearch directly, you can stop Elasticsearch by sending `Ctrl`+`C` if you’re running Elasticsearch in the console, or by sending `SIGTERM` to the Elasticsearch process on a POSIX system. You can obtain the PID to send the signal to via various tools (for example, `ps` or `jps`):
```sh
$ jps | grep elasticsearch
14542 elasticsearch
```

From the Elasticsearch startup logs:
```sh
[2016-07-07 12:26:18,908][INFO ][node                     ] [I8hydUG] version[5.0.0-alpha4], pid[15399], build[3f5b994/2016-06-27T16:23:46.861Z], OS[Mac OS X/10.11.5/x86_64], JVM[Oracle Corporation/Java HotSpot(TM) 64-Bit Server VM/1.8.0_92/25.92-b14]
```

Or by specifying a location to write a PID file to on startup (`-p <path>`):
```sh
$ ./bin/elasticsearch -p /tmp/elasticsearch-pid -d
$ cat /tmp/elasticsearch-pid && echo
15516
$ kill -SIGTERM 15516
```


### Stopping on fatal errors

During the life of the Elasticsearch virtual machine, certain fatal errors could arise that put the virtual machine in a questionable state. Such fatal errors include out of memory errors, internal errors in virtual machine, and serious I/O errors.
When Elasticsearch detects that the virtual machine has encountered such a fatal error Elasticsearch will attempt to log the error and then will halt the virtual machine. When Elasticsearch initiates such a shutdown, it does not go through an orderly shutdown as described above. The Elasticsearch process will also return with a special status code indicating the nature of the error.

| Status code | Error                         |
|-------------|-------------------------------|
| 1           | Unknown fatal error           |
| 78          | Bootstrap check failure       |
| 124         | Serious I/O error             |
| 125         | Unknown virtual machine error |
| 126         | Stack overflow error          |
| 127         | Out of memory error           |
| 128         | JVM internal error            |
| 134         | Segmentation fault            |
| 137         | Slain by kernel oom-killer    |
| 143         | User or kernel SIGTERM        |
| 158         | Killed by jvmkiller agent     |