﻿---
title: Restart an Elastic Cloud Hosted deployment
description: You can restart your deployment through the deployment overview UI or by using an API. You might need to restart your deployment while addressing issues,...
url: https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/restart-cloud-hosted-deployment
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Restart an Elastic Cloud Hosted deployment
You can restart your deployment through the deployment overview UI or by using an API.

## Restart your deployment through the deployment overview

You might need to restart your deployment while addressing issues, like cycling garbage collection.
On the deployment overview, from the **Action** drop-down menu select **Restart Elasticsearch**.
You can choose to restart without downtime or you can restart all nodes simultaneously.
Note that if you are looking to restart Elasticsearch to clear out [deployment activity](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/keep-track-of-deployment-activity) plan failures, you may instead run a [no-op plan](https://www.elastic.co/docs/troubleshoot/monitoring/deployment-health-warnings) to re-synchronize the last successful configuration settings between Elastic Cloud Hosted and Elasticsearch.

## Restart an Elasticsearch resource by using an API

Restart an Elasticsearch resource by calling the following API request:
```sh
curl -XPOST \
-H "Authorization: ApiKey $EC_API_KEY" \
"https://api.elastic-cloud.com/api/v1/deployments/$DEPLOYMENT_ID/$RESOURCE_KIND/$REF_ID/_restart"
```

`DEPLOYMENT_ID`  The ID of the deployment returned in the response for `POST /deployments`
`RESOURCE_KIND`  Type of the deployment resource. Depending on the version to be deployed, it can be `elasticsearch`, `kibana`, `apm`, `integrations_server`, `appsearch` or `enterprise_search`
`REF_ID`  Name given to each resource type in the attribute `ref_id`. `main-elasticsearch` in the preceding example

## Shut down an Elastic Cloud Hosted deployment

Shut down an Elastic Cloud Hosted deployment by calling the following API request:
```sh
curl -XPOST \
-H "Authorization: ApiKey $EC_API_KEY" \
"https://api.elastic-cloud.com/api/v1/deployments/$DEPLOYMENT_ID/_shutdown"
```

`DEPLOYMENT_ID`  The ID of the deployment returned in the response for `POST /deployments`