﻿---
title: Full Cluster restart and rolling restart procedures
description: There may be situations where you want to perform a full-cluster restart, and others where you might want to perform a rolling restart. In the case of...
url: https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/full-cluster-restart-rolling-restart-procedures
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Full Cluster restart and rolling restart procedures
There may be situations where you want to perform a full-cluster restart, and others where you might want to perform a rolling restart. In the case of [full-cluster restart](#restart-cluster-full), you shut down and restart all the nodes in the cluster while in the case of [rolling restart](#restart-cluster-rolling), you shut down only one node at a time, so the service remains uninterrupted.
<warning>
  Nodes exceeding the low watermark threshold will be slow to restart. Reduce the disk usage below the [low watermark](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/cluster-level-shard-allocation-routing-settings#cluster-routing-watermark-low) before restarting nodes.
</warning>


## Full-cluster restart

1. **Disable replica shard allocation.**
   When you shut down a data node, the allocation process waits for `index.unassigned.node_left.delayed_timeout` (by default, one minute) before starting to replicate the shards on that node to other nodes in the cluster, which can involve a lot of I/O. Since the node is shortly going to be restarted, this I/O is unnecessary. You can avoid racing the clock by [disabling allocation of replicas](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/cluster-level-shard-allocation-routing-settings#cluster-routing-allocation-enable) before shutting down [data nodes](/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles#data-node-role):
   ```json

    {
      "persistent": {
        "cluster.routing.allocation.enable": "primaries"
      }
    }
   ```
   You can also consider [gateway settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/local-gateway) when restarting large clusters to reduce initial strain while nodes are processing [through discovery](https://www.elastic.co/docs/deploy-manage/distributed-architecture/discovery-cluster-formation).
2. **Stop indexing and perform a flush.**
   Performing a [flush](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-flush) speeds up shard recovery.
   ```json
   ```
3. **Temporarily stop the tasks associated with active machine learning jobs and datafeeds.** (Optional)
   Machine learning features require specific [subscriptions](https://www.elastic.co/subscriptions).
   You have two options to handle machine learning jobs and datafeeds when you shut down a cluster:
   - Temporarily halt the tasks associated with your machine learning jobs and datafeeds and prevent new jobs from opening by using the [set upgrade mode API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-set-upgrade-mode):
  ```json
  ```
  When you disable upgrade mode, the jobs resume using the last model state that was automatically saved. This option avoids the overhead of managing active jobs during the shutdown and is faster than explicitly stopping datafeeds and closing jobs.
- [Stop all datafeeds and close all jobs](/docs/explore-analyze/machine-learning/anomaly-detection/ml-ad-run-jobs#ml-ad-close-job). This option saves the model state at the time of closure. When you reopen the jobs after the cluster restart, they use the exact same model. However, saving the latest model state takes longer than using upgrade mode, especially if you have a lot of jobs or jobs with large model states.
4. **Shut down all nodes.**
   - If you are running Elasticsearch with `systemd`:
  ```sh
  sudo systemctl stop elasticsearch.service
  ```
- If you are running Elasticsearch with SysV `init`:
  ```sh
  sudo -i service elasticsearch stop
  ```
- If you are running Elasticsearch as a daemon:
  ```sh
  kill $(cat pid)
  ```
5. **Perform any needed changes.**
6. **Restart nodes.**
   If you have dedicated master nodes, start them first and wait for them to form a cluster and elect a master before proceeding with your data nodes. You can check progress by looking at the logs.
   As soon as enough master-eligible nodes have discovered each other, they form a cluster and elect a master. At that point, you can use the [cat health](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cat-health) and [cat nodes](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cat-nodes) APIs to monitor nodes joining the cluster:
   ```json
   ```
   The `status` column returned by `_cat/health` shows the health of each node in the cluster: `red`, `yellow`, or `green`.
7. **Wait for all nodes to join the cluster and report a status of yellow.**
   When a node joins the cluster, it begins to recover any primary shards that are stored locally. The [`_cat/health`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cat-health) API initially reports a `status` of `red`, indicating that not all primary shards have been allocated.
   Once a node recovers its local shards, the cluster `status` switches to `yellow`, indicating that all primary shards have been recovered, but not all replica shards are allocated. This is to be expected because you have not yet re-enabled allocation. Delaying the allocation of replicas until all nodes are `yellow` allows the master to allocate replicas to nodes that already have local shard copies.
8. **Re-enable replica shard allocation.**
   When all nodes have joined the cluster and recovered their primary shards, re-enable replica allocation by restoring `cluster.routing.allocation.enable` to its default:
   ```json

   {
     "persistent": {
       "cluster.routing.allocation.enable": null
     }
   }
   ```
   Once replica allocation is re-enabled, the cluster starts allocating replica shards to the data nodes. At this point it is safe to resume indexing and searching, but your cluster will recover more quickly if you can wait until all primary and replica shards have been successfully allocated and the status of all nodes is `green`.
   You can monitor progress with the [`_cat/health`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cat-health) and [`_cat/recovery`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cat-recovery) APIs:
   ```json
   ```
9. **Restart machine learning jobs.** (Optional)
   If you temporarily halted the tasks associated with your machine learning jobs, use the [set upgrade mode API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-set-upgrade-mode) to return them to active states:
   ```json
   ```
   If you closed all machine learning jobs before stopping the nodes, open the jobs and start the datafeeds from Kibana or with the [open jobs](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-open-job) and [start datafeed](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-start-datafeed) APIs.


## Rolling restart

1. **Disable replica shard allocation.**
   When you shut down a data node, the allocation process waits for `index.unassigned.node_left.delayed_timeout` (by default, one minute) before starting to replicate the shards on that node to other nodes in the cluster, which can involve a lot of I/O. Since the node is shortly going to be restarted, this I/O is unnecessary. You can avoid racing the clock by [disabling allocation of replicas](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/cluster-level-shard-allocation-routing-settings#cluster-routing-allocation-enable) before shutting down [data nodes](/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles#data-node-role):
   ```json

   {
     "persistent": {
       "cluster.routing.allocation.enable": "primaries"
     }
   }
   ```
   You can also consider [gateway settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/local-gateway) when restarting large clusters to reduce initial strain while nodes are processing [through discovery](https://www.elastic.co/docs/deploy-manage/distributed-architecture/discovery-cluster-formation).
2. **Stop non-essential indexing and perform a flush.** (Optional)
   While you can continue indexing during the rolling restart, shard recovery can be faster if you temporarily stop non-essential indexing and perform a [flush](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-flush).
   ```json
   ```
3. **Temporarily stop the tasks associated with active machine learning jobs and datafeeds.** (Optional)
   Machine learning features require specific [subscriptions](https://www.elastic.co/subscriptions).
   You have two options to handle machine learning jobs and datafeeds when you shut down a cluster:
   - Temporarily halt the tasks associated with your machine learning jobs and datafeeds and prevent new jobs from opening by using the [set upgrade mode API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-set-upgrade-mode):
  ```json
  ```
   When you disable upgrade mode, the jobs resume using the last model state that was automatically saved. This option avoids the overhead of managing active jobs during the shutdown and is faster than explicitly stopping datafeeds and closing jobs.
   - [Stop all datafeeds and close all jobs](/docs/explore-analyze/machine-learning/anomaly-detection/ml-ad-run-jobs#ml-ad-close-job). This option saves the model state at the time of closure. When you reopen the jobs after the cluster restart, they use the exact same model. However, saving the latest model state takes longer than using upgrade mode, especially if you have a lot of jobs or jobs with large model states.
- If you perform a rolling restart, you can also leave your machine learning jobs running. When you shut down a machine learning node, its jobs automatically move to another node and restore the model states. This option enables your jobs to continue running during the shutdown but it puts increased load on the cluster.
4. **Shut down a single node in case of rolling restart.**
   - If you are running Elasticsearch with `systemd`:
  ```sh
  sudo systemctl stop elasticsearch.service
  ```
- If you are running Elasticsearch with SysV `init`:
  ```sh
  sudo -i service elasticsearch stop
  ```
- If you are running Elasticsearch as a daemon:
  ```sh
  kill $(cat pid)
  ```
5. **Perform any needed changes.**
6. **Restart the node you changed.**
   Start the node and confirm that it joins the cluster by checking the log file or by submitting a `_cat/nodes` request:
   ```json
   ```
7. **Re-enable replica shard allocation.**
   For data nodes, once the node has joined the cluster, remove the `cluster.routing.allocation.enable` setting to enable replica shard allocation and start using the node:
   ```json

   {
     "persistent": {
       "cluster.routing.allocation.enable": null
     }
   }
   ```
8. **Repeat in case of rolling restart.**
   When the node has recovered and the cluster is stable, repeat these steps for each node that needs to be changed.
9. **Restart machine learning jobs.** (Optional)
   If you temporarily halted the tasks associated with your machine learning jobs, use the [set upgrade mode API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-set-upgrade-mode) to return them to active states:
   ```json
   ```
   If you closed all machine learning jobs before stopping the nodes, open the jobs and start the datafeeds from Kibana or with the [open jobs](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-open-job) and [start datafeed](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ml-start-datafeed) APIs.