﻿---
title: Start and stop services
description: This section covers the recommended procedures for: starting and stopping self-managed Elasticsearch nodes, starting and stopping self-managed Kibana...
url: https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Start and stop services
This section covers the recommended procedures for:
- [starting and stopping self-managed Elasticsearch nodes](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/start-stop-elasticsearch)
- [starting and stopping self-managed Kibana instances](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/start-stop-kibana)
- [restarting an ECE deployment](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/restart-an-ece-deployment)
- [restarting Elastic Cloud Hosted deployments](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/restart-cloud-hosted-deployment)
- [full cluster and rolling restarts for self-managed clusters](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/full-cluster-restart-rolling-restart-procedures)

<note>
  In ECK, when a resource – like Elasticsearch or Kibana – is declared, the reconciliation loop ensures the desired state is maintained. There is no built-in stop mechanism in Kubernetes because it’s designed for declarative state management. You either define a resource, and Kubernetes ensures it’s running, or you delete it. You can restart instances by deleting Pods, as the platform will start them immediately.
</note>

Following these guidelines helps prevent data loss, minimize downtime, and maintain optimal performance across different environments.