﻿---
title: Scale out your installation
description: Elastic Cloud Enterprise scales to whatever capacity you need. If you need more processing capacity because your allocators are close to being maxed out...
url: https://www.elastic.co/docs/deploy-manage/maintenance/ece/scale-out-installation
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Scale out your installation
Elastic Cloud Enterprise scales to whatever capacity you need. If you need more processing capacity because your allocators are close to being maxed out or because you want to enable high availability and need an additional availability zone, simply add more capacity and change your deployment configuration to make use of it.
Check the available capacity:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. From the **Platform** menu, select **Allocators** to view the available capacity.
   Narrow the list by name, ID, or choose from several other filters. To further define the list, use a combination of filters.
   In this case 3 GB and 6 GB on two different allocators:
   ![The available capacity in an installation](https://www.elastic.co/docs/deploy-manage/images/cloud-enterprise-ece-available-capacity.png)

If this is not sufficient, add more capacity to your installation:
1. [Install Elastic Cloud Enterprise on additional hosts](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/install-ece-on-additional-hosts) to create additional capacity.
2. [Add capacity](https://www.elastic.co/docs/api/doc/cloud-enterprise/operation/operation-set-allocator-settings) to existing allocators by updating the allocator settings when adding memory to the host.
3. [Assign roles](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/assign-roles-to-hosts) to the additional hosts. If you need to handle a larger search or logging workload, assign the new hosts the allocator role.
4. (Optional) [Tag allocators](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/ece-configuring-ece-tag-allocators) to the new host to indicate what kind of hardware you have available.
5. [Resize your deployment](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/resize-deployment) to handle a larger workload.