﻿---
title: Maintenance activities
description: Maintenance activities ensure the smooth operation and scalability of your Elasticsearch installation. This section provides guidelines on performing...
url: https://www.elastic.co/docs/deploy-manage/maintenance/ece/maintenance-activities
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Maintenance activities
Maintenance activities ensure the smooth operation and scalability of your Elasticsearch installation. This section provides guidelines on performing essential maintenance tasks while minimizing downtime and maintaining high availability.

## Available maintenance operations


### [Enable maintenance mode](https://www.elastic.co/docs/deploy-manage/maintenance/ece/enable-maintenance-mode)

Before performing maintenance on an allocator, you should enable maintenance mode to prevent new Elasticsearch clusters and Kibana instances from being provisioned. This ensures that existing deployments can be safely moved to other allocators or adjusted without disruption.

### [Scale out installation](https://www.elastic.co/docs/deploy-manage/maintenance/ece/scale-out-installation)

You can scale out your installation by adding capacity to meet growing demand or improve high availability. This process involves installing ECE on additional hosts, assigning roles to new hosts, and resizing deployments to utilize the expanded resources.

### [Move nodes and instances between allocators](https://www.elastic.co/docs/deploy-manage/maintenance/ece/move-nodes-instances-from-allocators)

Moving Elasticsearch nodes, Kibana instances, and other components between allocators may be necessary to free up space, avoid downtime, or handle allocator failures. The process involves selecting target allocators and ensuring enough capacity to accommodate the migration.

### [Perform ECE host maintenance](https://www.elastic.co/docs/deploy-manage/maintenance/ece/perform-ece-hosts-maintenance)

Maintaining ECE hosts is critical for applying system patches, performing hardware upgrades, and ensuring compliance with security standards. Learn about the various methods of maintaining hosts, and their impact on your ECE installation.

### [Delete ECE hosts](https://www.elastic.co/docs/deploy-manage/maintenance/ece/delete-ece-hosts)

If a host is no longer required or is faulty, it can be removed from the Elastic Cloud Enterprise installation. Deleting a host only removes it from the installation but does not uninstall the software from the physical machine. Before deletion, allocators should be placed in maintenance mode, and nodes should be migrated to avoid disruption.

## Best practices for maintenance

- Always check available capacity before making changes.
- Use maintenance mode to avoid unexpected disruptions.
- Move nodes strategically to maintain high availability.
- Perform maintenance during off-peak hours when possible.
- Regularly review and optimize resource allocation.

By following these guidelines, you can ensure the stability and efficiency of your environment while carrying out necessary maintenance activities.