﻿---
title: Delete ECE hosts
description: You might need to delete hosts for several reasons: To remove some resources from your Elastic Cloud Enterprise installation if they are no longer required.To...
url: https://www.elastic.co/docs/deploy-manage/maintenance/ece/delete-ece-hosts
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Delete ECE hosts
You might need to delete hosts for several reasons:
- To remove some resources from your Elastic Cloud Enterprise installation if they are no longer required.
- To remove a faulty host from the Cloud UI so that it is no longer part of your Elastic Cloud Enterprise installation.

Deleting a host only removes the host from your installation, it does not [remove the Elastic Cloud Enterprise software from the host](https://www.elastic.co/docs/deploy-manage/uninstall/uninstall-elastic-cloud-enterprise). After the host has been deleted, you can repurpose or troubleshoot the physical host on which the Elastic Cloud Enterprise host was located.
To delete hosts:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. From the **Platform** menu, select **Hosts**.
   Narrow the list by name, ID, or choose from several other filters. To further define the list, use a combination of filters.
3. For hosts that hold the allocator role:
   1. [Enable maintenance mode](https://www.elastic.co/docs/deploy-manage/maintenance/ece/enable-maintenance-mode) on the allocator.
2. [Move all nodes off the allocator](https://www.elastic.co/docs/deploy-manage/maintenance/ece/move-nodes-instances-from-allocators) and to other allocators in your installation.
4. Go to **Hosts** and select a host.
5. Select **Manage roles** from the **Manage host** menu and remove all assigned roles.
6. Select **Demote host** from the **Manage host** menu if present. If the **Delete host** option is already enabled, skip this step.
7. Remove *all running* containers from the host, starting from the container with name `frc-runners-runner`. Then remove the storage directory (the default `/mnt/data/elastic/`). You can use the recommended [cleanup command](https://www.elastic.co/docs/deploy-manage/uninstall/uninstall-elastic-cloud-enterprise).  Upon doing so, the UI should reflect the host is **Disconnected**, allowing the host to be deleted.
8. Select **Delete host** and confirm.

<tip>
  Refresh the page if the button isn’t active.
</tip>