﻿---
title: ECE maintenance
description: Elastic Cloud Enterprise (ECE), being a self-managed Elastic Stack deployment platform, abstracts much of the complexity of running Elasticsearch, but...
url: https://www.elastic.co/docs/deploy-manage/maintenance/ece
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# ECE maintenance
Elastic Cloud Enterprise (ECE), being a self-managed Elastic Stack deployment platform, abstracts much of the complexity of running Elasticsearch, but still requires regular maintenance at both the platform and deployment levels. Maintenance activities range from managing individual deployments to performing infrastructure-level updates on ECE hosts.

## Deployment maintenance and host infrastructure maintenance

[Deployment maintenance](https://www.elastic.co/docs/deploy-manage/maintenance/ece/deployments-maintenance) focuses on managing individual Elasticsearch and Kibana instances within ECE. This includes actions such as [pausing instances](https://www.elastic.co/docs/deploy-manage/maintenance/ece/pause-instance), [stopping request routing to nodes](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-routing-requests), and [moving instances between allocators](https://www.elastic.co/docs/deploy-manage/maintenance/ece/move-nodes-instances-from-allocators) to optimize resource usage or prepare for maintenance. These tasks help maintain service availability and performance without affecting the underlying infrastructure.
[ECE host infrastructure maintenance](https://www.elastic.co/docs/deploy-manage/maintenance/ece/perform-ece-hosts-maintenance) involves managing virtual machines that host ECE itself. This includes tasks like applying operating system patches, upgrading software, or decommissioning hosts. Infrastructure maintenance often requires more careful planning, as it can impact multiple deployments running on the affected hosts. Methods such as placing allocators into [maintenance mode](https://www.elastic.co/docs/deploy-manage/maintenance/ece/enable-maintenance-mode) and redistributing workloads provide a smooth transition during maintenance operations.
This section provides guidance on best practices for both types of maintenance, helping you maintain a resilient ECE environment.