﻿---
title: Maintenance
description: This section outlines the key tasks and processes required to maintain a healthy, performant, and secure Elasticsearch infrastructure and its deployments...
url: https://www.elastic.co/docs/deploy-manage/maintenance
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Maintenance
This section outlines the key tasks and processes required to maintain a healthy, performant, and secure Elasticsearch infrastructure and its deployments.
The topics covered include:
- **[ECE maintenance](https://www.elastic.co/docs/deploy-manage/maintenance/ece)**: Explains the procedures for maintaining both the host infrastructure and Elasticsearch deployments within Elastic Cloud Enterprise (ECE).
- **[Start and stop services](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services)**: Provides step-by-step instructions on how to safely start and stop your Elasticsearch deployment or Kibana instance, particularly when performing actions that require a restart.
- **[Start and stop routing requests](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-routing-requests)**: Start or stop routing requests to an Elastic Cloud Hosted or Elastic Cloud Enterprise deployment, or to all instances on an allocator in Elastic Cloud Enterprise.
- **[Add and Remove Elasticsearch nodes](https://www.elastic.co/docs/deploy-manage/maintenance/add-and-remove-elasticsearch-nodes)**: Guides you through the process of enrolling new nodes or safely removing existing ones from a self-managed Elasticsearch cluster to optimize resource utilization and cluster performance.