﻿---
title: Manage your license in a self-managed cluster
description: By default, new installations have a Basic license that never expires. For the full list of features available at the Free and Open Basic subscription...
url: https://www.elastic.co/docs/deploy-manage/license/manage-your-license-in-self-managed-cluster
products:
  - Kibana
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Manage your license in a self-managed cluster
By default, new installations have a Basic license that never expires. For the full list of features available at the Free and Open Basic subscription level, refer to [Elastic subscriptions](https://www.elastic.co/subscriptions).
To explore all of the available solutions and features, start a 30-day free trial. You can activate a trial subscription once per major product version. If you need more than 30 days to complete your evaluation, [request an extended trial](https://www.elastic.co/trialextension).
To view the status of your license, start a trial, or install a new license, go to the **License Management** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).

## Required permissions

The `manage` cluster privilege is required to access **License Management**.
To add the privilege, go to the **Roles** management page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).

## License expiration

Licenses are valid for a specific time period. 30 days before the license expiration date, Elasticsearch starts logging expiration warnings. If monitoring is enabled, expiration warnings are displayed prominently in Kibana.
If your license expires, your subscription level reverts to Basic and you will no longer be able to use [Platinum or Enterprise features](https://www.elastic.co/subscriptions).

## Update your license

Licenses are provided as a *JSON* file and have an effective date and an expiration date. You cannot install a new license before its effective date. License updates take effect immediately and do not require restarting Elasticsearch.
To update your license from Kibana, go to the **License Management** management page using the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). You can also use the [update license API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-license-post).