﻿---
title: Licenses and subscriptions
description: Your Elastic license or subscription determines which features are available and what level of support you receive. Depending on your deployment type,...
url: https://www.elastic.co/docs/deploy-manage/license
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Licenses and subscriptions
Your Elastic license or subscription determines which features are available and what level of support you receive.
Depending on your deployment type, licenses and subscriptions are applied at different levels:
- **Elastic Cloud, Elastic Cloud Enterprise, and Elastic Cloud on Kubernetes:** Licenses and subscriptions are controlled at the orchestrator or organization level, and apply to all related deployments.
- **Self-managed Elasticsearch:** Licenses are controlled at the cluster level, and apply only to a single cluster.

For a comprehensive comparison of the available subscription levels, see [Elastic subscriptions](https://www.elastic.co/subscriptions).
Use the topics in this section to manage your license or start a trial:
- [Elastic Cloud](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/manage-subscription): Applies to both Elastic Cloud Hosted deployments and Elastic Cloud Serverless projects in your Cloud organization
- [Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/license/manage-your-license-in-ece)
- [Elastic Cloud on Kubernetes](https://www.elastic.co/docs/deploy-manage/license/manage-your-license-in-eck)
- [Self-managed cluster](https://www.elastic.co/docs/deploy-manage/license/manage-your-license-in-self-managed-cluster)


## Additional resources

Explore these resources for details on subscriptions and features:
- [Elastic Stack subscriptions](https://www.elastic.co/subscriptions)
- [Elastic Cloud features](https://www.elastic.co/subscriptions/cloud)
- [Elastic Cloud pricing](https://www.elastic.co/pricing)