﻿---
title: Configure Kibana reporting
description: Kibana's reporting functionality offers multiple ways to share Discover sessions, dashboards, Visualize Library visualizations, and Canvas workpads. This...
url: https://www.elastic.co/docs/deploy-manage/kibana-reporting-configuration
products:
  - Kibana
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Configure Kibana reporting
Kibana's reporting functionality offers multiple ways to share **Discover** sessions, dashboards, **Visualize Library** visualizations, and **Canvas** workpads.
This section covers the necessary configuration to ensure reporting works correctly in your deployment. For guidance on using reporting features effectively, refer to [Reporting and sharing](https://www.elastic.co/docs/explore-analyze/report-and-share).
<admonition title="Note for self-managed deployments">
  Kibana PNG/PDF reporting uses a custom binary of headless Chromium, and support comes with special caveats:
  - The functionality requires special OS dependencies which may not be available for all distributions and configurations of Linux.
  - It is subject to system resource configurations such as the limited number of file descriptors, allowed processes, and types of processes.
  - Linux versions that are in end-of-life phase are not supported.
  - Linux systems with `SELinux` or `fapolicyd` are not supported.
  Before upgrading Kibana in a production environment, we encourage you to test your screenshotting use cases in a pre-production environment to make sure your hosts support our latest build of Chromium. For the most reliable configuration of PDF/PNG reporting features, consider installing Kibana using [Docker](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-kibana-with-docker), or using [Elastic Cloud](https://cloud.elastic.co).
</admonition>


## Configuration overview

To secure reporting features, you must grant users access to reporting functionality and protect the reporting endpoints with TLS/SSL encryption. Additionally, you can install graphical packages on the operating system to enable screenshot capabilities in the Kibana server.
<note applies-to="Elastic Cloud Serverless: Unavailable, Elastic Stack: Generally available since 9.1">
  Report generation requests are authenticated by API keys instead of session cookies. There are several key differences between the authentication methods. API keys capture your role privileges, whereas session cookie are based on your user credentials. API keys are also longer-lived, compared to session cookies, which have a shorter lifespan.If you have a cross-cluster search environment and want to generate reports from remote clusters, you must have the appropriate cluster and index privileges on the remote cluster and local cluster. For example, if requests are authenticated with an API key, the API key requires certain privileges on the local cluster that contains the local index, in addition to the remote. For more information and examples, refer to [Configure roles and users for remote clusters](/docs/deploy-manage/remote-clusters/remote-clusters-cert#remote-clusters-privileges-cert).
</note>

Configuring reporting in your environment involves two main areas:

### Granting users access to reporting features

Depending on your license, the type of users, and whether you prefer using the Kibana UI or API, there are multiple ways to [grant access to reporting functionality](#grant-user-access).

### Applying system configuration

The following configurations are required at Elasticsearch, Kibana, and OS levels to support reporting features.
<important>
  These steps apply only to **self-managed deployments**. Orchestrated deployments include this configuration by default. For more details on different deployment options, refer to [Deploy](https://www.elastic.co/docs/deploy-manage/deploy).
</important>

- [Secure the reporting endpoints](#securing-reporting)
- [Install the dependencies for the headless browser](#install-reporting-packages)
- [Set the `server.host` for the headless browser](#set-reporting-server-host)
- [Ensure Elasticsearch allows built-in templates](#reporting-elasticsearch-configuration)


## Grant users access to reporting

<applies-to>
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
</applies-to>

Choose the method that best fits your use case.
<tab-set>
  <tab-item title="Using Kibana UI">
    When security is enabled, you grant users access to reporting features with [Kibana application privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges), which allow you to create custom roles that control the spaces and applications where users generate reports.
    1. Create the reporting role.
       1. Go to the **Roles** management page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. Click **Create role**.
    2. Specify the role settings.
       1. Enter the **Role name**. For example, `custom_reporting_user`.
    2. Specify the **Indices** and **Privileges**.
       Access to data is an index-level privilege. For each index that contains the data you want to include in reports, add a line, then give each index `read` and `view_index_metadata` privileges.
       <note>
       If you use index aliases, you must also grant `read` and `view_index_metadata` privileges to underlying indices to generate CSV reports.
       </note>
       For more information, refer to [Security privileges](https://www.elastic.co/docs/reference/elasticsearch/security-privileges).
    3. Add the Kibana privileges.
       1. Click **Add Kibana privilege**.
    2. Select one or more **Spaces**.
    3. Click **Customize**, then click **Analytics**.
    4. For each application, select **All**, or to customize the privileges, select **Read** and **Customize sub-feature privileges**.
       <note>
       If you have a Basic license, sub-feature privileges are unavailable.
       </note>
       <note>
       If the **Reporting** options for application features are unavailable, and the cluster license is higher than Basic, contact your administrator.
       </note>
       ![](https://www.elastic.co/docs/deploy-manage/images/kibana-kibana-privileges-with-reporting.png)
    5. Click **Add Kibana privilege**.
    1. Click **Create role**.
    2. Assign the reporting role to a user.
       1. Go to the **Users** management page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. Select the user you want to assign the reporting role to.
    3. From the **Roles** dropdown, select **custom_reporting_user**.
    4. Click **Update user**.
    Granting the privilege to generate reports also grants the user the privilege to view their reports in **Reporting**. Users can only access their own reports.To view reports, go to the **Reporting** management page in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
  </tab-item>

  <tab-item title="Using role API">
    With [Kibana application privileges](#grant-user-access), you can use the [role APIs](https://www.elastic.co/docs/api/doc/kibana/group/endpoint-roles) to grant access to the reporting features, using **All** privileges, or sub-feature privileges.
    <note>
      This API request needs to be run against the [Kibana API endpoint](https://www.elastic.co/docs/api/doc/kibana/).
    </note>

    ```json

    {
      "elasticsearch": {
        "cluster": [],
        "indices": [],
        "run_as": []
      },
      "kibana": [{
        "spaces": ["*"],
        "base": [],
        "feature": {
          "dashboard_v2": ["generate_report",  <1>
          "download_csv_report"], <2>
          "discover_v2": ["generate_report"], <3>
          "canvas": ["generate_report"], <4>
          "visualize_v2": ["generate_report"] <5>
        }
      }]
    }
    ```
  </tab-item>

  <tab-item title="External providers">
    If you are using an external identity provider, such as LDAP or Active Directory, you can assign roles to individual users or groups of users. Role mappings are configured in [`config/role_mapping.yml`](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/mapping-users-groups-to-roles).For example, assign the `kibana_admin` and `custom_reporting_user` roles to the Bill Murray user:
    ```yaml
    kibana_admin:
      - "cn=Bill Murray,dc=example,dc=com"
    custom_reporting_user:
      - "cn=Bill Murray,dc=example,dc=com"
    ```
  </tab-item>

  <tab-item title="Basic license">
    With a Basic license, sub-feature [application privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges) are unavailable, requiring you to select **All** privileges for the applications where users can create reports. You can grant users access through the Kibana UI or role API.Example using Kibana UI:
    ![Kibana privileges with Reporting options, Basic license](https://www.elastic.co/docs/deploy-manage/images/kibana-kibana-privileges-with-reporting-basic.png)
    Example using [role API](https://www.elastic.co/docs/api/doc/kibana/group/endpoint-roles) to grant access to CSV reporting features:
    ```json

    {
      "elasticsearch": { "cluster": [], "indices": [], "run_as": [] },
      "kibana": [
        {
          "base": [],
          "feature": {
            "dashboard_v2": [ "all" ], <1>
            "discover_v2": [ "all" ], <2>
          },
          "spaces": [ "*" ]
        }
      ],
      "metadata": {} <3>
    }
    ```
  </tab-item>
</tab-set>


## System configuration

<applies-to>
  - Self-managed Elastic deployments: Generally available
</applies-to>

The following configurations are required at Elasticsearch, Kibana, and OS levels to support reporting features.
These steps apply only to **self-managed deployments**. Orchestrated deployments include this configuration by default. For more details on different deployment options, refer to [Deploy](https://www.elastic.co/docs/deploy-manage/deploy).

### Secure the reporting endpoints

To automatically generate reports with Watcher, you must configure Watcher to trust the Kibana server certificate.
1. Enable Elastic Stack security features on your Elasticsearch cluster. For more information, see [Security](https://www.elastic.co/docs/deploy-manage/security).
2. Configure TLS/SSL encryption for the Kibana server. For more information, see [*Encrypt TLS communications in Kibana*](/docs/deploy-manage/security/set-up-basic-security-plus-https#encrypt-kibana-http).
3. Specify the Kibana server CA certificate chain in [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings):
   If you are using your own CA to sign the Kibana server certificate, then you need to specify the CA certificate chain in Elasticsearch to properly establish trust in TLS connections between Watcher and Kibana. If your CA certificate chain is contained in a PKCS #12 trust store, specify it like so:
   ```yaml
   xpack.http.ssl.truststore.path: "/path/to/your/truststore.p12"
   xpack.http.ssl.truststore.type: "PKCS12"
   xpack.http.ssl.truststore.password: "optional decryption password"
   ```
   Otherwise, if your CA certificate chain is in PEM format, specify it like so:
   ```yaml
   xpack.http.ssl.certificate_authorities: ["/path/to/your/cacert1.pem", "/path/to/your/cacert2.pem"]
   ```
   For more information, see [the Watcher HTTP TLS/SSL Settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/watcher-settings#ssl-notification-settings).
4. Add one or more users who have access to the reporting features.
   Once you’ve enabled SSL for Kibana, all requests to the reporting endpoints must include valid credentials.

For more information on sharing reports, direct links, and more, refer to [Reporting and sharing](https://www.elastic.co/docs/explore-analyze/report-and-share).

### Install the dependencies for the headless browser

If using PNG/PDF reporting features, make sure the Kibana server operating system has the appropriate packages installed for the distribution.
If you are using RHEL operating systems, install the following packages:
- `xorg-x11-fonts-100dpi`
- `xorg-x11-fonts-75dpi`
- `xorg-x11-utils`
- `xorg-x11-fonts-cyrillic`
- `xorg-x11-fonts-Type1`
- `xorg-x11-fonts-misc`
- `vlgothic-fonts`
- `fontconfig`
- `freetype`

If you are using Ubuntu/Debian systems, install the following packages:
- `fonts-liberation`
- `libfontconfig1`
- `libnss3`

The screenshotting plugin used for reporting features has a built-in utility to check for common issues, such as missing dependencies. See [Reporting diagnostics](/docs/explore-analyze/report-and-share/reporting-troubleshooting-pdf#reporting-diagnostics) for more information.

### Set the `server.host` for the headless browser

If using PNG/PDF reporting features in a production environment, it is preferred to use the setting of `server.host: 0.0.0.0` in the [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) configuration file. This allows the headless browser used for PDF/PNG reporting to reach Kibana over a local interface, while also allowing the Kibana server to listen on outward-facing network interfaces, as it makes the Kibana server accessible from any network interface on the machine. Make sure that no firewall rules or other routing rules prevent local services from accessing this address.

### Ensure Elasticsearch allows built-in templates

Reporting relies on Elasticsearch to install a mapping template for the data stream that stores reports. Ensure that Elasticsearch allows built-in templates to be installed by keeping the `stack.templates.enabled` setting at the default value of `true`. For more information, see [Index management settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/index-management-settings#stack-templates-enabled).