﻿---
title: Discovery and cluster formation
description: The discovery and cluster formation processes are responsible for discovering nodes, electing a master, forming a cluster, and publishing the cluster...
url: https://www.elastic.co/docs/deploy-manage/distributed-architecture/discovery-cluster-formation
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Discovery and cluster formation
<important>
  The information provided in this section is applicable to all deployment types. However, the configuration settings detailed here are only valid for fully self-managed Elasticsearch clusters. For ECE, ECK, and ECH deployments, this section should only be used for general information and troubleshooting.
</important>

The discovery and cluster formation processes are responsible for discovering nodes, electing a master, forming a cluster, and publishing the cluster state each time it changes.
The following processes and settings are part of discovery and cluster formation:
<definitions>
  <definition term="Discovery">
    Discovery is the process where nodes find each other when the master is unknown, such as when a node has just started up or when the previous master has failed.
  </definition>
  <definition term="Quorum-based decision making">
    How Elasticsearch uses a quorum-based voting mechanism to make decisions even if some nodes are unavailable.
  </definition>
  <definition term="Voting configurations">
    How Elasticsearch automatically updates voting configurations as nodes leave and join a cluster.
  </definition>
  <definition term="Bootstrapping a cluster">
    Bootstrapping a cluster is required when an Elasticsearch cluster starts up for the very first time. In [development mode](/docs/deploy-manage/deploy/self-managed/bootstrap-checks#dev-vs-prod-mode), with no discovery settings configured, this is automatically performed by the nodes themselves. As this auto-bootstrapping is [inherently unsafe](https://www.elastic.co/docs/deploy-manage/distributed-architecture/discovery-cluster-formation/modules-discovery-quorums), running a node in [production mode](/docs/deploy-manage/deploy/self-managed/bootstrap-checks#dev-vs-prod-mode) requires bootstrapping to be [explicitly configured](https://www.elastic.co/docs/deploy-manage/distributed-architecture/discovery-cluster-formation/modules-discovery-bootstrap-cluster).
  </definition>
  <definition term="Adding and removing master-eligible nodes">
    It is recommended to have a small and fixed number of master-eligible nodes in a cluster, and to scale the cluster up and down by adding and removing master-ineligible nodes only. However there are situations in which it may be desirable to add or remove some master-eligible nodes to or from a cluster. This section describes the process for adding or removing master-eligible nodes, including the extra steps that need to be performed when removing more than half of the master-eligible nodes at the same time.
  </definition>
  <definition term="Publishing the cluster state">
    Cluster state publishing is the process by which the elected master node updates the cluster state on all the other nodes in the cluster.
  </definition>
  <definition term="Cluster fault detection">
    Elasticsearch performs health checks to detect and remove faulty nodes.
  </definition>
  <definition term="Settings">
    There are settings that enable users to influence the discovery, cluster formation, master election and fault detection processes.
  </definition>
</definitions>