﻿---
title: Tools and APIs for self-managed clusters
description: Review key resources that can be used to interact with and manage self-managed clusters. The following APIs allow you to interact with your Elasticsearch...
url: https://www.elastic.co/docs/deploy-manage/deploy/self-managed/tools-apis
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Tools and APIs for self-managed clusters
Review key resources that can be used to interact with and manage self-managed clusters.

## APIs

The following APIs allow you to interact with your Elasticsearch cluster and its data.
- [Elasticsearch APIs](https://www.elastic.co/docs/api/doc/elasticsearch/): This set of APIs allows you to interact directly with the Elasticsearch nodes in your deployment. You can ingest data, run search queries, check the health of your clusters, manage snapshots, and more.
- [Kibana APIs](https://www.elastic.co/docs/api/doc/kibana/): Many Kibana features can be accessed through these APIs, including Kibana objects, patterns, and dashboards, as well as user roles and user sessions. You can use these APIs to configure alerts and actions, and to access health details for the [Kibana Task Manager](https://www.elastic.co/docs/deploy-manage/distributed-architecture/kibana-tasks-management).

<tip>
  Refer to [Elasticsearch API conventions](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/api-conventions) to learn about headers and request body conventions, and to view examples.Refer to [Elasticsearch API keys](https://www.elastic.co/docs/deploy-manage/api-keys/elasticsearch-api-keys) to learn how to generate API keys for your cluster.
</tip>

Some other Elastic products have APIs to support machine-to-machine operations:
- [APM event intake API](https://www.elastic.co/docs/solutions/observability/apm/elastic-apm-events-intake-api)
- [Fleet APIs](https://www.elastic.co/docs/reference/fleet/fleet-api-docs)
- [Logstash APIs](https://www.elastic.co/docs/reference/logstash/monitoring-logstash)


## Clients

- [Elasticsearch clients](https://www.elastic.co/docs/reference/elasticsearch-clients): Interact with Elasticsearch programmatically to integrate Elasticsearch into your app or website.


## Tools

- [Elasticsearch command line tools](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools): Utilities for configuring security and performing other tasks from the command line.
- [Kibana command line tools](https://www.elastic.co/docs/reference/kibana/commands): Utilities for performing security and connectivity related tasks for Kibana from the command line.
- [Elasticsearch Support Diagnostic tool](https://www.elastic.co/docs/troubleshoot/elasticsearch/diagnostic): Captures a point-in-time snapshot of cluster statistics and most Elasticsearch settings for troubleshooting purposes.