﻿---
title: Increase the maximum number of threads
description: Elasticsearch uses a number of thread pools for different types of operations. It is important that it is able to create new threads whenever needed...
url: https://www.elastic.co/docs/deploy-manage/deploy/self-managed/max-number-of-threads
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Increase the maximum number of threads
Elasticsearch uses a number of thread pools for different types of operations. It is important that it is able to create new threads whenever needed. Make sure that the number of threads that the Elasticsearch user can create is at least 4096.
This can be done by setting [`ulimit -u 4096`](/docs/deploy-manage/deploy/self-managed/setting-system-settings#ulimit) as root before starting Elasticsearch, or by setting `nproc` to `4096` in [`/etc/security/limits.conf`](/docs/deploy-manage/deploy/self-managed/setting-system-settings#limits.conf).
The package distributions when run as services under `systemd` will configure the number of threads for the Elasticsearch process automatically. No additional configuration is required.