﻿---
title: Local development installation (quickstart)
description: Quickly set up Elasticsearch and Kibana in Docker for local development or testing, using this one-liner in the command line. Install Docker Compose.In...
url: https://www.elastic.co/docs/deploy-manage/deploy/self-managed/local-development-installation-quickstart
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Local development installation (quickstart)
<warning>
  **DO NOT USE THESE INSTRUCTIONS FOR PRODUCTION DEPLOYMENTS**The instructions on this page are for **local development only**. Do not use this configuration for production deployments, because it is not secure. Refer to [deployment options](https://www.elastic.co/docs/get-started/deployment-options) for a list of production deployment options.
</warning>

Quickly set up Elasticsearch and Kibana in Docker for local development or testing, using this one-liner in the command line.
<:::{info}>
  This setup comes with a one-month trial license that includes all Elastic features.
</:::{info}>


## Prerequisites

- [Install Docker Compose](https://docs.docker.com/compose/install/).
  In most cases, you need to install Docker Desktop or Docker Engine to access Docker Compose.
  Docker Compose V2 or later is recommended, and is included in Docker Desktop 3.4 and later, and Docker Engine 20.10.13 or later.
  The minimum supported version of Docker Compose is 1.29.0.
- If you’re using Microsoft Windows, then install [Windows Subsystem for Linux (WSL)](https://learn.microsoft.com/en-us/windows/wsl/install).


## Step 1: Run `start-local` script

To set up Elasticsearch and Kibana locally, run the `start-local` script in the command line:
```sh
curl -fsSL https://elastic.co/start-local | sh
```

After running the script, you can access Elastic services at the following endpoints:
- **Elasticsearch**: [http://localhost:9200](http://localhost:9200)
- **Kibana**: [http://localhost:5601](http://localhost:5601)

That's it! There's no step 2.

## Learn more

For more detailed information about the `start-local` setup, refer to the [README on GitHub](https://github.com/elastic/start-local). Learn about customizing the setup, logging, and more.

## Next steps

Use our [quick start guides](https://www.elastic.co/docs/solutions/search/get-started/quickstarts) to learn the basics of Elasticsearch.