﻿---
title: Install Kibana
description: Kibana provides the user interface for all Elastic solutions. It’s a powerful tool for visualizing and analyzing your data, and for managing and monitoring...
url: https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-kibana
products:
  - Kibana
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Install Kibana
Kibana provides the user interface for all Elastic solutions. It’s a powerful tool for visualizing and analyzing your data, and for managing and monitoring the Elastic Stack. Although Kibana is not required to use Elasticsearch, it's required for most use cases.
This section includes information on how to set up Kibana and get it running, including:
- Downloading and installing Kibana
- Enrolling Kibana with an Elasticsearch cluster
- Configuring Kibana

To quickly set up Elasticsearch and Kibana in Docker for local development or testing, jump to [Local development installation (quickstart)](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/local-development-installation-quickstart).

## Supported platforms

Packages of Kibana are provided for and tested against Linux, Darwin, and Windows. Because Kibana runs on Node.js, we include the necessary Node.js binaries for these platforms. Running Kibana against a separately maintained version of Node.js is not supported.
To support certain older Linux platforms (most notably CentOS7/RHEL7), Kibana for Linux ships with a custom build of Node.js with glibc 2.17 support. For details, see [Custom builds of Node.js](https://www.elastic.co/docs/extend/kibana/upgrading-nodejs#custom-nodejs-builds).

## Kibana install packages

Kibana is provided in the following package formats:

| Format   | Description                                                                                                                                                                         | Instructions                                                                                                                                       |
|----------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------|
| `tar.gz` | The `tar.gz` packages are provided for installation on Linux and Darwin and are the easiest choice for getting started with Kibana.                                                 | [Install from archive on Linux or macOS](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-kibana-from-archive-on-linux-macos) |
| `zip`    | The `zip` package is the only supported package for Windows.                                                                                                                        | [Install on Windows](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-kibana-on-windows)                                      |
| `deb`    | The `deb` package is suitable for Debian, Ubuntu, and other Debian-based systems.  Debian packages may be downloaded from the Elastic website or from our Debian repository.        | [Install with Debian package](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-kibana-with-debian-package)                    |
| `rpm`    | The `rpm` package is suitable for installation on Red Hat, SLES, OpenSuSE and other RPM-based systems.  RPMs may be downloaded from the Elastic website or from our RPM repository. | [Install with RPM](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-kibana-with-rpm)                                          |
| `docker` | Images are available for running Kibana as a Docker container. They may be downloaded from the Elastic Docker Registry.                                                             | [Running Kibana on Docker](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-kibana-with-docker)                               |


## Elasticsearch version

When installing the Elastic Stack, you must use the same version across the entire stack. For example, if you are using Elasticsearch 9.3.0, you install Beats 9.3.0, APM Server 9.3.0, Elasticsearch Hadoop 9.3.0, Kibana 9.3.0, and Logstash 9.3.0.
If you’re upgrading an existing installation, see [Upgrade your deployment, cluster, or orchestrator](https://www.elastic.co/docs/deploy-manage/upgrade) for information about how to ensure compatibility with 9.3.0.
Running different major version releases of Kibana and Elasticsearch (e.g. Kibana 9.x and Elasticsearch 8.x) is not supported, nor is running a minor version of Kibana that is newer than the version of Elasticsearch (e.g. Kibana 8.14 and Elasticsearch 8.13).
Running a minor version of Elasticsearch that is higher than Kibana will generally work in order to facilitate an upgrade process where Elasticsearch is upgraded first (e.g. Kibana 8.14 and Elasticsearch 8.15). In this configuration, a warning will be logged on Kibana server startup, so it’s only meant to be temporary until Kibana is upgraded to the same version as Elasticsearch.
Running different patch version releases of Kibana and Elasticsearch (e.g. Kibana 9.0.0 and Elasticsearch 9.0.1) is generally supported, though we encourage users to run the same versions of Kibana and Elasticsearch down to the patch version.

## Installation order

If you're deploying the Elastic Stack in a self-managed cluster, then install the Elastic Stack products you want to use in the following order:
- [Elasticsearch](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/installing-elasticsearch)
- [Kibana](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-kibana)
- [Logstash](https://www.elastic.co/docs/reference/logstash)
- [Elastic Agent](https://www.elastic.co/docs/reference/fleet) or [Beats](https://www.elastic.co/docs/reference/beats)
- [APM](https://www.elastic.co/docs/solutions/observability/apm)
- [Elasticsearch Hadoop](https://www.elastic.co/docs/reference/elasticsearch-hadoop)

Installing in this order ensures that the components each product depends on are in place.
<tip>
  If you're deploying a production environment and you plan to use [trusted CA-signed certificates](/docs/deploy-manage/security/self-setup#manual-configuration) for Elasticsearch, then you should do so before you deploy Fleet and Elastic Agent. If new security certificates are configured, any Elastic Agents need to be reinstalled, so we recommend that you set up Fleet and Elastic Agent with the appropriate certificates in place.
</tip>


## Default ports

This table shows the ports that must be accessible in order to operate an Elasticsearch cluster. The Elasticsearch REST and Kibana interfaces must be open to external users in order for the cluster to be usable. The transport API must be accessible between Elasticsearch nodes in the cluster, and to any external clients using the transport API.
By default, Elasticsearch will try to listen to the first port in the specified range. If the port is taken, it will try the next one.
These settings can be overridden in the relevant configuration file.

| Port             | Access type | Purpose                                                                                                                                        | Setting                                                                                                                                                   |
|------------------|-------------|------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------|
| 9200 and onwards | HTTP (REST) | REST API for Elasticsearch. This is the primary interface used for access to the cluster from external sources, including Kibana and Logstash. | Elasticsearch [`http.port`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings#common-network-settings)      |
| 9300 and onwards | TCP         | Transport API. Used for intra-cluster communications and client access via the transport API (Java client).                                    | Elasticsearch [`transport.port`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings#common-network-settings) |
| 5601             | HTTP        | Kibana default access port.                                                                                                                    | Kibana [`server.port`](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings#server-port)                                 |

Additional ports might be required for [optional Elastic Stack components](https://www.elastic.co/docs/get-started/the-stack). Refer to the installation guide for the component that you want to install.

## Third-party dependencies

Refer to [Elastic Stack third-party dependencies](https://artifacts.elastic.co/reports/dependencies/dependencies-current.html) for the complete list of dependencies.