﻿---
title: Install Kibana with Docker
description: Docker images for Kibana are available from the Elastic Docker registry. The base image is Red Hat Universal Base Images (UBI) or Wolfi if you use hardened...
url: https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-kibana-with-docker
products:
  - Kibana
---

# Install Kibana with Docker
Docker [images for Kibana](https://hub.docker.com/_/kibana) are available from the Elastic Docker registry. The base image is Red Hat Universal Base Images (UBI) or Wolfi if you use [hardened Docker images](#_hardened_docker_images).
A list of all published Docker images and tags is available at [www.docker.elastic.co](https://www.docker.elastic.co). The source code is in [GitHub](https://github.com/elastic/dockerfiles/tree/master/kibana).
This package contains both free and subscription features. [Start a 30-day trial](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/license-settings) to try out all of the features.

## Run Kibana in Docker for development

Use Docker commands to run Kibana on a single-node Elasticsearch cluster for development or testing.
<tip>
  This setup doesn’t run multiple Elasticsearch nodes by default. To create a multi-node cluster with Kibana, use Docker Compose instead. Refer to [Start a multi-node cluster with Docker Compose](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-docker-compose) in the Elasticsearch documentation.
</tip>


## Hardened Docker images

You can also use the hardened [Wolfi](https://wolfi.dev/) image for additional security. Using Wolfi images requires Docker version 20.10.10 or higher.
To use the Wolfi image, append `-wolfi` to the image tag in the Docker command.
For example:
<tab-set>
  <tab-item title="Latest">
    ```sh
    docker pull docker.elastic.co/kibana/kibana-wolfi:9.3.0
    ```
  </tab-item>

  <tab-item title="Specific version">
    ```sh
    docker pull docker.elastic.co/kibana/kibana-wolfi:<SPECIFIC.VERSION.NUMBER>
    ```
    You can download and install a specific version of the Elastic Stack by replacing `<SPECIFIC.VERSION.NUMBER>` with the version number you want. For example, you can replace `<SPECIFIC.VERSION.NUMBER>` with 9.0.0.
  </tab-item>
</tab-set>


## Start a single node cluster

1. Install Docker. Visit [Get Docker](https://docs.docker.com/get-docker/) to install Docker for your environment.
   <important>
   If using Docker Desktop, make sure to allocate at least 4GB of memory. You can adjust memory usage in Docker Desktop by going to **Settings > Resources**.
   </important>
2. Create a new Docker network for Elasticsearch and Kibana.
   ```sh
   docker network create elastic
   ```
3. Pull the Elasticsearch Docker image.
   <tab-set>
   <tab-item title="Latest">
   ```sh
   docker pull docker.elastic.co/elasticsearch/elasticsearch:9.3.0
   ```
   </tab-item>

   <tab-item title="Specific version">
   Because Kibana is an Elastic Stack product, you must install the same version number as the rest of your Elastic Stack components. Replace `<SPECIFIC.VERSION.NUMBER>` with the version that's used across your entire stack. For example, you can use 9.0.0. You'll use this same version number throughout this tutorial.
   ```sh
   docker pull docker.elastic.co/elasticsearch/elasticsearch:<SPECIFIC.VERSION.NUMBER>
   ```
   </tab-item>
   </tab-set>
4. Optional: Install [Cosign](https://docs.sigstore.dev/system_config/installation/) for your environment. Then use Cosign to verify the Elasticsearch image’s signature.
   <tab-set>
   <tab-item title="Latest">
   ```sh
   wget https://artifacts.elastic.co/cosign.pub
   cosign verify --key cosign.pub docker.elastic.co/elasticsearch/elasticsearch:9.3.0
   ```
   The `cosign` command prints the check results and the signature payload in JSON format:
   ```sh
   Verification for docker.elastic.co/elasticsearch/elasticsearch:9.3.0 --
   The following checks were performed on each of these signatures:
   - The cosign claims were validated
   - Existence of the claims in the transparency log was verified offline
   - The signatures were verified against the specified public key
   ```
   </tab-item>

   <tab-item title="Specific version">
   Replace `<SPECIFIC.VERSION.NUMBER>` with the version of the Docker image you downloaded.
   ```sh
   wget https://artifacts.elastic.co/cosign.pub
   cosign verify --key cosign.pub docker.elastic.co/elasticsearch/elasticsearch:<SPECIFIC.VERSION.NUMBER>
   ```
   The `cosign` command prints the check results and the signature payload in JSON format:
   ```sh
   Verification for docker.elastic.co/elasticsearch/elasticsearch:<SPECIFIC.VERSION.NUMBER> --
   The following checks were performed on each of these signatures:
   - The cosign claims were validated
   - Existence of the claims in the transparency log was verified offline
   - The signatures were verified against the specified public key
   ```
   </tab-item>
   </tab-set>
5. Start an Elasticsearch container.
   <tab-set>
   <tab-item title="Latest">
   ```sh
   docker run --name es01 --net elastic -p 9200:9200 -it -m 1GB docker.elastic.co/elasticsearch/elasticsearch:9.3.0
   ```
   </tab-item>

   <tab-item title="Specific version">
   Replace `<SPECIFIC.VERSION.NUMBER>` with the version of the Docker image you downloaded.
   ```sh
   docker run --name es01 --net elastic -p 9200:9200 -it -m 1GB docker.elastic.co/elasticsearch/elasticsearch:<SPECIFIC.VERSION.NUMBER>
   ```
   </tab-item>
   </tab-set>
   <tip>
   Use the `-m` flag to set a memory limit for the container. This removes the need to [manually set the JVM size](/docs/deploy-manage/deploy/self-managed/install-elasticsearch-docker-prod#docker-set-heap-size).
   </tip>
   The command prints the `elastic` user password and an enrollment token for Kibana.
6. Copy the generated `elastic` password and enrollment token. These credentials are only shown when you start Elasticsearch for the first time. You can regenerate the credentials using the following commands.
   ```sh
   docker exec -it es01 /usr/share/elasticsearch/bin/elasticsearch-reset-password -u elastic
   docker exec -it es01 /usr/share/elasticsearch/bin/elasticsearch-create-enrollment-token -s kibana
   ```
7. Pull the Kibana Docker image.
   <tab-set>
   <tab-item title="Latest">
   ```sh
   docker pull docker.elastic.co/kibana/kibana:9.3.0
   ```
   </tab-item>

   <tab-item title="Specific version">
   Replace `<SPECIFIC.VERSION.NUMBER>` with the version of the Docker image you downloaded.
   ```sh
   docker pull docker.elastic.co/kibana/kibana:<SPECIFIC.VERSION.NUMBER>
   ```
   </tab-item>
   </tab-set>
8. Optional: Verify the Kibana image’s signature.
   <tab-set>
   <tab-item title="Latest">
   ```sh
   wget https://artifacts.elastic.co/cosign.pub
   cosign verify --key cosign.pub docker.elastic.co/kibana/kibana:9.3.0
   ```
   </tab-item>

   <tab-item title="Specific version">
   Replace `<SPECIFIC.VERSION.NUMBER>` with the version of the Docker image you downloaded.
   ```sh
   wget https://artifacts.elastic.co/cosign.pub
   cosign verify --key cosign.pub docker.elastic.co/kibana/kibana:<SPECIFIC.VERSION.NUMBER>
   ```
   </tab-item>
   </tab-set>
9. Start a Kibana container.
   <tab-set>
   <tab-item title="Latest">
   ```sh
   docker run --name kib01 --net elastic -p 5601:5601 docker.elastic.co/kibana/kibana:9.3.0
   ```
   </tab-item>

   <tab-item title="Specific version">
   Replace `<SPECIFIC.VERSION.NUMBER>` with the version of the Docker image you downloaded.
   ```sh
   docker run --name kib01 --net elastic -p 5601:5601 docker.elastic.co/kibana/kibana:<SPECIFIC.VERSION.NUMBER>
   ```
   </tab-item>
   </tab-set>
10. When Kibana starts, it outputs a unique generated link to the terminal. To access Kibana, open this link in a web browser.
11. In your browser, enter the enrollment token that was generated when you started Elasticsearch.
   To regenerate the token, run:
   ```sh
   docker exec -it es01 /usr/share/elasticsearch/bin/elasticsearch-create-enrollment-token -s kibana
   ```
12. Log in to Kibana as the `elastic` user with the password that was generated when you started Elasticsearch.
   To regenerate the password, run:
   ```sh
   docker exec -it es01 /usr/share/elasticsearch/bin/elasticsearch-reset-password -u elastic
   ```


### Remove Docker containers

To remove the containers and their network, run:
```sh
# Remove the Elastic network
docker network rm elastic

# Remove the Elasticsearch container
docker rm es01

# Remove the Kibana container
docker rm kib01
```


## Configure Kibana on Docker

The Docker images provide several methods for configuring Kibana. The conventional approach is to provide a `kibana.yml` file as described in [Configure Kibana](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-kibana), but it’s also possible to use environment variables to define settings.

### Bind-mounted configuration

One way to configure Kibana on Docker is to provide `kibana.yml` via bind-mounting. With `docker-compose`, the bind-mount can be specified like this:
<tab-set>
  <tab-item title="Latest">
    ```yaml
    version: '2'
    services:
      kibana:
        image: docker.elastic.co/kibana/kibana:9.3.0
        volumes:
          - ./kibana.yml:/usr/share/kibana/config/kibana.yml
    ```
  </tab-item>

  <tab-item title="Specific version">
    Replace `<SPECIFIC.VERSION.NUMBER>` with the version of the Docker image you downloaded.
    ```yaml
    version: '2'
    services:
      kibana:
        image: docker.elastic.co/kibana/kibana:<SPECIFIC.VERSION.NUMBER>
        volumes:
          - ./kibana.yml:/usr/share/kibana/config/kibana.yml
    ```
  </tab-item>
</tab-set>


## Persist the Kibana keystore

By default, Kibana auto-generates a keystore file for secure settings at startup. To persist your [secure settings](https://www.elastic.co/docs/deploy-manage/security/secure-settings), use the `kibana-keystore` utility to bind-mount the parent directory of the keystore to the container. For example:
<tab-set>
  <tab-item title="Latest">
    ```sh
    docker run -it --rm -v full_path_to/config:/usr/share/kibana/config -v full_path_to/data:/usr/share/kibana/data docker.elastic.co/kibana/kibana:9.3.0 bin/kibana-keystore create
    docker run -it --rm -v full_path_to/config:/usr/share/kibana/config -v full_path_to/data:/usr/share/kibana/data docker.elastic.co/kibana/kibana:9.3.0 bin/kibana-keystore add test_keystore_setting
    ```
  </tab-item>

  <tab-item title="Specific version">
    Replace `<SPECIFIC.VERSION.NUMBER>` with the version of the Docker image you downloaded.
    ```sh
    docker run -it --rm -v full_path_to/config:/usr/share/kibana/config -v full_path_to/data:/usr/share/kibana/data docker.elastic.co/kibana/kibana:<SPECIFIC.VERSION.NUMBER> bin/kibana-keystore create
    docker run -it --rm -v full_path_to/config:/usr/share/kibana/config -v full_path_to/data:/usr/share/kibana/data docker.elastic.co/kibana/kibana:<SPECIFIC.VERSION.NUMBER> bin/kibana-keystore add test_keystore_setting
    ```
  </tab-item>
</tab-set>


### Environment variable configuration

Under Docker, Kibana can be configured via environment variables. When the container starts, a helper process checks the environment for variables that can be mapped to Kibana command-line arguments.
For compatibility with container orchestration systems, these environment variables are written in all capitals, with underscores as word separators. The helper translates these names to valid Kibana setting names.
<warning>
  All information that you include in environment variables is visible through the `ps` command, including sensitive information.
</warning>

Some example translations are shown here:

| Environment variable  | Kibana setting        |
|-----------------------|-----------------------|
| `SERVER_NAME`         | `server.name`         |
| `SERVER_BASEPATH`     | `server.basePath`     |
| `ELASTICSEARCH_HOSTS` | `elasticsearch.hosts` |

In general, any setting listed in [Configure Kibana](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-kibana) can be configured with this technique.
Supplying array options can be tricky. The following example shows the syntax for providing an array to `ELASTICSEARCH_HOSTS`.
These variables can be set with `docker-compose` like this:
<tab-set>
  <tab-item title="Latest">
    ```yaml
    version: '2'
    services:
      kibana:
        image: docker.elastic.co/kibana/kibana:9.3.0
        environment:
          SERVER_NAME: kibana.example.org
          ELASTICSEARCH_HOSTS: '["<ELASTICSEARCH_HOST_URL_01>:9200","<ELASTICSEARCH_HOST_URL_02>:9200","<ELASTICSEARCH_HOST_URL_03>:9200"]'
    ```
  </tab-item>

  <tab-item title="Specific version">
    Replace `<SPECIFIC.VERSION.NUMBER>` with the version of the Docker image you downloaded.
    ```yaml
    version: '2'
    services:
      kibana:
        image: docker.elastic.co/kibana/kibana:<SPECIFIC.VERSION.NUMBER>
        environment:
          SERVER_NAME: kibana.example.org
          ELASTICSEARCH_HOSTS: '["<ELASTICSEARCH_HOST_URL_01>:9200","<ELASTICSEARCH_HOST_URL_02>:9200","<ELASTICSEARCH_HOST_URL_03>:9200"]'
    ```
  </tab-item>
</tab-set>

Since environment variables are translated to CLI arguments, they take precedence over settings configured in `kibana.yml`.

### Docker defaults

The following settings have different default values when using the Docker images:
<definitions>
  <definition term="server.host">
    `"0.0.0.0"`
  </definition>
  <definition term="server.shutdownTimeout">
    `"5s"`
  </definition>
  <definition term="elasticsearch.hosts">
    `http://elasticsearch:9200`
  </definition>
  <definition term="monitoring.ui.container.elasticsearch.enabled">
    `true`
  </definition>
</definitions>

These settings are defined in the default `kibana.yml`. They can be overridden with a [custom `kibana.yml`](#bind-mount-config) or using [environment variables](#environment-variable-config).
<important>
  If replacing `kibana.yml` with a custom version, be sure to copy the defaults to the custom file if you want to retain them. If not, they will be "masked" by the new file.
</important>


## Next steps

You now have a basic Kibana instance set up. Consider the following next steps:
- Learn how to [configure Kibana](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-kibana).
- Learn how to [access Kibana](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/access-kibana).
- Explore [key configuration topics](/docs/deploy-manage/deploy/self-managed/configure-kibana#additional-topics) to learn how to secure and manage Kibana.