﻿---
title: Install Kibana with Debian package
description: The Debian package for Kibana can be downloaded from our website or from our APT repository. It can be used to install Kibana on any Debian-based system...
url: https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-kibana-with-debian-package
products:
  - Kibana
---

# Install Kibana with Debian package
The Debian package for Kibana can be [downloaded from our website](#install-deb) or from our [APT repository](#deb-repo). It can be used to install Kibana on any Debian-based system such as Debian and Ubuntu.
This package contains both free and subscription features. [Start a 30-day trial](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/license-settings) to try out all of the features.
The latest stable version of Kibana can be found on the [Download Kibana](https://elastic.co/downloads/kibana) page. Other versions can be found on the [Past Releases page](https://elastic.co/downloads/past-releases).

## Step 1: Import the Elastic PGP key

We sign all of our packages with the Elasticsearch signing key (PGP key [D88E42B4](https://pgp.mit.edu/pks/lookup?op=vindex&search=0xD27D666CD88E42B4), available from [[https://pgp.mit.edu](https://pgp.mit.edu)](https://pgp.mit.edu)) with fingerprint:
```
4609 5ACC 8548 582C 1A26 99A9 D27D 666C D88E 42B4
```

Download and install the public signing key:
```sh
wget -qO - https://artifacts.elastic.co/GPG-KEY-elasticsearch | sudo gpg --dearmor -o /usr/share/keyrings/elasticsearch-keyring.gpg
```


## Step 2: Install Kibana

You have several options for installing the Elasticsearch Debian package:
- [From the APT repository](#deb-repo)
- [Manually](#install-deb)


### Install from the APT repository

1. You may need to install the `apt-transport-https` package on Debian before proceeding:
   ```sh
   sudo apt-get install apt-transport-https
   ```
2. Save the repository definition to `/etc/apt/sources.list.d/elastic-9.x.list`:
   ```sh
   echo "deb [signed-by=/usr/share/keyrings/elasticsearch-keyring.gpg] https://artifacts.elastic.co/packages/9.x/apt stable main" | sudo tee /etc/apt/sources.list.d/elastic-9.x.list
   ```
3. Install the Kibana Debian package:
   ```sh
   sudo apt-get update && sudo apt-get install kibana
   ```

<warning>
  Do not use `add-apt-repository` as it will add a `deb-src` entry as well, but we do not provide a source package. If you have added the `deb-src` entry, you will see an error like the following:
  ```
  Unable to find expected entry 'main/source/Sources' in Release file
  (Wrong sources.list entry or malformed file)
  ```
  Delete the `deb-src` entry from the `/etc/apt/sources.list` file and the installation should work as expected.
</warning>

<warning>
  If two entries exist for the same Kibana repository, you will see an error like this during `apt-get update`:
  ```
  Duplicate sources.list entry https://artifacts.elastic.co/packages/9.x/apt/ ...`
  ```
  Examine `/etc/apt/sources.list.d/kibana-9.x.list` for the duplicate entry or locate the duplicate entry amongst the files in `/etc/apt/sources.list.d/` and the `/etc/apt/sources.list` file.
</warning>


### Download and install the Debian package manually

The Debian package for Kibana 9.3.0 can be downloaded from the website and installed as follows:
<tab-set>
  <tab-item title="Latest">
    To download and install the Kibana 9.3.0 package, enter:
    ```sh
    wget https://artifacts.elastic.co/downloads/kibana/kibana-9.3.0-amd64.deb
    shasum -a 512 kibana-9.3.0-amd64.deb 
    sudo dpkg -i kibana-9.3.0-amd64.deb
    ```
  </tab-item>

  <tab-item title="Specific version">
    Because Kibana is an Elastic Stack product, you must install the same version number as the rest of your Elastic Stack components. Replace `<SPECIFIC.VERSION.NUMBER>` with the version that's used across your entire stack. For example, you can use 9.0.0.
    ```sh
    wget https://artifacts.elastic.co/downloads/kibana/kibana-<SPECIFIC.VERSION.NUMBER>-amd64.deb
    shasum -a 512 kibana-<SPECIFIC.VERSION.NUMBER>-amd64.deb 
    sudo dpkg -i kibana-<SPECIFIC.VERSION.NUMBER>-amd64.deb
    ```
  </tab-item>
</tab-set>


## Step 3: Start Elasticsearch and generate an enrollment token for Kibana

[Start Elasticsearch](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/start-stop-elasticsearch).
When you start your first Elasticsearch node for the first time, it automatically performs the following security setup:
- Generates [TLS certificates](#stack-security-certificates) for the [transport and HTTP layers](/docs/deploy-manage/security/secure-cluster-communications#communication-channels)
- Applies TLS configuration settings to [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings)
- Sets a password for the `elastic` superuser
- Creates an enrollment token to securely connect Kibana to Elasticsearch

You can then start Kibana and enter the enrollment token, which is valid for 30 minutes. This token automatically applies the security settings from your Elasticsearch cluster, authenticates to Elasticsearch with the built-in `kibana` service account, and writes the security configuration to [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings).
<note>
  There are [some cases](/docs/deploy-manage/security/self-auto-setup#stack-skip-auto-configuration) where security can’t be configured automatically because the node startup process detects that the node is already part of a cluster, or that security is already configured or explicitly disabled.
</note>

If your enrollment token has expired, then you can generate a new enrollment token for Kibana with the [`elasticsearch-create-enrollment-token`](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/create-enrollment-token) tool:
```sh
bin/elasticsearch-create-enrollment-token -s kibana
```


## Step 4 (Optional): Make Kibana externally accessible

The default host and port settings configure Kibana to run on localhost:5601. To change this behavior and allow remote users to connect, you need to set up Kibana to run on a routable, external IP address. You can do this by editing the settings in [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-kibana):
1. Open `kibana.yml` in a text editor.
2. Uncomment the line `#server.host: localhost` and replace the default address with `0.0.0.0`. The `0.0.0.0` setting enables Kibana to listen for connections on all available network interfaces. In a production environment, you might want to [use a different value](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings#server-host), such as a static IP address.
   ```yaml
   server.host: 0.0.0.0
   ```
3. Save your changes and close the editor.


## Step 5: Run Kibana with `systemd`

To configure Kibana to start automatically when the system starts, run the following commands:
```sh
sudo /bin/systemctl daemon-reload
sudo /bin/systemctl enable kibana.service
```

Kibana can be started and stopped as follows:
```sh
sudo systemctl start kibana.service
sudo systemctl stop kibana.service
```

These commands provide no feedback as to whether Kibana was started successfully or not. Log information can be accessed using `journalctl -u kibana.service`.

## Step 6: Enroll Kibana with Elasticsearch

1. Run the `status` command to get details about the Kibana service.
   ```sh
   sudo systemctl status kibana
   ```
   In the `status` command output, a URL is shown with:
   - A host address to access Kibana
- A six digit verification code
   For example:
   ```sh
   Kibana has not been configured.
   Go to http://<host>:5601/?code=<code> to get started.
   ```
   Make a note of the verification code.
2. Go to the host address.
   It can take a minute or two for Kibana to start up, so refresh the page if you don’t see a prompt right away.
3. When Kibana starts, you’re prompted to provide an enrollment token. Paste in the Kibana enrollment token that you generated earlier.
4. Click **Configure Elastic**.
5. If you’re prompted to provide a verification code, copy and paste in the six digit code that was returned by the `status` command. Then, wait for the setup to complete.
6. When you see the **Welcome to Elastic** page, provide the `elastic` as the username and provide the password that you copied from the install command output when you set up your first Elasticsearch node.
7. Click **Log in**.


## Step 7: Configure Kibana using the config file

Kibana loads its configuration from the `/etc/kibana/kibana.yml` file by default.  The format of this config file is explained in [Configure Kibana](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-kibana).

## Directory layout of Debian package

The Debian package places config files, logs, and the data directory in the appropriate locations for a Debian-based system:

| Type    | Description                                                                                            | Default Location            | Setting                                                                          |
|---------|--------------------------------------------------------------------------------------------------------|-----------------------------|----------------------------------------------------------------------------------|
| home    | Kibana home directory or `$KIBANA_HOME`                                                                | `/usr/share/kibana`         |                                                                                  |
| bin     | Binary scripts including `kibana` to start the Kibana server    and `kibana-plugin` to install plugins | `/usr/share/kibana/bin`     |                                                                                  |
| config  | Configuration files including `kibana.yml`                                                             | `/etc/kibana`               | `[KBN_PATH_CONF](configure-kibana.md)`                                           |
| data    | The location of the data files written to disk by Kibana and its plugins                               | `/var/lib/kibana`           | `path.data`                                                                      |
| logs    | Logs files location                                                                                    | `/var/log/kibana`           | `[Logging configuration](../../monitor/logging-configuration/kibana-logging.md)` |
| plugins | Plugin files location. Each plugin will be contained in a subdirectory.                                | `/usr/share/kibana/plugins` |                                                                                  |


## Next steps

You now have a basic Kibana instance set up. Consider the following next steps:
- Learn how to [configure Kibana](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-kibana).
- Learn how to [access Kibana](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/access-kibana).
- Explore [key configuration topics](/docs/deploy-manage/deploy/self-managed/configure-kibana#additional-topics) to learn how to secure and manage Kibana.