﻿---
title: Install Kibana on Windows
description: Kibana can be installed on Windows using the .zip package. Start Elasticsearch. Kibana can be started from the command line as follows: By default, Kibana...
url: https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-kibana-on-windows
products:
  - Kibana
---

# Install Kibana on Windows
Kibana can be installed on Windows using the `.zip` package.
This package contains both free and subscription features. [Start a 30-day trial](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/license-settings) to try out all of the features.
The latest stable version of Kibana can be found on the [Download Kibana](https://elastic.co/downloads/kibana) page. Other versions can be found on the [Past Releases page](https://elastic.co/downloads/past-releases).

## Step 1: Download and install the `.zip` package

<tab-set>
  <tab-item title="Latest">
    Download the .zip windows archive for Kibana 9.3.0 from [[https://artifacts.elastic.co/downloads/kibana/kibana-9.3.0-windows-x86_64.zip](https://artifacts.elastic.co/downloads/kibana/kibana-9.3.0-windows-x86_64.zip)](https://artifacts.elastic.co/downloads/kibana/kibana-9.3.0-windows-x86_64.zip)Unzip it with your favorite unzip tool. This will create a folder with the following name:
    ```text
    kibana-9.3.0-windows-x86_64
    ```
    We will refer to this folder as `$KIBANA_HOME`.In a terminal window, CD to the `$KIBANA_HOME` directory, for instance:
    ```sh
    CD c:\kibana-9.3.0-windows-x86_64
    ```
  </tab-item>

  <tab-item title="Specific version">
    Download the `.zip` archive for the Kibana version that you want from the [Past Releases](https://www.elastic.co/downloads/past-releases) page.
    If you're unsure about which version to install, refer to [Elasticsearch version](/docs/deploy-manage/deploy/self-managed/install-kibana#elasticsearch-version) for more information about version compatibility.Unzip it with your favorite unzip tool. This will create a folder called `kibana-<SPECIFIC.VERSION.NUMBER>-windows-x86_64`, where `<SPECIFIC.VERSION.NUMBER>` is the version you downloaded. We will refer to this folder as `$KIBANA_HOME`.In a terminal window, CD to the `$KIBANA_HOME` directory, for instance:
    ```sh
    CD c:\kibana-<SPECIFIC.VERSION.NUMBER>}-windows-x86_64
    ```
    Replace `<SPECIFIC.VERSION.NUMBER>` with the Kibana version number you installed.
  </tab-item>
</tab-set>


## Step 2: Start Elasticsearch and generate an enrollment token for Kibana

[Start Elasticsearch](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/start-stop-elasticsearch).
When you start your first Elasticsearch node for the first time, it automatically performs the following security setup:
- Generates [TLS certificates](#stack-security-certificates) for the [transport and HTTP layers](/docs/deploy-manage/security/secure-cluster-communications#communication-channels)
- Applies TLS configuration settings to [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings)
- Sets a password for the `elastic` superuser
- Creates an enrollment token to securely connect Kibana to Elasticsearch

You can then start Kibana and enter the enrollment token, which is valid for 30 minutes. This token automatically applies the security settings from your Elasticsearch cluster, authenticates to Elasticsearch with the built-in `kibana` service account, and writes the security configuration to [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings).
<note>
  There are [some cases](/docs/deploy-manage/security/self-auto-setup#stack-skip-auto-configuration) where security can’t be configured automatically because the node startup process detects that the node is already part of a cluster, or that security is already configured or explicitly disabled.
</note>

If your enrollment token has expired, then you can generate a new enrollment token for Kibana with the [`elasticsearch-create-enrollment-token`](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/create-enrollment-token) tool:
```sh
bin/elasticsearch-create-enrollment-token -s kibana
```


## Step 3 (Optional): Make Kibana externally accessible

The default host and port settings configure Kibana to run on localhost:5601. To change this behavior and allow remote users to connect, you need to set up Kibana to run on a routable, external IP address. You can do this by editing the settings in [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-kibana):
1. Open `kibana.yml` in a text editor.
2. Uncomment the line `#server.host: localhost` and replace the default address with `0.0.0.0`. The `0.0.0.0` setting enables Kibana to listen for connections on all available network interfaces. In a production environment, you might want to [use a different value](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings#server-host), such as a static IP address.
   ```yaml
   server.host: 0.0.0.0
   ```
3. Save your changes and close the editor.


## Step 4: Run Kibana from the command line

Kibana can be started from the command line as follows:
```sh
.\bin\kibana.bat
```

By default, Kibana runs in the foreground, prints its logs to `STDOUT`, and can be stopped by pressing `Ctrl`+`C`.
If this is the first time you’re starting Kibana, this command generates a unique link in your terminal to enroll your Kibana instance with Elasticsearch.
1. In your terminal, click the generated link to open Kibana in your browser.
2. In your browser, paste the enrollment token that was generated in the terminal when you started Elasticsearch, and then click the button to connect your Kibana instance with Elasticsearch.
3. Log in to Kibana as the `elastic` user with the password that was generated when you started Elasticsearch.

<note>
  If you need to reset the password for the `elastic` user or other built-in users, run the [`elasticsearch-reset-password`](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/reset-password) tool. To generate new enrollment tokens for Kibana or Elasticsearch nodes, run the [`elasticsearch-create-enrollment-token`](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/create-enrollment-token) tool. These tools are available in the Elasticsearch `bin` directory.
</note>

<tip>
  Kibana won’t enter interactive mode if it detects existing credentials for Elasticsearch (`elasticsearch.username` and `elasticsearch.password`) or an existing URL for `elasticsearch.hosts`.In this case, you can enroll Kibana in detached mode:Run the `kibana-setup` tool and pass the generated enrollment token with the `--enrollment-token` parameter.
  ```sh
  bin/kibana-setup --enrollment-token <enrollment-token>
  ```
</tip>


## Step 4: Configure Kibana using the config file

Kibana loads its configuration from the `$KIBANA_HOME/config/kibana.yml` file by default.  The format of this config file is explained in [Configure Kibana](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-kibana).

## Directory layout of `.zip` archive

The `.zip` package is entirely self-contained. All files and directories are, by default, contained within `$KIBANA_HOME` — the directory created when unpacking the archive.
This is very convenient because you don’t have to create any directories to start using Kibana, and uninstalling Kibana is as easy as removing the `$KIBANA_HOME` directory.  However, it is advisable to change the default locations of the config and data directories so that you do not delete important data later on.

| Type   | Description                                                                                            | Default Location                                                         | Setting                                |
|--------|--------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------|----------------------------------------|
| home   | Kibana home directory or `$KIBANA_HOME`                                                                | Directory created by unpacking the archive                               |                                        |
| bin    | Binary scripts including `kibana` to start the Kibana server    and `kibana-plugin` to install plugins | `$KIBANA_HOME\bin`                                                       |                                        |
| config | Configuration files including `kibana.yml`                                                             | `$KIBANA_HOME\config`                                                    | `[KBN_PATH_CONF](configure-kibana.md)` |
|        | data                                                                                                   | The location of the data files written to disk by Kibana and its plugins | `$KIBANA_HOME\data`                    |
|        | plugins                                                                                                | Plugin files location. Each plugin will be contained in a subdirectory.  | `$KIBANA_HOME\plugins`                 |


## Next steps

You now have a basic Kibana instance set up. Consider the following next steps:
- Learn how to [configure Kibana](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-kibana).
- Learn how to [access Kibana](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/access-kibana).
- Explore [key configuration topics](/docs/deploy-manage/deploy/self-managed/configure-kibana#additional-topics) to learn how to secure and manage Kibana.