﻿---
title: Install Elasticsearch with .zip on Windows
description: Elasticsearch can be installed on Windows using the Windows .zip archive. This comes with a elasticsearch-service.bat command which will set up Elasticsearch...
url: https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-with-zip-on-windows
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Install Elasticsearch with .zip on Windows
Elasticsearch can be installed on Windows using the Windows `.zip` archive. This comes with a `elasticsearch-service.bat` command which will set up Elasticsearch to [run as a service](#windows-service).
This package contains both free and subscription features. [Start a 30-day trial](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/license-settings) to try out all of the features.
The latest stable version of Elasticsearch can be found on the [Download Elasticsearch](https://elastic.co/downloads/elasticsearch) page. Other versions can be found on the [Past Releases page](https://elastic.co/downloads/past-releases).
<note>
  Elasticsearch includes a bundled version of [OpenJDK](https://openjdk.java.net) from the JDK maintainers (GPLv2+CE). To use your own version of Java, see the [JVM version requirements](/docs/deploy-manage/deploy/self-managed/installing-elasticsearch#jvm-version).
</note>

<note>
  On Windows, the Elasticsearch machine learning feature requires the Microsoft Universal C Runtime library. This is built into Windows 10, Windows Server 2016 and more recent versions of Windows. For older versions of Windows, it can be installed through Windows Update, or from a [separate download](https://support.microsoft.com/en-us/help/2999226/update-for-universal-c-runtime-in-windows). If you can't install the Microsoft Universal C Runtime library, you can still use the rest of Elasticsearch if you disable the machine learning feature.
</note>


## Before you start

Before you install Elasticsearch, do the following:
- Review the [supported operating systems](https://www.elastic.co/support/matrix) and prepare virtual or physical hosts where you can install Elasticsearch.
  Elasticsearch is tested on the listed platforms, but it is possible that it will work on other platforms too.
- Configure your operating system using the [Important system configuration](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/important-system-configuration) guidelines.


## Step 1: Download and install the `.zip` package

<tab-set>
  <tab-item title="Latest">
    Download the `.zip` archive for Elasticsearch 9.3.0 from: [[https://artifacts.elastic.co/downloads/elasticsearch/elasticsearch-9.3.0-windows-x86_64.zip](https://artifacts.elastic.co/downloads/elasticsearch/elasticsearch-9.3.0-windows-x86_64.zip)](https://artifacts.elastic.co/downloads/elasticsearch/elasticsearch-9.3.0-windows-x86_64.zip)Unzip it with your favorite unzip tool. This will create a folder with the following name:
    ```text
    elasticsearch-9.3.0
    ```
    We will refer to this folder as `%ES_HOME%`.In a terminal window, `cd` to the `%ES_HOME%` directory, for example:
    ```sh
    cd C:\Program Files\elasticsearch-9.3.0
    ```
  </tab-item>

  <tab-item title="Specific version">
    Download the `.zip` archive for the Elasticsearch version that you want from the [Past Releases](https://www.elastic.co/downloads/past-releases) page.Unzip it with your favorite unzip tool. This will create a folder called `elasticsearch-<SPECIFIC.VERSION.NUMBER>`, where `<SPECIFIC.VERSION.NUMBER>` is the version you downloaded. We will refer to this folder as `%ES_HOME%`.In a terminal window, `cd` to the `%ES_HOME%` directory, for example:
    ```sh
    cd C:\Program Files\elasticsearch-<SPECIFIC.VERSION.NUMBER>
    ```
    Replace `<SPECIFIC.VERSION.NUMBER>` with the Elasticsearch version you installed.
  </tab-item>
</tab-set>


## Step 2: Enable automatic creation of system indices

<tip>
  This section is only required if you have previously changed `action.auto_create_index` from its default value.
</tip>

Some features automatically create indices within Elasticsearch. By default, Elasticsearch is configured to allow automatic index creation, and no additional steps are required. However, if you have disabled automatic index creation in Elasticsearch, you must configure [`action.auto_create_index`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/index-management-settings#auto-create-index) in [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-elasticsearch) to allow features to create the following indices:
```yaml
action.auto_create_index: .monitoring*,.watches,.triggered_watches,.watcher-history*,.ml*
```

If you are using [Logstash](https://www.elastic.co/products/logstash) or [Beats](https://www.elastic.co/products/beats) then you will most likely require additional index names in your `action.auto_create_index` setting, and the exact value will depend on your local configuration. If you are unsure of the correct value for your environment, you may consider setting the value to `*` which will allow automatic creation of all indices.

## Step 3: Set up the node for connectivity

When Elasticsearch starts for the first time, the security auto-configuration process binds the HTTP layer to `0.0.0.0`, but only binds the transport layer to `localhost`. This intended behavior ensures that you can start a single-node cluster with security enabled by default without any additional configuration.
Before enrolling a new node, additional actions such as binding to an address other than `localhost` or satisfying bootstrap checks are typically necessary in production clusters. During that time, an auto-generated enrollment token could expire, which is why enrollment tokens aren’t generated automatically.
Only nodes on the same host can join the cluster without additional configuration. If you want nodes from another host to join your cluster, you need make your instance reachable.
For more information about the cluster formation process, refer to [Discovery and cluster formation](https://www.elastic.co/docs/deploy-manage/distributed-architecture/discovery-cluster-formation).
- If you're installing the first node in a multi-node cluster across multiple hosts, then you need to [configure the node so that other hosts are able to connect to it](#first-node).
- If you're installing additional nodes for a cluster, then you need to [generate an enrollment token and pass it when starting Elasticsearch for the first time](#existing-cluster).


### Set up a node as the first node in a multi-host cluster

Update the Elasticsearch configuration on this first node so that other hosts are able to connect to it by editing the settings in [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-elasticsearch):
1. Open `elasticsearch.yml` in a text editor.
2. In a multi-node Elasticsearch cluster, all of the Elasticsearch instances need to have the same name.
   In the configuration file, uncomment the line `#cluster.name: my-application` and give the Elasticsearch instance any name that you’d like:
   ```yaml
   cluster.name: elasticsearch-demo
   ```
3. By default, Elasticsearch runs on `localhost`. For Elasticsearch instances on other nodes to be able to join the cluster, you need to set up Elasticsearch to run on a routable, external IP address.
   Uncomment the line `#network.host: 192.168.0.1` and replace the default address with `0.0.0.0`. The `0.0.0.0` setting enables Elasticsearch to listen for connections on all available network interfaces. In a production environment, you might want to [use a different value](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings#common-network-settings), such as a static IP address or a reference to a [network interface of the host](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings#network-interface-values).
   ```yaml
   network.host: 0.0.0.0
   ```
4. Elasticsearch needs to be enabled to listen for connections from other, external hosts.
   Uncomment the line `#transport.host: 0.0.0.0`. The `0.0.0.0` setting enables Elasticsearch to listen for connections on all available network interfaces. In a production environment you might want to [use a different value](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings#common-network-settings), such as a static IP address or a reference to a [network interface of the host](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings#network-interface-values).
   ```yaml
   transport.host: 0.0.0.0
   ```
   <tip>
   You can find details about the `network.host` and `transport.host` settings in the Elasticsearch [networking settings reference](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings).
   </tip>
5. Save your changes and close the editor.


### Enroll the node in an existing cluster

To enroll new nodes in your cluster, create an enrollment token with the [`elasticsearch-create-enrollment-token`](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/create-enrollment-token) tool on any existing node in your cluster. You can then start a new node with the `--enrollment-token` parameter so that it joins an existing cluster.
<tip>
  Before you enroll your new node, make sure that it is able to access the first node in your cluster. You can test this by running a `curl` command to the first node.If you can't access the first node, then modify your network configuration before proceeding.
</tip>

1. Using a text editor, update the `cluster.name` in [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-elasticsearch) to match the other nodes in your cluster.
   <note>
   If this value isn't updated and you attempt to join an existing cluster, then the connection will fail with the following error:
   ```text
   handshake failed: remote cluster name [cluster-to-join] does not match local cluster name [current-cluster-name]
   ```
   </note>
2. In a separate terminal from where Elasticsearch is running, navigate to the directory where you installed Elasticsearch and run the `elasticsearch-create-enrollment-token` tool to generate an enrollment token for your new nodes.
   ```sh
   .\bin\elasticsearch-create-enrollment-token -s node
   ```
   Copy the enrollment token, which you’ll use to enroll new nodes with your Elasticsearch cluster.
   An enrollment token has a lifespan of 30 minutes. You should create a new enrollment token for each new node that you add.
3. From the installation directory of your new node, start Elasticsearch and pass the enrollment token with the `--enrollment-token` parameter.
   ```sh
   .\bin\elasticsearch --enrollment-token <enrollment-token>
   ```
   Elasticsearch automatically generates certificates and keys in the following directory:
   ```sh
   config\certs
   ```

You can repeat these steps for each additional Elasticsearch node that you would like to add to the cluster.
For more information about discovery and shard allocation, refer to [Discovery and cluster formation](https://www.elastic.co/docs/deploy-manage/distributed-architecture/discovery-cluster-formation) and [Cluster-level shard allocation and routing settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/cluster-level-shard-allocation-routing-settings).

## Step 4: Run Elasticsearch

You have several options for starting Elasticsearch:
- [Run from the command line](#command-line)
- [Install and run as a service](#windows-service)

If you're starting a node that will be enrolled in an existing cluster, refer to [Enroll the node in an existing cluster](#existing-cluster).

### Run Elasticsearch from the command line

Run the following command to start Elasticsearch from the command line:
```sh
.\bin\elasticsearch.bat
```

By default Elasticsearch prints its logs to the console (`STDOUT`) and to the `<cluster name>.log` file within the [logs directory](/docs/deploy-manage/deploy/self-managed/important-settings-configuration#path-settings). Elasticsearch logs some information while it is starting, but after it has finished initializing it will continue to run in the foreground and won’t log anything further until something happens that is worth recording. While Elasticsearch is running you can interact with it through its HTTP interface which is on port `9200` by default.
To stop Elasticsearch, press `Ctrl-C`.

#### Security at startup

When you start your first Elasticsearch node for the first time, it automatically performs the following security setup:
- Generates [TLS certificates](#stack-security-certificates) for the [transport and HTTP layers](/docs/deploy-manage/security/secure-cluster-communications#communication-channels)
- Applies TLS configuration settings to [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings)
- Sets a password for the `elastic` superuser
- Creates an enrollment token to securely connect Kibana to Elasticsearch

You can then start Kibana and enter the enrollment token, which is valid for 30 minutes. This token automatically applies the security settings from your Elasticsearch cluster, authenticates to Elasticsearch with the built-in `kibana` service account, and writes the security configuration to [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings).
<note>
  There are [some cases](/docs/deploy-manage/security/self-auto-setup#stack-skip-auto-configuration) where security can’t be configured automatically because the node startup process detects that the node is already part of a cluster, or that security is already configured or explicitly disabled.
</note>

The password for the `elastic` user and the enrollment token for Kibana are output to your terminal.
We recommend storing the `elastic` password as an environment variable in your shell. For example:
```sh
$ ELASTIC_PASSWORD="your_password"
```

If you have password-protected the Elasticsearch keystore, you will be prompted to enter the keystore’s password. See [Secure settings](https://www.elastic.co/docs/deploy-manage/security/secure-settings) for more details.
To learn how to reset this password, refer to [Set passwords for native and built-in users in self-managed clusters](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-sm).

#### Configure Elasticsearch on the command line

Elasticsearch loads its configuration from the following location by default:
```sh
%ES_HOME%\config\elasticsearch.yml
```

The format of this config file is explained in [Configure Elasticsearch](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-elasticsearch).
Any settings that can be specified in the config file can also be specified on the command line, using the `-E` syntax as follows:
```sh
.\bin\elasticsearch.bat -Ecluster.name=my_cluster -Enode.name=node_1
```

<note>
  Values that contain spaces must be surrounded with quotes. For instance `-Epath.logs="C:\My Logs\logs"`.
</note>

<tip>
  Typically, any cluster-wide settings (like `cluster.name`) should be added to the `elasticsearch.yml` config file, while any node-specific settings such as `node.name` could be specified on the command line.
</tip>


### Install and run Elasticsearch as a service on Windows

You can install Elasticsearch as a service that runs in the background or starts automatically at boot time without user interaction.
1. Install Elasticsearch as a service. The name of the service and the value of `ES_JAVA_HOME` will be made available during install:
   ```sh
   .\bin\elasticsearch-service.bat install
   ```
   Response:
   ```
   Installing service      :  "elasticsearch-service-x64"
   Using ES_JAVA_HOME (64-bit):  "C:\jvm\jdk1.8"
   The service 'elasticsearch-service-x64' has been installed.
   ```
   `ES_JAVA_HOME` is the installation directory of the desired JVM to run the service under. You can change this value using an [environment variable](#windows-service-settings).
   <note>
   While a JRE can be used for the Elasticsearch service, its use is discouraged and using a JRE will trigger a warning. Use is discouraged due to its use of a client VM, as opposed to a server JVM which offers better performance for long-running applications.
   </note>
2. Start Elasticsearch as a service. When Elasticsearch starts, authentication is enabled by default:
   ```sh
   .\bin\elasticsearch-service.bat start
   ```
   <note>
   TLS is not enabled or configured when you start Elasticsearch as a service.
   </note>
3. Generate a password for the `elastic` user with the [`elasticsearch-reset-password`](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/reset-password) tool. The password is output to the command line.
   ```sh
   .\bin\elasticsearch-reset-password -u elastic
   ```


#### Manage Elasticsearch as a service on Windows

Use the `elasticsearch-service.bat` script located in the `bin\` folder to install, remove, manage, start, or stop the service from the command line. Starting and stopping are only available if the service is already installed.
Usage:
```
elasticsearch-service.bat install|remove|start|stop|manager [SERVICE_ID]
```

The script requires one parameter (the command to execute), followed by an optional one indicating the service ID (useful when installing multiple Elasticsearch services).
The commands available are:

| Command   | Description                                                                  |
|-----------|------------------------------------------------------------------------------|
|           |                                                                              |
| `install` | Install Elasticsearch as a service                                           |
| `remove`  | Remove the installed Elasticsearch service (and stop the service if started) |
| `start`   | Start the Elasticsearch service (if installed)                               |
| `stop`    | Stop the Elasticsearch service (if started)                                  |
| `manager` | Start a GUI for managing the installed service                               |


#### Customize service settings

You can customize the service settings before installation using environment variables, or after installation using the Manager GUI.
`elasticsearch-service.bat` relies on [Apache Commons Daemon](https://commons.apache.org/proper/commons-daemon/) project to install the service. Environment variables set prior to the service installation are copied and will be used during the service lifecycle. This means any changes made to them after the installation will not be picked up unless the service is reinstalled.
<tab-set>
  <tab-item title="Environment variables (pre-install)">
    The Elasticsearch service can be configured prior to installation by setting the following environment variables (either using the [set command](https://technet.microsoft.com/en-us/library/cc754250(v=ws.10).aspx) from the command line, or through the **System Properties > Environment Variables** GUI).

    | Environment variable   | Description                                                                                                                                                                                                                                            |
    |------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
    | `SERVICE_ID`           | A unique identifier for the service. Useful if installing multiple instances on the same machine. Defaults to `elasticsearch-service-x64`.                                                                                                             |
    | `SERVICE_USERNAME`     | The user to run as, defaults to the local system account.                                                                                                                                                                                              |
    | `SERVICE_PASSWORD`     | The password for the user specified in `%SERVICE_USERNAME%`.                                                                                                                                                                                           |
    | `SERVICE_DISPLAY_NAME` | The name of the service. Defaults to `Elasticsearch<version> %SERVICE_ID%`.                                                                                                                                                                            |
    | `SERVICE_DESCRIPTION`  | The description of the service. Defaults to `Elasticsearch<version> Windows Service - https://elastic.co`.                                                                                                                                             |
    | `ES_JAVA_HOME`         | The installation directory of the desired JVM to run the service under.                                                                                                                                                                                |
    | `SERVICE_LOG_DIR`      | Service log directory, defaults to `%ES_HOME%\logs`. Note that this does not control the path for the Elasticsearch logs; the path for these is set via the setting `path.logs` in the `elasticsearch.yml` configuration file, or on the command line. |
    | `ES_PATH_CONF`         | Configuration file directory (which needs to include `elasticsearch.yml`, `jvm.options`, and `log4j2.properties` files), defaults to `%ES_HOME%\config`.                                                                                               |
    | `ES_JAVA_OPTS`         | Any additional JVM system properties you may want to apply.                                                                                                                                                                                            |
    | `ES_START_TYPE`        | Startup mode for the service. Can be either `auto` or `manual` (default).                                                                                                                                                                              |
    | `ES_STOP_TIMEOUT`      | The timeout in seconds that procrun waits for service to exit gracefully. Defaults to `0`.                                                                                                                                                             |
  </tab-item>

  <tab-item title="Manager GUI (post-install)">
    It is also possible to configure the service after it’s been installed using the manager GUI (`elasticsearch-service-mgr.exe`), which offers insight into the installed service, including its status, startup type, JVM, start and stop settings amongst other things. To open the manager GUI, run the following command:
    ```sh
    elasticsearch-service.bat manager
    ```
    Most changes (like JVM settings) made through the manager GUI will require a restart of the service to take affect.
  </tab-item>
</tab-set>


##### Considerations

- By default, Elasticsearch automatically sizes JVM heap based on a node’s [roles](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/node-settings#node-roles) and total memory. We recommend this default sizing for most production environments. If needed, you can override default sizing by manually setting the heap size.
  When installing Elasticsearch on Windows as a service for the first time or running Elasticsearch from the command line, you can manually [Set the JVM heap size](https://www.elastic.co/docs/reference/elasticsearch/jvm-settings#set-jvm-heap-size). To resize the heap for an already installed service, use the manager GUI.
- The service automatically configures a private temporary directory for use by Elasticsearch when it is running. This private temporary directory is configured as a sub-directory of the private temporary directory for the user running the installation. If the service will run under a different user, you can configure the location of the temporary directory that the service should use by setting the environment variable `ES_TMPDIR` to the preferred location before you execute the service installation.
- The system environment variable `ES_JAVA_HOME` should be set to the path of the JDK installation that you want the service to use. If you upgrade the JDK, you are not required to the reinstall the service, but you must set the value of the system environment variable `ES_JAVA_HOME` to the path to the new JDK installation. Upgrading across JVM types (e.g. JRE versus SE) is not supported, and requires the service to be reinstalled.


## Step 5: Check that Elasticsearch is running

You can test that your Elasticsearch node is running by sending an HTTPS request to port `9200` on `localhost`:
```sh
curl --cacert %ES_HOME%\config\certs\http_ca.crt 
-u elastic:$ELASTIC_PASSWORD https://localhost:9200 
```

1. `--cacert`: Path to the generated `http_ca.crt` certificate for the HTTP layer.
2. Replace `$ELASTIC_PASSWORD` with the `elastic` superuser password. Ensure that you use `https` in your call, or the request will fail.

The call returns a response like this:
```js
{
  "name" : "Cp8oag6",
  "cluster_name" : "elasticsearch",
  "cluster_uuid" : "AT69_T_DTp-1qgIJlatQqA",
  "version" : {
    "number" : "9.0.0-SNAPSHOT",
    "build_type" : "tar",
    "build_hash" : "f27399d",
    "build_flavor" : "default",
    "build_date" : "2016-03-30T09:51:41.449Z",
    "build_snapshot" : false,
    "lucene_version" : "10.0.0",
    "minimum_wire_compatibility_version" : "1.2.3",
    "minimum_index_compatibility_version" : "1.2.3"
  },
  "tagline" : "You Know, for Search"
}
```


## Step 6 (Multi-node clusters only): Update the config files

If you are deploying a multi-node cluster, then the enrollment process adds all existing nodes to each newly enrolled node's `discovery.seed_hosts` setting. However, you need to go back to all of the nodes in the cluster and edit them so each node in the cluster can restart and rejoin the cluster as expected.
<note>
  Because the initial node in the cluster is bootstrapped as a single-node cluster, it won't have `discovery.seed_hosts` configured. This setting is mandatory for multi-node clusters and must be added manually to the first node.
</note>

Perform the following steps on each node in the cluster:
1. Open [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-elasticsearch) in a text editor.
2. Comment out or remove the `cluster.initial_master_nodes` setting, if present.
3. Update the `discovery.seed_hosts` value so it contains the IP address and port of each of the master-eligible Elasticsearch nodes in the cluster. In the first node in the cluster, you need to add the `discovery.seed_hosts` setting manually.
4. Optionally, [restart the Elasticsearch service](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/start-stop-elasticsearch) to validate your configuration changes.

If you don't perform these steps, then one or more nodes will fail the [discovery configuration bootstrap check](/docs/deploy-manage/deploy/self-managed/bootstrap-checks#bootstrap-checks-discovery-configuration) when they are restarted.
For more information, refer to [Discovery and cluster formation](https://www.elastic.co/docs/deploy-manage/distributed-architecture/discovery-cluster-formation).

## Connect clients to Elasticsearch

When you start Elasticsearch for the first time, TLS is configured automatically for the HTTP layer. A CA certificate is generated and stored on disk at:
```sh
%ES_HOME%\config\certs\http_ca.crt
```

The hex-encoded SHA-256 fingerprint of this certificate is also output to the terminal. Any clients that connect to Elasticsearch, such as the [Elasticsearch Clients](https://www.elastic.co/docs/reference/elasticsearch-clients), Beats, standalone Elastic Agents, and Logstash must validate that they trust the certificate that Elasticsearch uses for HTTPS. Fleet Server and Fleet-managed Elastic Agents are automatically configured to trust the CA certificate. Other clients can establish trust by using either the fingerprint of the CA certificate or the CA certificate itself.
If the auto-configuration process already completed, you can still obtain the fingerprint of the security certificate. You can also copy the CA certificate to your machine and configure your client to use it.

### Use the CA fingerprint

Copy the fingerprint value that’s output to your terminal when Elasticsearch starts, and configure your client to use this fingerprint to establish trust when it connects to Elasticsearch.
If the auto-configuration process already completed, you can still obtain the fingerprint of the security certificate by running the following command. The path is to the auto-generated CA certificate for the HTTP layer.
```sh
openssl x509 -fingerprint -sha256 -in config/certs/http_ca.crt
```

The command returns the security certificate, including the fingerprint. The `issuer` should be `Elasticsearch security auto-configuration HTTP CA`.
```sh
issuer= /CN=Elasticsearch security auto-configuration HTTP CA
SHA256 Fingerprint=<fingerprint>
```


### Use the CA certificate

If your library doesn’t support a method of validating the fingerprint, the auto-generated CA certificate is created in the following directory on each Elasticsearch node:
```sh
%ES_HOME%\config\certs\http_ca.crt
```

Copy the `http_ca.crt` file to your machine and configure your client to use this certificate to establish trust when it connects to Elasticsearch.

## Directory layout of `.zip` archive

The `.zip` package is entirely self-contained. All files and directories are, by default, contained within `%ES_HOME%` — the directory created when unpacking the archive.
This is very convenient because you don’t have to create any directories to start using Elasticsearch, and uninstalling Elasticsearch is as easy as removing the `%ES_HOME%` directory. However, it is advisable to change the default locations of the config directory, the data directory, and the logs directory so that you do not delete important data later on.

| Type    | Description                                                                                                                                                          | Default Location                           | Setting                                                                                                           |
|---------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------|-------------------------------------------------------------------------------------------------------------------|
| home    | Elasticsearch home directory or `%ES_HOME%`                                                                                                                          | Directory created by unpacking the archive |                                                                                                                   |
| bin     | Binary scripts including `elasticsearch` to start a node    and `elasticsearch-plugin` to install plugins                                                            | `%ES_HOME%\bin`                            |                                                                                                                   |
| conf    | Configuration files including `elasticsearch.yml`                                                                                                                    | `%ES_HOME%\config`                         | [`ES_PATH_CONF`](/docs/deploy-manage/deploy/self-managed/configure-elasticsearch#config-files-location)           |
| conf    | Generated TLS keys and certificates for the transport and HTTP layer.                                                                                                | `%ES_HOME%\config\certs`                   |                                                                                                                   |
| data    | The location of the data files of each index / shard allocated    on the node.                                                                                       | `%ES_HOME%\data`                           | [`path.data`](/docs/deploy-manage/deploy/self-managed/important-settings-configuration#path-settings)             |
| logs    | Log files location.                                                                                                                                                  | `%ES_HOME%\logs`                           | [`path.logs`](/docs/deploy-manage/deploy/self-managed/important-settings-configuration#path-settings)             |
| plugins | Plugin files location. Each plugin will be contained in a subdirectory.                                                                                              | `%ES_HOME%\plugins`                        |                                                                                                                   |
| repo    | Shared file system repository locations. Can hold multiple locations. A file system repository can be placed in to any subdirectory of any directory specified here. | Not configured                             | [`path.repo`](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/shared-file-system-repository) |


## Next steps

You now have a test Elasticsearch environment set up. Before you start serious development or go into production with Elasticsearch, you must do some additional setup:
- Learn how to [configure Elasticsearch](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-elasticsearch).
- Configure [important Elasticsearch settings](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/important-settings-configuration).
- Install [Kibana](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-kibana), the user interface for all Elastic solutions.

You can also do the following:
- Consider installing [additional Elastic Stack components](https://www.elastic.co/docs/get-started/the-stack).
- Learn how to [ingest data into Elasticsearch](https://www.elastic.co/docs/manage-data).
- Learn about [production considerations](https://www.elastic.co/docs/deploy-manage/production-guidance).
- Explore [other topics](/docs/deploy-manage/deploy/self-managed#other-important-sections) to learn how to secure and manage your cluster.