﻿---
title: Install Elasticsearch with RPM
description: The RPM package for Elasticsearch can be downloaded from our website or from our  RPM repository. It can be used to install Elasticsearch on any RPM-based...
url: https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-with-rpm
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Install Elasticsearch with RPM
The RPM package for Elasticsearch can be [downloaded from our website](#install-rpm) or from our  [RPM repository](#rpm-repo). It can be used to install Elasticsearch on any RPM-based system such as openSUSE, SUSE Linux Enterprise Server (SLES), CentOS, Red Hat Enterprise Linux (RHEL), and Oracle Linux.
<note>
  RPM install is not supported on distributions with old versions of RPM, such as SLES 11 and CentOS 5. Refer to [Install Elasticsearch from archive on Linux or MacOS](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-from-archive-on-linux-macos) instead.
</note>

This package contains both free and subscription features. [Start a 30-day trial](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/license-settings) to try out all of the features.
The latest stable version of Elasticsearch can be found on the [Download Elasticsearch](https://elastic.co/downloads/elasticsearch) page. Other versions can be found on the [Past Releases page](https://elastic.co/downloads/past-releases).
<note>
  Elasticsearch includes a bundled version of [OpenJDK](https://openjdk.java.net) from the JDK maintainers (GPLv2+CE). To use your own version of Java, see the [JVM version requirements](/docs/deploy-manage/deploy/self-managed/installing-elasticsearch#jvm-version).
</note>


## Before you start

Before you install Elasticsearch, do the following:
- Review the [supported operating systems](https://www.elastic.co/support/matrix) and prepare virtual or physical hosts where you can install Elasticsearch.
  Elasticsearch is tested on the listed platforms, but it is possible that it will work on other platforms too.
- Configure your operating system using the [Important system configuration](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/important-system-configuration) guidelines.


## Step 1: Import the Elasticsearch PGP key

We sign all of our packages with the Elasticsearch signing key (PGP key [D88E42B4](https://pgp.mit.edu/pks/lookup?op=vindex&search=0xD27D666CD88E42B4), available from [[https://pgp.mit.edu](https://pgp.mit.edu)](https://pgp.mit.edu)) with fingerprint:
```
4609 5ACC 8548 582C 1A26 99A9 D27D 666C D88E 42B4
```

Download and install the public signing key:
```sh
rpm --import https://artifacts.elastic.co/GPG-KEY-elasticsearch
```


## Step 2: Install Elasticsearch

You have two options for installing the Elasticsearch RPM package:
- [From the RPM repository](#rpm-repo)
- [Manually](#install-rpm)


### Install from the RPM repository

1. Define a repository for Elasticsearch.

<tab-set>
  <tab-item title="RedHat distributions">
    For RedHat based distributions, create a file called `elasticsearch.repo` in the `/etc/yum.repos.d/` directory and include the following configuration:
    ```ini
    [elasticsearch]
    name=Elasticsearch repository for 9.x packages
    baseurl=https://artifacts.elastic.co/packages/9.x/yum
    gpgcheck=1
    gpgkey=https://artifacts.elastic.co/GPG-KEY-elasticsearch
    enabled=0
    type=rpm-md
    ```
  </tab-item>

  <tab-item title="openSUSE distributions">
    For openSUSE based distributions, create a file called `elasticsearch.repo` in the `/etc/zypp/repos.d/` directory and include the following configuration:
    ```ini
    [elasticsearch]
    name=Elasticsearch repository for 9.x packages
    baseurl=https://artifacts.elastic.co/packages/9.x/yum
    gpgcheck=1
    gpgkey=https://artifacts.elastic.co/GPG-KEY-elasticsearch
    enabled=0
    autorefresh=1
    type=rpm-md
    ```
  </tab-item>
</tab-set>

1. Install Elasticsearch from the repository you defined earlier.

<tab-set>
  <tab-item title="RedHat distributions">
    If you use Fedora, or Red Hat Enterprise Linux 8 and later, enter the following command:
    ```sh
    sudo dnf install --enablerepo=elasticsearch elasticsearch
    ```
    If you use CentOS, or Red Hat Enterprise Linux 7 and earlier, enter the following command:
    ```sh
    sudo yum install --enablerepo=elasticsearch elasticsearch
    ```
  </tab-item>

  <tab-item title="openSUSE distributions">
    Enter the following command:
    ```sh
    sudo zypper modifyrepo --enable elasticsearch && \
      sudo zypper install elasticsearch; \
      sudo zypper modifyrepo --disable elasticsearch
    ```
  </tab-item>
</tab-set>


### Download and install the RPM manually

1. Download and install the RPM for Elasticsearch with the following commands:

<tab-set>
  <tab-item title="Latest">
    To download and install the Elasticsearch 9.3.0 RPM, enter:
    ```sh
    wget https://artifacts.elastic.co/downloads/elasticsearch/elasticsearch-9.3.0-x86_64.rpm
    wget https://artifacts.elastic.co/downloads/elasticsearch/elasticsearch-9.3.0-x86_64.rpm.sha512
    shasum -a 512 -c elasticsearch-9.3.0-x86_64.rpm.sha512 
    sudo rpm --install elasticsearch-9.3.0-x86_64.rpm
    ```

    <note>
      On systemd-based distributions, the installation scripts will attempt to set kernel parameters (e.g., `vm.max_map_count`). You can skip this by masking the `systemd-sysctl.service` unit.
    </note>
  </tab-item>

  <tab-item title="Specific version">
    Replace `<SPECIFIC.VERSION.NUMBER>` with the Elasticsearch version number you want. For example, you can replace `<SPECIFIC.VERSION.NUMBER>` with 9.0.0.
    ```sh
    wget https://artifacts.elastic.co/downloads/elasticsearch/elasticsearch-<SPECIFIC.VERSION.NUMBER>-x86_64.rpm
    wget https://artifacts.elastic.co/downloads/elasticsearch/elasticsearch-<SPECIFIC.VERSION.NUMBER>-x86_64.rpm.sha512
    shasum -a 512 -c elasticsearch-<SPECIFIC.VERSION.NUMBER>-x86_64.rpm.sha512 
    sudo rpm --install elasticsearch-<SPECIFIC.VERSION.NUMBER>-x86_64.rpm
    ```

    <note>
      On systemd-based distributions, the installation scripts will attempt to set kernel parameters (e.g., `vm.max_map_count`). You can skip this by masking the `systemd-sysctl.service` unit.
    </note>
  </tab-item>
</tab-set>

1. Copy the terminal output from the install command to a local file. In particular, you’ll need the password for the built-in `elastic` superuser account. The output also contains the commands to enable Elasticsearch to [run as a service](#running-systemd).


## Step 3: Set up the node for connectivity

When Elasticsearch starts for the first time, the security auto-configuration process binds the HTTP layer to `0.0.0.0`, but only binds the transport layer to `localhost`. This intended behavior ensures that you can start a single-node cluster with security enabled by default without any additional configuration.
Before enrolling a new node, additional actions such as binding to an address other than `localhost` or satisfying bootstrap checks are typically necessary in production clusters. During that time, an auto-generated enrollment token could expire, which is why enrollment tokens aren’t generated automatically.
Only nodes on the same host can join the cluster without additional configuration. If you want nodes from another host to join your cluster, you need make your instance reachable.
- If you're installing the first node in a multi-node cluster across multiple hosts, then you need to [configure the node so that other hosts are able to connect to it](#first-node).
- If you're installing additional nodes for a cluster, then you need to [generate an enrollment token and then reconfigure the new node to join an existing cluster](#existing-cluster).

If you're running a single-node cluster, then skip to the next step.
For more information about the cluster formation process, refer to [Discovery and cluster formation](https://www.elastic.co/docs/deploy-manage/distributed-architecture/discovery-cluster-formation).

### Set up a node as the first node in a cluster

Update the Elasticsearch configuration on this first node so that other hosts are able to connect to it by editing the settings in [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-elasticsearch):
1. Open `elasticsearch.yml` in a text editor.
2. In a multi-node Elasticsearch cluster, all of the Elasticsearch instances need to have the same name.
   In the configuration file, uncomment the line `#cluster.name: my-application` and give the Elasticsearch instance any name that you’d like:
   ```yaml
   cluster.name: elasticsearch-demo
   ```
3. By default, Elasticsearch runs on `localhost`. For Elasticsearch instances on other nodes to be able to join the cluster, you need to set up Elasticsearch to run on a routable, external IP address.
   Uncomment the line `#network.host: 192.168.0.1` and replace the default address with `0.0.0.0`. The `0.0.0.0` setting enables Elasticsearch to listen for connections on all available network interfaces. In a production environment, you might want to [use a different value](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings#common-network-settings), such as a static IP address or a reference to a [network interface of the host](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings#network-interface-values).
   ```yaml
   network.host: 0.0.0.0
   ```
4. Elasticsearch needs to be enabled to listen for connections from other, external hosts.
   Uncomment the line `#transport.host: 0.0.0.0`. The `0.0.0.0` setting enables Elasticsearch to listen for connections on all available network interfaces. In a production environment you might want to [use a different value](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings#common-network-settings), such as a static IP address or a reference to a [network interface of the host](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings#network-interface-values).
   ```yaml
   transport.host: 0.0.0.0
   ```
   <tip>
   You can find details about the `network.host` and `transport.host` settings in the Elasticsearch [networking settings reference](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings).
   </tip>
5. Save your changes and close the editor.


### Reconfigure a node to join an existing cluster

When you install Elasticsearch, the installation process configures a single-node cluster by default. If you want a node to join an existing cluster instead, generate an enrollment token on an existing node *before* you start the new node for the first time.
<tip>
  Before you enroll your new node, make sure that your new node is able to access the first node in your cluster. You can test this by running a `curl` command to the first node.If you can't access the first node, then modify your network configuration before proceeding.
</tip>

1. On any node in your existing cluster, generate a node enrollment token:
   ```sh
   /usr/share/elasticsearch/bin/elasticsearch-create-enrollment-token -s node
   ```
   An enrollment token has a lifespan of 30 minutes. You should create a new enrollment token for each new node that you add.
2. Copy the enrollment token, which is output to your terminal.
3. On your new Elasticsearch node, pass the enrollment token as a parameter to the [`elasticsearch-reconfigure-node`](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/reconfigure-node) tool:
   ```sh
   /usr/share/elasticsearch/bin/elasticsearch-reconfigure-node --enrollment-token <enrollment-token>
   ```
   Answer the `Do you want to continue` prompt with `yes` (`y`). The new Elasticsearch node will be reconfigured.
4. Open the new Elasticsearch instance's [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-elasticsearch) file in a text editor.
   The `elasticsearch-reconfigure-node` tool has updated several settings. For example:
   - The `transport.host: 0.0.0.0` setting is already uncommented.
- The `discovery_seed.hosts` setting has the IP address and port of the other Elasticsearch nodes added the cluster so far. As you add each new Elasticsearch node to the cluster, the `discovery_seed.hosts` setting will contain an array of the IP addresses and port numbers to connect to each Elasticsearch node that was previously added to the cluster.
5. In the configuration file, uncomment the line `#cluster.name: my-application` and set it to match the name you specified for the first Elasticsearch node:
   ```yml
   cluster.name: elasticsearch-demo
   ```
6. As with the first Elasticsearch node, you’ll need to set up Elasticsearch to run on a routable, external IP address.
   Uncomment the line `#network.host: 192.168.0.1` and replace the default address with `0.0.0.0`. The `0.0.0.0` setting enables Elasticsearch to listen for connections on all available network interfaces. In a production environment, you might want to [use a different value](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings#common-network-settings), such as a static IP address or a reference to a [network interface of the host](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings#network-interface-values).
   ```yaml
   network.host: 0.0.0.0
   ```
7. Save your changes and close the editor.

You can repeat these steps for each additional Elasticsearch node that you would like to add to the cluster.
<warning>
  If you're setting up a multi-node cluster, then as soon as you add a second node to your cluster, you need to [update your first node's config file](#update-config-files) or it won't be able to restart.
</warning>


## Step 4: Enable automatic creation of system indices

<tip>
  This section is only required if you have previously changed `action.auto_create_index` from its default value.
</tip>

Some features automatically create indices within Elasticsearch. By default, Elasticsearch is configured to allow automatic index creation, and no additional steps are required. However, if you have disabled automatic index creation in Elasticsearch, you must configure [`action.auto_create_index`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/index-management-settings#auto-create-index) in [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-elasticsearch) to allow features to create the following indices:
```yaml
action.auto_create_index: .monitoring*,.watches,.triggered_watches,.watcher-history*,.ml*
```

If you are using [Logstash](https://www.elastic.co/products/logstash) or [Beats](https://www.elastic.co/products/beats) then you will most likely require additional index names in your `action.auto_create_index` setting, and the exact value will depend on your local configuration. If you are unsure of the correct value for your environment, you may consider setting the value to `*` which will allow automatic creation of all indices.

## Step 5: Run Elasticsearch with `systemd`

Elasticsearch can be started and stopped as follows:
```sh
sudo systemctl start elasticsearch.service
sudo systemctl stop elasticsearch.service
```

These commands provide no feedback as to whether Elasticsearch was started successfully or not. Instead, this information will be written in the log files located in `/var/log/elasticsearch/`.
If you have password-protected your Elasticsearch keystore, you will need to provide `systemd` with the keystore password using a local file and systemd environment variables. This local file should be protected while it exists and may be safely deleted once Elasticsearch is up and running.
```sh
echo "keystore_password" > /path/to/my_pwd_file.tmp
chmod 600 /path/to/my_pwd_file.tmp
sudo systemctl set-environment ES_KEYSTORE_PASSPHRASE_FILE=/path/to/my_pwd_file.tmp
sudo systemctl start elasticsearch.service
```


### Start Elasticsearch automatically

To configure Elasticsearch to start automatically when the system boots up, run the following commands:
```sh
sudo /bin/systemctl daemon-reload
sudo /bin/systemctl enable elasticsearch.service
```


### Log to the systemd journal

By default, the Elasticsearch service doesn’t log information in the `systemd` journal. To enable `journalctl` logging, the `--quiet` option must be removed from the `ExecStart` command line in the `elasticsearch.service` file.
When `systemd` logging is enabled, the logging information are available using the `journalctl` commands:
To tail the journal:
```sh
sudo journalctl -f
```

To list journal entries for the elasticsearch service:
```sh
sudo journalctl --unit elasticsearch
```

To list journal entries for the elasticsearch service starting from a given time:
```sh
sudo journalctl --unit elasticsearch --since  "2016-10-30 18:17:16"
```

Check `man journalctl` or [[https://www.freedesktop.org/software/systemd/man/journalctl.html](https://www.freedesktop.org/software/systemd/man/journalctl.html)](https://www.freedesktop.org/software/systemd/man/journalctl.md) for more command line options.
<admonition title="Startup timeouts with older systemd versions">
  By default Elasticsearch sets the `TimeoutStartSec` parameter to `systemd` to `900s`. If you are running at least version 238 of `systemd`, then Elasticsearch can automatically extend the startup timeout, and will do so repeatedly until startup is complete even if it takes longer than 900s.Versions of `systemd` prior to 238 do not support the timeout extension mechanism and will terminate the Elasticsearch process if it has not fully started up within the configured timeout. If this happens, Elasticsearch will report in its logs that it was shut down normally a short time after it started:
  ```text
  [2022-01-31T01:22:31,077][INFO ][o.e.n.Node               ] [instance-0000000123] starting ...
  ...
  [2022-01-31T01:37:15,077][INFO ][o.e.n.Node               ] [instance-0000000123] stopping ...
  ```
  However the `systemd` logs will report that the startup timed out:
  ```text
  Jan 31 01:22:30 debian systemd[1]: Starting Elasticsearch...
  Jan 31 01:37:15 debian systemd[1]: elasticsearch.service: Start operation timed out. Terminating.
  Jan 31 01:37:15 debian systemd[1]: elasticsearch.service: Main process exited, code=killed, status=15/TERM
  Jan 31 01:37:15 debian systemd[1]: elasticsearch.service: Failed with result 'timeout'.
  Jan 31 01:37:15 debian systemd[1]: Failed to start Elasticsearch.
  ```
  To avoid this, upgrade your `systemd` to at least version 238. You can also temporarily work around the problem by extending the `TimeoutStartSec` parameter.
</admonition>


### Security at startup

When you start Elasticsearch for the first time, it automatically performs the following security setup:
- Generates [TLS certificates](#stack-security-certificates) for the [transport and HTTP layers](/docs/deploy-manage/security/secure-cluster-communications#communication-channels)
- Applies TLS configuration settings to [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings)
- Creates an enrollment token to securely connect Kibana to Elasticsearch

You can then start Kibana and enter the enrollment token, which is valid for 30 minutes. This token automatically applies the security settings from your Elasticsearch cluster, authenticates to Elasticsearch with the built-in `kibana` service account, and writes the security configuration to [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings).
<note>
  There are [some cases](/docs/deploy-manage/security/self-auto-setup#stack-skip-auto-configuration) where security can’t be configured automatically because the node startup process detects that the node is already part of a cluster, or that security is already configured or explicitly disabled.
</note>


## Step 6: Reset the `elastic` superuser password

Because Elasticsearch runs with `systemd` and not in a terminal, the `elastic` superuser password is not output when Elasticsearch starts for the first time. Use the [`elasticsearch-reset-password`](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/reset-password) tool tool to set the password for the user. This only needs to be done once for the cluster, and can be done as soon as the first node is started.
```shell
bin/elasticsearch-reset-password -u elastic
```

We recommend storing the `elastic` password as an environment variable in your shell. For example:
```sh
export ELASTIC_PASSWORD="your_password"
```

If you have password-protected the Elasticsearch keystore, you will be prompted to enter the keystore’s password. See [Secure settings](https://www.elastic.co/docs/deploy-manage/security/secure-settings) for more details.
To learn how to reset this password, refer to [Set passwords for native and built-in users in self-managed clusters](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-sm).

## Step 7: Check that Elasticsearch is running

You can test that your Elasticsearch node is running by sending an HTTPS request to port `9200` on `localhost`:
```sh
curl --cacert /etc/elasticsearch/certs/http_ca.crt 
-u elastic:$ELASTIC_PASSWORD https://localhost:9200 
```

1. `--cacert`: Path to the generated `http_ca.crt` certificate for the HTTP layer.
2. Replace `$ELASTIC_PASSWORD` with the `elastic` superuser password. Ensure that you use `https` in your call, or the request will fail.

The call returns a response like this:
```js
{
  "name" : "Cp8oag6",
  "cluster_name" : "elasticsearch",
  "cluster_uuid" : "AT69_T_DTp-1qgIJlatQqA",
  "version" : {
    "number" : "9.0.0-SNAPSHOT",
    "build_type" : "tar",
    "build_hash" : "f27399d",
    "build_flavor" : "default",
    "build_date" : "2016-03-30T09:51:41.449Z",
    "build_snapshot" : false,
    "lucene_version" : "10.0.0",
    "minimum_wire_compatibility_version" : "1.2.3",
    "minimum_index_compatibility_version" : "1.2.3"
  },
  "tagline" : "You Know, for Search"
}
```


## Step 8 (Multi-node clusters only): Update the config files

If you are deploying a multi-node cluster, then the `elasticsearch-reconfigure-node` tool adds all existing nodes to each newly enrolled node's `discovery.seed_hosts` setting. However, you need to go back to all of the nodes in the cluster and edit them so each node in the cluster can restart and rejoin the cluster as expected.
<note>
  Because the initial node in the cluster is bootstrapped as a single-node cluster, it won't have `discovery.seed_hosts` configured. This setting is mandatory for multi-node clusters and must be added manually to the first node.
</note>

Perform the following steps on each node in the cluster:
1. Open [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-elasticsearch) in a text editor.
2. Comment out or remove the `cluster.initial_master_nodes` setting, if present.
3. Update the `discovery.seed_hosts` value so it contains the IP address and port of each of the master-eligible Elasticsearch nodes in the cluster. In the first node in the cluster, you need to add the `discovery.seed_hosts` setting manually.
4. Optionally, [restart the Elasticsearch service](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/start-stop-elasticsearch) to validate your configuration changes.

If you don't perform these steps, then one or more nodes will fail the [discovery configuration bootstrap check](/docs/deploy-manage/deploy/self-managed/bootstrap-checks#bootstrap-checks-discovery-configuration) when they are restarted.
For more information, refer to [Discovery and cluster formation](https://www.elastic.co/docs/deploy-manage/distributed-architecture/discovery-cluster-formation).

## Configuring Elasticsearch

The `/etc/elasticsearch` directory contains the default runtime configuration for Elasticsearch. The ownership of this directory and all contained files are set to `root:elasticsearch` on package installations.
The `setgid` flag applies group permissions on the `/etc/elasticsearch` directory to ensure that Elasticsearch can read any contained files and subdirectories. All files and subdirectories inherit the `root:elasticsearch` ownership. Running commands from this directory or any subdirectories, such as the [elasticsearch-keystore tool](https://www.elastic.co/docs/deploy-manage/security/secure-settings), requires `root:elasticsearch` permissions.
Elasticsearch loads its configuration from the `/etc/elasticsearch/elasticsearch.yml` file by default. The format of this config file is explained in [Configure Elasticsearch](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-elasticsearch).
The RPM package also has a system configuration file at the following path:
```txt
/etc/sysconfig/elasticsearch
```

In this file, you can set the following parameters:

| Parameter            | Description                                                                                                                                                                                                                                                                                                                                                       |
|----------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `ES_JAVA_HOME`       | Set a custom Java path to be used.                                                                                                                                                                                                                                                                                                                                |
| `ES_PATH_CONF`       | Configuration file directory (which needs to include `elasticsearch.yml`, `jvm.options`, and `log4j2.properties` files); defaults to `/etc/elasticsearch`.                                                                                                                                                                                                        |
| `ES_JAVA_OPTS`       | Any additional JVM system properties you may want to apply.                                                                                                                                                                                                                                                                                                       |
| `RESTART_ON_UPGRADE` | Configure restart on package upgrade, defaults to `false`. This means you will have to restart your Elasticsearch instance after installing a package  manually. The reason for this is to ensure, that upgrades in a cluster do not result in a continuous shard reallocation resulting in high network traffic and reducing the response times of your cluster. |

<note>
  Distributions that use `systemd` require that system resource limits be configured via `systemd` rather than via the /etc/sysconfig/elasticsearch file. See [Systemd configuration](/docs/deploy-manage/deploy/self-managed/setting-system-settings#systemd) for more information.
</note>


## Connect clients to Elasticsearch

When you start Elasticsearch for the first time, TLS is configured automatically for the HTTP layer. A CA certificate is generated and stored on disk at:
```sh
/etc/elasticsearch/certs/http_ca.crt
```

The hex-encoded SHA-256 fingerprint of this certificate is also output to the terminal. Any clients that connect to Elasticsearch, such as the [Elasticsearch Clients](https://www.elastic.co/docs/reference/elasticsearch-clients), Beats, standalone Elastic Agents, and Logstash must validate that they trust the certificate that Elasticsearch uses for HTTPS. Fleet Server and Fleet-managed Elastic Agents are automatically configured to trust the CA certificate. Other clients can establish trust by using either the fingerprint of the CA certificate or the CA certificate itself.
If the auto-configuration process already completed, you can still obtain the fingerprint of the security certificate. You can also copy the CA certificate to your machine and configure your client to use it.

### Use the CA fingerprint

Copy the fingerprint value that’s output to your terminal when Elasticsearch starts, and configure your client to use this fingerprint to establish trust when it connects to Elasticsearch.
If the auto-configuration process already completed, you can still obtain the fingerprint of the security certificate by running the following command. The path is to the auto-generated CA certificate for the HTTP layer.
```sh
openssl x509 -fingerprint -sha256 -in config/certs/http_ca.crt
```

The command returns the security certificate, including the fingerprint. The `issuer` should be `Elasticsearch security auto-configuration HTTP CA`.
```sh
issuer= /CN=Elasticsearch security auto-configuration HTTP CA
SHA256 Fingerprint=<fingerprint>
```


### Use the CA certificate

If your library doesn’t support a method of validating the fingerprint, the auto-generated CA certificate is created in the following directory on each Elasticsearch node:
```sh
/etc/elasticsearch/certs/http_ca.crt
```

Copy the `http_ca.crt` file to your machine and configure your client to use this certificate to establish trust when it connects to Elasticsearch.

## Directory layout of RPM

The RPM places config files, logs, and the data directory in the appropriate locations for an RPM-based system:

| Type    | Description                                                                                                                                                               | Default Location                   | Setting                                                                                                           |
|---------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------|-------------------------------------------------------------------------------------------------------------------|
| home    | Elasticsearch home directory or `$ES_HOME`                                                                                                                                | `/usr/share/elasticsearch`         |                                                                                                                   |
| bin     | Binary scripts including `elasticsearch` to start a node    and `elasticsearch-plugin` to install plugins                                                                 | `/usr/share/elasticsearch/bin`     |                                                                                                                   |
| conf    | Configuration files including `elasticsearch.yml`                                                                                                                         | `/etc/elasticsearch`               | [`ES_PATH_CONF`](/docs/deploy-manage/deploy/self-managed/configure-elasticsearch#config-files-location)           |
| conf    | Environment variables including heap size, file descriptors.                                                                                                              | `/etc/sysconfig/elasticsearch`     |                                                                                                                   |
| conf    | Generated TLS keys and certificates for the transport and http layer.                                                                                                     | `/etc/elasticsearch/certs`         |                                                                                                                   |
| data    | The location of the data files of each index / shard allocated    on the node.                                                                                            | `/var/lib/elasticsearch`           | [`path.data`](/docs/deploy-manage/deploy/self-managed/important-settings-configuration#path-settings)             |
| jdk     | The bundled Java Development Kit used to run Elasticsearch. Can    be overridden by setting the `ES_JAVA_HOME` environment variable    in `/etc/sysconfig/elasticsearch`. | `/usr/share/elasticsearch/jdk`     |                                                                                                                   |
| logs    | Log files location.                                                                                                                                                       | `/var/log/elasticsearch`           | [`path.logs`](/docs/deploy-manage/deploy/self-managed/important-settings-configuration#path-settings)             |
| plugins | Plugin files location. Each plugin will be contained in a subdirectory.                                                                                                   | `/usr/share/elasticsearch/plugins` |                                                                                                                   |
| repo    | Shared file system repository locations. Can hold multiple locations. A file system repository can be placed in to any subdirectory of any directory specified here.      | Not configured                     | [`path.repo`](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/shared-file-system-repository) |


## Next steps

You now have a test Elasticsearch environment set up. Before you start serious development or go into production with Elasticsearch, you must do some additional setup:
- Learn how to [configure Elasticsearch](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-elasticsearch).
- Configure [important Elasticsearch settings](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/important-settings-configuration).
- Install [Kibana](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-kibana), the user interface for all Elastic solutions.

You can also do the following:
- Consider installing [additional Elastic Stack components](https://www.elastic.co/docs/get-started/the-stack).
- Learn how to [ingest data into Elasticsearch](https://www.elastic.co/docs/manage-data).
- Learn about [production considerations](https://www.elastic.co/docs/deploy-manage/production-guidance).
- Explore [other topics](/docs/deploy-manage/deploy/self-managed#other-important-sections) to learn how to secure and manage your cluster.