﻿---
title: Important system configuration
description: Ideally, Elasticsearch should run alone on a server and use all of the resources available to it. In order to do so, you need to configure your operating...
url: https://www.elastic.co/docs/deploy-manage/deploy/self-managed/important-system-configuration
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Important system configuration
Ideally, Elasticsearch should run alone on a server and use all of the resources available to it. In order to do so, you need to configure your operating system to allow the user running Elasticsearch to access more resources than allowed by default.
The following settings **must** be considered before going to production:
- [Configure system settings](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/setting-system-settings)
- [Disable swapping](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/setup-configuration-memory)
- [Increase virtual memory](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/vm-max-map-count)
- [Increase the maximum number of threads](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/max-number-of-threads)
- [Increase the file descriptor limit](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/file-descriptors) (Linux and MacOS only)
- [Ensure JNA temporary directory permits executables](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/executable-jna-tmpdir) (Linux only)
- [Decrease the TCP retransmission timeout](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/system-config-tcpretries) (Linux only)

<tip>
  For examples of applying the relevant settings in a Docker environment, refer to [Using the Docker images in production](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-elasticsearch-docker-prod).
</tip>

<admonition title="Use dedicated hosts">
  In production, we recommend you run Elasticsearch on a dedicated host or as a primary service. Several Elasticsearch features, such as automatic JVM heap sizing, assume that Elasticsearch is the only resource-intensive application on the host or container. For example, you might run Metricbeat alongside Elasticsearch for cluster statistics, but a resource-heavy Logstash deployment should be on its own host.
</admonition>


## Bootstrap checks

Elasticsearch has bootstrap checks that run at startup to ensure that users have configured all important settings.
For a list of the checks and their meaning, refer to [Bootstrap checks](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/bootstrap-checks).

### Development mode vs. production mode

By default, Elasticsearch assumes that you are working in development mode. If any of the above settings are not configured correctly, the relevant bootstrap check will fail and a warning will be written to the log file, but you will be able to start and run your Elasticsearch node.
As soon as you configure a network setting like `network.host`, Elasticsearch assumes that you are moving to production and will upgrade the above warnings to exceptions. These exceptions will prevent your Elasticsearch node from starting. This is an important safety measure to ensure that you will not lose data because of a misconfigured server.