﻿---
title: Increase the file descriptor limit
description: Elasticsearch uses a lot of file descriptors or file handles. Running out of file descriptors can be disastrous and will most probably lead to data loss...
url: https://www.elastic.co/docs/deploy-manage/deploy/self-managed/file-descriptors
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Increase the file descriptor limit
<note>
  This is only relevant for Linux and macOS and can be safely ignored if running Elasticsearch on Windows. On Windows, that JVM uses an [API](https://msdn.microsoft.com/en-us/library/windows/desktop/aa363858(v=vs.85).aspx) limited only by available resources.
</note>

Elasticsearch uses a lot of file descriptors or file handles. Running out of file descriptors can be disastrous and will most probably lead to data loss. Make sure to increase the limit on the number of open files descriptors for the user running Elasticsearch to 65,535 or higher.
For the `.zip` and `.tar.gz` packages, set [`ulimit -n 65535`](/docs/deploy-manage/deploy/self-managed/setting-system-settings#ulimit) as root before starting Elasticsearch,   or set `nofile` to `65535` in [`/etc/security/limits.conf`](/docs/deploy-manage/deploy/self-managed/setting-system-settings#limits.conf).
On macOS, you must also pass the JVM option `-XX:-MaxFDLimit` to Elasticsearch in order for it to make use of the higher file descriptor limit.
RPM and Debian packages already default the maximum number of file descriptors to 65535 and do not require further configuration.
You can check the `max_file_descriptors` configured for each node using the [Nodes stats](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-nodes-stats) API, with:
```json
```