﻿---
title: Configure Kibana
description: The Kibana server reads properties from the kibana.yml file on startup. The location of this file differs depending on how you installed Kibana: Archive...
url: https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-kibana
products:
  - Kibana
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Configure Kibana
The Kibana server reads properties from the `kibana.yml` file on startup.
The location of this file differs depending on how you installed Kibana:
- **Archive distributions (`.tar.gz` or `.zip`)**: Default location is `$KIBANA_HOME/config`
- **Package distributions (Debian or RPM)**: Default location is `/etc/kibana`

The config directory can be changed using the `KBN_PATH_CONF` environment variable:
```text
KBN_PATH_CONF=/home/kibana/config ./bin/kibana
```

The default host and port settings configure Kibana to run on `localhost:5601`. To change this behavior and allow remote users to connect, you need to update your [`server.host`](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings#server-host) and [`server.port`](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings#server-port) settings in the `kibana.yml` file.
In this file, you can also enable SSL and set a variety of other options.
Environment variables can be injected into configuration using `${MY_ENV_VAR}` syntax. By default, configuration validation will fail if an environment variable used in the config file is not present when Kibana starts. This behavior can be changed by using a default value for the environment variable, using the `${MY_ENV_VAR:defaultValue}` syntax.

## Available settings

For a complete list of settings that you can apply to Kibana, refer to [Kibana configuration reference](https://www.elastic.co/docs/reference/kibana/configuration-reference).

## Additional topics

Refer to the following documentation to learn how to perform key configuration tasks for Kibana:
- [Configure SSL certificates](/docs/deploy-manage/security/set-up-basic-security-plus-https#encrypt-kibana-browser) to encrypt traffic between client browsers and Kibana
- [Enable authentication providers](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-authentication) for Kibana
- Configure the Kibana [reporting feature](https://www.elastic.co/docs/deploy-manage/kibana-reporting-configuration)
- Use [Spaces](https://www.elastic.co/docs/deploy-manage/manage-spaces) to organize content in Kibana, and restrict access to this content to specific users
- Use [Connectors](https://www.elastic.co/docs/deploy-manage/manage-connectors) to manage connection information between Elasticsearch, Kibana, and third-party systems
- Present a [user access agreement](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/access-agreement) when logging on to Kibana
- Review [considerations for using Kibana in production](https://www.elastic.co/docs/deploy-manage/production-guidance/kibana-in-production-environments), including using load balancers
- [Monitor events inside and outside of Kibana](https://www.elastic.co/docs/deploy-manage/monitor)
- [Configure logging](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration)
- [Secure](https://www.elastic.co/docs/deploy-manage/security) Kibana communications and resources