﻿---
title: Configure Elasticsearch
description: Elasticsearch ships with good defaults and requires very little configuration. Most settings can be changed on a running cluster using the Cluster update...
url: https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-elasticsearch
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Configure Elasticsearch
Elasticsearch ships with good defaults and requires very little configuration. Most settings can be changed on a running cluster using the [Cluster update settings](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-put-settings) API.
The configuration files should contain settings which are node-specific (such as `node.name` and paths), or settings which a node requires in order to be able to join a cluster, such as `cluster.name` and `network.host`.
<note>
  This topic describes how to configure a self-managed Elasticsearch cluster. Other deployment types must be configured using different steps.To learn how to configure `elasticsearch.yml` for other deployment types, refer to [Elastic Stack settings](https://www.elastic.co/docs/deploy-manage/stack-settings).JVM and log4j configuration is not available in all deployment types. To learn how to configure limited JVM options in Elastic Cloud on Kubernetes, refer to [Manage compute resources](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/manage-compute-resources).
</note>


## Available settings

For a complete list of settings that you can apply to your Elasticsearch cluster, refer to the [Elasticsearch configuration reference](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference).
For a list of settings that must be configured before using your cluster in production, refer to [Important settings configuration](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/important-settings-configuration).

## Config files

Elasticsearch has three configuration files:
- `elasticsearch.yml` for configuring Elasticsearch
- `jvm.options` for configuring Elasticsearch [JVM settings](https://www.elastic.co/docs/reference/elasticsearch/jvm-settings)
- `log4j2.properties` for configuring [Elasticsearch logging](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/elasticsearch-log4j-configuration-self-managed)

These files are located in the config directory, whose default location depends on whether the installation is from an archive distribution (`tar.gz` or `zip`) or a package distribution (Debian or RPM packages).

### Archive distributions

For the archive distributions, the config directory location defaults to `$ES_HOME/config`. The location of the config directory can be changed using the `ES_PATH_CONF` environment variable:
```sh
ES_PATH_CONF=/path/to/my/config ./bin/elasticsearch
```

Alternatively, you can `export` the `ES_PATH_CONF` environment variable through the command line or through your shell profile.

### Package distributions

For the package distributions, the config directory location defaults to `/etc/elasticsearch`.
The location of the config directory can be changed by setting the `ES_PATH_CONF` environment variable, however, setting the environment variable in your shell is not sufficient. Instead, this variable is sourced from one the following locations:
- Debian: `/etc/default/elasticsearch`
- RPM: `/etc/sysconfig/elasticsearch`

You need to edit the `ES_PATH_CONF=/etc/elasticsearch` entry in the relevant file for your package to change the config directory location.

## Config file format

The `elasticsearch.yml` configuration format is [YAML](https://yaml.org/). Here is an example of changing the path of the data and logs directories in Elasticsearch:
```yaml
path:
    data: /var/lib/elasticsearch
    logs: /var/log/elasticsearch
```

Settings can also be flattened as follows:
```yaml
path.data: /var/lib/elasticsearch
path.logs: /var/log/elasticsearch
```

In YAML, you can format non-scalar values as sequences:
```yaml
discovery.seed_hosts:
   - 192.168.1.10:9300
   - 192.168.1.11
   - seeds.mydomain.com
```

Though less common, you can also format non-scalar values as arrays:
```yaml
discovery.seed_hosts: ["192.168.1.10:9300", "192.168.1.11", "seeds.mydomain.com"]
```


## Environment variable substitution

Environment variables referenced with the `${...}` notation within the `elasticsearch.yml` configuration file will be replaced with the value of the environment variable. For example:
```yaml
node.name:    ${HOSTNAME}
network.host: ${ES_NETWORK_HOST}
```

Values for environment variables must be simple strings. Use a comma-separated string to provide values that the component will parse as a list. For example, Elasticsearch will split the following string into a list of values for the `${HOSTNAME}` environment variable:
```yaml
export HOSTNAME="host1,host2"
```

By default, configuration validation will fail if an environment variable used in the config file is not present when the component starts. This behavior can be changed by using a default value for the environment variable, using the `${MY_ENV_VAR:defaultValue}` syntax.

## Cluster and node setting types

Cluster and node settings can be categorized based on how they are configured:

### Dynamic

You can configure and update dynamic settings on a running cluster using the [cluster update settings API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-put-settings). You can also configure dynamic settings locally on an unstarted or shut down node using `elasticsearch.yml`.
Updates made using the cluster update settings API can be *persistent*, which apply across cluster restarts, or *transient*, which reset after a cluster restart. You can also reset transient or persistent settings by assigning them a `null` value using the API.
If you configure the same setting using multiple methods, Elasticsearch applies the settings in following order of precedence:
1. Transient setting
2. Persistent setting
3. `elasticsearch.yml`setting
4. Default setting value

For example, you can apply a transient setting to override a persistent setting or `elasticsearch.yml` setting. However, a change to an `elasticsearch.yml` setting will not override a defined transient or persistent setting.
<warning>
  We no longer recommend using transient cluster settings. Use persistent cluster settings instead. If a cluster becomes unstable, transient settings can clear unexpectedly, resulting in a potentially undesired cluster configuration.
</warning>

In a self-managed cluster, you should use the [cluster update settings API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-put-settings) to configure dynamic cluster settings, and only use `elasticsearch.yml` for static cluster settings and node settings. The API doesn’t require a restart and ensures a setting’s value is the same on all nodes.

### Static

Static settings can only be configured on an unstarted or shut down node using `elasticsearch.yml`.
Static settings must be set on every relevant node in the cluster.

## Additional topics

Refer to the following documentation to learn how to perform key configuration tasks for Elasticsearch:
- [Security](https://www.elastic.co/docs/deploy-manage/security): Learn about security features that prevent bad actors from tampering with your data, and encrypt communications to, from, and within your cluster.
- [Cluster or deployment users](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth): Set up authentication and authorization for your cluster, and learn about the underlying security technologies that Elasticsearch uses to authenticate and authorize requests internally and across services.
- [Elastic API keys](https://www.elastic.co/docs/deploy-manage/api-keys): Authenticate and authorize programmatic access to your deployments and Elasticsearch resources.
- [Connectors](https://www.elastic.co/docs/deploy-manage/manage-connectors): Manage connection information between Elastic and third-party systems.
- [Remote clusters](https://www.elastic.co/docs/deploy-manage/remote-clusters): Enable communication between Elasticsearch clusters to support [cross-cluster replication](https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication) and [cross-cluster search](https://www.elastic.co/docs/explore-analyze/cross-cluster-search).
- [Add and Remove Elasticsearch nodes](https://www.elastic.co/docs/deploy-manage/maintenance/add-and-remove-elasticsearch-nodes): Learn how to add or remove nodes to change the size and capacity of your cluster.
- [Production guidance](https://www.elastic.co/docs/deploy-manage/production-guidance): Review tips and guidance that you can use to design a production environment that matches your workloads, policies, and deployment needs.