﻿---
title: Bootstrap checks
description: Elasticsearch has bootstrap checks that run at startup to ensure that users have configured all important settings. These bootstrap checks inspect a variety...
url: https://www.elastic.co/docs/deploy-manage/deploy/self-managed/bootstrap-checks
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Bootstrap checks
Elasticsearch has bootstrap checks that run at startup to ensure that users have configured all [important settings](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/important-settings-configuration).
These bootstrap checks inspect a variety of Elasticsearch and system settings and compare them to values that are safe for the operation of Elasticsearch. If Elasticsearch is in development mode, any bootstrap checks that fail appear as warnings in the Elasticsearch log. If Elasticsearch is in production mode, any bootstrap checks that fail will cause Elasticsearch to refuse to start.
There are some bootstrap checks that are always enforced to prevent Elasticsearch from running with incompatible settings. These checks are documented individually.

## Development vs. production mode

By default, Elasticsearch binds to loopback addresses for [HTTP and transport (internal) communication](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings). This is fine for downloading and playing with Elasticsearch as well as everyday development, but it’s useless for production systems. To join a cluster, an Elasticsearch node must be reachable via transport communication. To join a cluster via a non-loopback address, a node must bind transport to a non-loopback address and not be using [single-node discovery](#single-node-discovery). Thus, we consider an Elasticsearch node to be in development mode if it can not form a cluster with another machine via a non-loopback address, and is otherwise in production mode if it can join a cluster via non-loopback addresses.
Note that HTTP and transport can be configured independently via [`http.host`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings#http-settings) and [`transport.host`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings#transport-settings). This can be useful for configuring a single node to be reachable via HTTP for testing purposes without triggering production mode.

## Single-node discovery

Some users need to bind the transport to an external interface for testing a remote-cluster configuration. For this situation, we provide the discovery type `single-node`. To enable it, set `discovery.type` to `single-node`. In this situation, a node will elect itself master, and will not join a cluster with any other node.

## Forcing the bootstrap checks

If you are running a single node in production, it is possible to evade the bootstrap checks, either by not binding transport to an external interface, or by binding transport to an external interface and setting the discovery type to `single-node`. For this situation, you can force execution of the bootstrap checks by setting the system property `es.enforce.bootstrap.checks` to `true` in the [JVM options](https://www.elastic.co/docs/reference/elasticsearch/jvm-settings#set-jvm-options). We strongly encourage you to do this if you are in this specific situation. This system property can be used to force execution of the bootstrap checks independent of the node configuration.

## Checks

<dropdown title="Heap size check">
  By default, Elasticsearch automatically sizes JVM heap based on a node’s [roles](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/node-settings#node-roles) and total memory. If you manually override the default sizing and start the JVM with different initial and max heap sizes, the JVM may pause as it resizes the heap during system usage. If you enable [`bootstrap.memory_lock`](/docs/deploy-manage/deploy/self-managed/setup-configuration-memory#bootstrap-memory_lock), the JVM locks the initial heap size on startup. If the initial heap size is not equal to the maximum heap size, some JVM heap may not be locked after a resize.To avoid these issues, start the JVM with an initial heap size equal to the maximum heap size.
</dropdown>

<dropdown title="File descriptor check">
  File descriptors are a Unix construct for tracking open "files". In Unix though, [everything is a file](https://en.wikipedia.org/wiki/Everything_is_a_file). For example, "files" could be a physical file, a virtual file (e.g., `/proc/loadavg`), or network sockets. Elasticsearch requires lots of file descriptors (e.g., every shard is composed of multiple segments and other files, plus connections to other nodes, etc.). This bootstrap check is enforced on OS X and Linux.To pass the file descriptor check, you might have to configure [file descriptors](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/file-descriptors).
</dropdown>

<dropdown title="Memory lock check">
  When the JVM does a major garbage collection it touches every page of the heap. If any of those pages are swapped out to disk they will have to be swapped back in to memory. That causes lots of disk thrashing that Elasticsearch would much rather use to service requests. There are several ways to configure a system to disallow swapping. One way is by requesting the JVM to lock the heap in memory through `mlockall` (Unix) or virtual lock (Windows). This is done via the Elasticsearch setting [`bootstrap.memory_lock`](/docs/deploy-manage/deploy/self-managed/setup-configuration-memory#bootstrap-memory_lock). However, there are cases where this setting can be passed to Elasticsearch but Elasticsearch is not able to lock the heap (e.g., if the `elasticsearch` user does not have `memlock unlimited`). The memory lock check verifies that **if** the `bootstrap.memory_lock` setting is enabled, that the JVM was successfully able to lock the heap.To pass the memory lock check, you might have to configure [`bootstrap.memory_lock`](/docs/deploy-manage/deploy/self-managed/setup-configuration-memory#bootstrap-memory_lock).
</dropdown>

<dropdown title="Maximum number of threads check">
  Elasticsearch executes requests by breaking the request down into stages and handing those stages off to different thread pool executors. There are different [thread pool executors](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/thread-pool-settings) for a variety of tasks within Elasticsearch. Thus, Elasticsearch needs the ability to create a lot of threads. The maximum number of threads check ensures that the Elasticsearch process has the rights to create enough threads under normal use. This check is enforced only on Linux.If you are on Linux, to pass the maximum number of threads check, you must configure your system to allow the Elasticsearch process the ability to create at least 4096 threads. This can be done via `/etc/security/limits.conf` using the `nproc` setting (note that you might have to increase the limits for the `root` user too).
</dropdown>

<dropdown title="Max file size check">
  The segment files that are the components of individual shards and the translog generations that are components of the translog can get large (exceeding multiple gigabytes). On systems where the max size of files that can be created by the Elasticsearch process is limited, this can lead to failed writes. Therefore, the safest option here is that the max file size is unlimited and that is what the max file size bootstrap check enforces.To pass the max file check, you must configure your system to allow the Elasticsearch process the ability to write files of unlimited size. This can be done via `/etc/security/limits.conf` using the `fsize` setting to `unlimited` (note that you might have to increase the limits for the `root` user too).
</dropdown>

<dropdown title="Maximum size virtual memory check">
  Elasticsearch and Lucene use `mmap` to great effect to map portions of an index into the Elasticsearch address space. This keeps certain index data off the JVM heap but in memory for blazing fast access. For this to be effective, the Elasticsearch should have unlimited address space. The maximum size virtual memory check enforces that the Elasticsearch process has unlimited address space and is enforced only on Linux.To pass the maximum size virtual memory check, you must configure your system to allow the Elasticsearch process the ability to have unlimited address space. This can be done via adding `<user> - as unlimited` to `/etc/security/limits.conf`. This may require you to increase the limits for the `root` user too.
</dropdown>

<dropdown title="Maximum map count check">
  In addition to [unlimited address space](#max-size-virtual-memory-check), to use `mmap` effectively, Elasticsearch also requires the ability to create many memory-mapped areas. The maximum map count check checks that the kernel allows a process to have at least 262,144 memory-mapped areas and is enforced on Linux only.To pass the maximum map count check, you must configure `vm.max_map_count` via `sysctl` to be at least `262144`. The recommended value is `1048576`.Alternatively, the maximum map count check is only needed if you are using `mmapfs` or `hybridfs` as the [store type](https://www.elastic.co/docs/reference/elasticsearch/index-settings/store) for your indices. If you [do not allow](https://www.elastic.co/docs/reference/elasticsearch/index-settings/store#allow-mmap) the use of `mmap` then this bootstrap check will not be enforced.
</dropdown>

<dropdown title="Client JVM check">
  There are two different JVMs provided by OpenJDK-derived JVMs: the client JVM and the server JVM. These JVMs use different compilers for producing executable machine code from Java bytecode. The client JVM is tuned for startup time and memory footprint while the server JVM is tuned for maximizing performance. The difference in performance between the two VMs can be substantial. The client JVM check ensures that Elasticsearch is not running inside the client JVM.To pass the client JVM check, you must start Elasticsearch with the server VM. On modern systems and operating systems, the server VM is the default.
</dropdown>

<dropdown title="Use serial collector check">
  There are various garbage collectors for the OpenJDK-derived JVMs targeting different workloads. The serial collector in particular is best suited for single logical CPU machines or extremely small heaps, neither of which are suitable for running Elasticsearch. Using the serial collector with Elasticsearch can be devastating for performance. The serial collector check ensures that Elasticsearch is not configured to run with the serial collector.To pass the serial collector check, you must not start Elasticsearch with the serial collector (whether it’s from the defaults for the JVM that you’re using, or you’ve explicitly specified it with `-XX:+UseSerialGC`). Note that the default JVM configuration that ships with Elasticsearch configures Elasticsearch to use the G1GC garbage collector with JDK14 and later versions. For earlier JDK versions, the configuration defaults to the CMS collector.
</dropdown>

<dropdown title="System call filter check">
  Elasticsearch installs system call filters of various flavors depending on the operating system (e.g., seccomp on Linux). These system call filters are installed to prevent the ability to execute system calls related to forking as a defense mechanism against arbitrary code execution attacks on Elasticsearch. The system call filter check ensures that if system call filters are enabled, then they were successfully installed.To pass the system call filter check you must fix any configuration errors on your system that prevented system call filters from installing (check your logs).
</dropdown>

<dropdown title="OnError and OnOutOfMemoryError checks">
  The JVM options `OnError` and `OnOutOfMemoryError` enable executing arbitrary commands if the JVM encounters a fatal error (`OnError`) or an `OutOfMemoryError` (`OnOutOfMemoryError`). However, by default, Elasticsearch system call filters (seccomp) are enabled and these filters prevent forking. Thus, using `OnError` or `OnOutOfMemoryError` and system call filters are incompatible. The `OnError` and `OnOutOfMemoryError` checks prevent Elasticsearch from starting if either of these JVM options are used and system call filters are enabled. This check is always enforced.To pass this check, do not enable `OnError` nor `OnOutOfMemoryError`; instead, upgrade to Java 8u92 and use the JVM flag `ExitOnOutOfMemoryError`. While this does not have the full capabilities of `OnError` nor `OnOutOfMemoryError`, arbitrary forking will not be supported with seccomp enabled.
</dropdown>

<dropdown title="Early-access check">
  The OpenJDK project provides early-access snapshots of upcoming releases. These releases are not suitable for production. The early-access check detects these early-access snapshots.To pass this check, you must start Elasticsearch on a release build of the JVM.
</dropdown>

<dropdown title="All permission check">
  The all permission check ensures that the security policy used during bootstrap does not grant the `java.security.AllPermission` to Elasticsearch. Running with the all permission granted is equivalent to disabling the security manager.
</dropdown>

<dropdown title="Discovery configuration check">
  By default, when Elasticsearch first starts up it will try and discover other nodes running on the same host. If no elected master can be discovered within a few seconds then Elasticsearch will form a cluster that includes any other nodes that were discovered. It is useful to be able to form this cluster without any extra configuration in development mode, but this is unsuitable for production because it’s possible to form multiple clusters and lose data as a result.This bootstrap check ensures that discovery is not running with the default configuration. It can be satisfied by setting at least one of the following properties:
  - `discovery.seed_hosts`
  - `discovery.seed_providers`
  - `cluster.initial_master_nodes`
  Note that you must [remove `cluster.initial_master_nodes` from the configuration of every node](/docs/deploy-manage/deploy/self-managed/important-settings-configuration#initial_master_nodes) after the cluster has started for the first time. Instead, configure `discovery.seed_hosts` or `discovery.seed_providers`. If you do not need any discovery configuration, for instance if running a single-node cluster, set `discovery.seed_hosts: []` to disable discovery and satisfy this bootstrap check.
</dropdown>

<dropdown title="Encrypt sensitive data check">
  If you use Watcher and have chosen to encrypt sensitive data (by setting `xpack.watcher.encrypt_sensitive_data` to `true`), you must also place a key in the secure settings store.To pass this bootstrap check, you must set the `xpack.watcher.encryption_key` on each node in the cluster. For more information, see [Encrypting sensitive data in Watcher](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/encrypting-data).
</dropdown>

<dropdown title="PKI realm check">
  If you use Elasticsearch security features and a Public Key Infrastructure (PKI) realm, you must configure Transport Layer Security (TLS) on your cluster and enable client authentication on the network layers (either transport or http). For more information, see [PKI user authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/pki) and [Set up basic security plus HTTPS](https://www.elastic.co/docs/deploy-manage/security/set-up-basic-security-plus-https).To pass this bootstrap check, if a PKI realm is enabled, you must configure TLS and enable client authentication on at least one network communication layer.
</dropdown>

<dropdown title="Role mappings check">
  If you authenticate users with realms other than `native` or `file` realms, you must create role mappings. These role mappings define which roles are assigned to each user.If you use files to manage the role mappings, you must configure a YAML file and copy it to each node in the cluster. By default, role mappings are stored in `ES_PATH_CONF/role_mapping.yml`. Alternatively, you can specify a different role mapping file for each type of realm and specify its location in the [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-elasticsearch) file. For more information, see [Using role mapping files](/docs/deploy-manage/users-roles/cluster-or-deployment-auth/mapping-users-groups-to-roles#mapping-roles-file).To pass this bootstrap check, the role mapping files must exist and must be valid. The Distinguished Names (DNs) that are listed in the role mappings files must also be valid.
</dropdown>

<dropdown title="SSL/TLS check">
  If you enable Elasticsearch security features, unless you have a trial license, you must configure SSL/TLS for internode-communication.
  <note>
    Single-node clusters that use a loopback interface do not have this requirement. For more information, see [*Start the Elastic Stack with security enabled automatically*](https://www.elastic.co/docs/deploy-manage/security/self-auto-setup).
  </note>
  To pass this bootstrap check, you must [set up SSL/TLS in your cluster](/docs/deploy-manage/security/set-up-basic-security#encrypt-internode-communication).
</dropdown>

<dropdown title="Token SSL check">
  If you use Elasticsearch security features and the built-in token service is enabled, you must configure your cluster to use SSL/TLS for the HTTP interface. HTTPS is required in order to use the token service.In particular, if `xpack.security.authc.token.enabled` is set to `true` in the [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-elasticsearch) file, you must also set `xpack.security.http.ssl.enabled` to `true`. For more information about these settings, see [Security settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings) and [Advanced HTTP settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings#http-settings).To pass this bootstrap check, you must enable HTTPS or disable the built-in token service.
</dropdown>