﻿---
title: Access Kibana in a self-managed cluster
description: Access Kibana through the web application on port 5601. Point your web browser to the machine where you are running Kibana and specify the port number...
url: https://www.elastic.co/docs/deploy-manage/deploy/self-managed/access-kibana
products:
  - Kibana
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Access Kibana in a self-managed cluster
Access Kibana through the web application on port 5601.
1. Point your web browser to the machine where you are running Kibana and specify the port number. For example, `localhost:5601` or `https://YOURDOMAIN.com:5601`.
   To remotely connect to Kibana, set [`server.host`](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings#server-host) to a non-loopback address.
   <note>
   For production deployments, you should always [secure Kibana with a certificate](/docs/deploy-manage/security/set-up-basic-security-plus-https#encrypt-kibana-http) and access it over HTTPS.
   </note>
2. Log on to your account.
3. Go to the home page, then click **Kibana**.
4. To make the Kibana page your landing page, click **Make this my landing page**.


## Grant other users access to Kibana

Kibana leverages Elasticsearch authentication and authorization technologies to secure access.
To learn about authentication options, refer to [User authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/user-authentication).
To learn how to enable authentication providers for Kibana, refer to [Authentication in Kibana](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-authentication).

## Resources

- [Troubleshoot: Check Kibana server status](https://www.elastic.co/docs/troubleshoot/kibana/access)
- [Troubleshoot: Error: Kibana server is not ready yet](https://www.elastic.co/docs/troubleshoot/kibana/error-server-not-ready)