﻿---
title: Self-managed cluster
description: If you want to install Elastic on your own premises without the assistance of an orchestrator, then you can deploy a self-managed cluster. If you deploy...
url: https://www.elastic.co/docs/deploy-manage/deploy/self-managed
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Self-managed cluster
If you want to install Elastic on your own premises without the assistance of an [orchestrator](/docs/deploy-manage/deploy#about-orchestration), then you can deploy a self-managed cluster. If you deploy a self-managed cluster, then you have complete control and responsibility over every aspect of your Elastic deployment.
To quickly set up Elasticsearch and Kibana in Docker for local development or testing, jump to [Local development installation (quickstart)](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/local-development-installation-quickstart).
<admonition title="Simplify the deployment process">
  Self-managed clusters are useful for local development, and for exploring Elastic features. However, Elastic offers several deployment options that can simplify the process of deploying and managing multi-node deployments, especially in production. They also allow you to deploy and manage multiple deployments from a single surface.Managed by Elastic:
  - [Elastic Cloud Serverless](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/serverless)
  - [Elastic Cloud Hosted](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/cloud-hosted)
  Self-hosted options:
  - [Elastic Cloud on Kubernetes](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s)
  - [Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise)
  For a comparison of these deployment options, refer to [Choosing your deployment type](/docs/deploy-manage/deploy#choosing-your-deployment-type) and [Detailed deployment comparison](https://www.elastic.co/docs/deploy-manage/deploy/deployment-comparison).
</admonition>

<admonition title="Use cloud services in your self-managed cluster with Cloud Connect">
  If you need to run Elastic on your own infrastructure, use [Cloud Connect](https://www.elastic.co/docs/deploy-manage/cloud-connect). Cloud connect enables you to use Elastic-managed cloud services in your self-managed cluster without having to install and manage their infrastructure yourself.This way, you can get faster access to new cloud features while still meeting your infrastructure requirements.
</admonition>


## Section overview

This section focuses on deploying Elasticsearch and Kibana without an orchestrator.
Depending on your use case, you might need to deploy other components, such as APM, Fleet, or Logstash.
Deploying those components is not covered in this section. [Learn more about optional components](https://www.elastic.co/docs/get-started/the-stack).
This section covers the following tasks:

### Deploying Elasticsearch

Learn how to install and configure Elasticsearch. Elasticsearch is the distributed search and analytics engine, scalable data store, and vector database at the heart of all Elastic solutions.
- [Deploy an Elasticsearch cluster](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/installing-elasticsearch)
  - [Important system configuration](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/important-system-configuration): Prepare your environment for an Elasticsearch installation.
- [Deploy an Elasticsearch cluster > Installation methods](/docs/deploy-manage/deploy/self-managed/installing-elasticsearch#installation-methods): Install and run Elasticsearch using one of our install packages or container images.
- [Local development installation (quickstart)](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/local-development-installation-quickstart): Quickly set up Elasticsearch and Kibana in Docker for local development or testing.
- [Configure Elasticsearch](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-elasticsearch): Learn how to make configuration changes to Elasticsearch
  - [Important settings configuration](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/important-settings-configuration): Learn about key settings required for production environments.
- [Add plugins](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/plugins): Learn about how to extend Elasticsearch functionality with plugins.
  <note>
  For a complete list of settings that you can apply to your Elasticsearch cluster, refer to the [Elasticsearch configuration reference](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference).
  </note>


### Deploying Kibana

After you deploy Elasticsearch, you can install Kibana. Kibana provides the user interface for all Elastic solutions. It’s a powerful tool for [visualizing and analyzing](https://www.elastic.co/docs/explore-analyze) your data, and for managing and monitoring the Elastic Stack. Although Kibana is not required to use Elasticsearch, it's required for most [use cases](https://www.elastic.co/docs/solutions).
- [Install Kibana](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/install-kibana): Install Kibana using one of our install packages or container images, and enroll Kibana with your Elasticsearch cluster.
- [Configure Kibana](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-kibana): Learn how to make configuration changes to Kibana.
- [Access Kibana in a self-managed cluster](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/access-kibana): Learn how to access Kibana using a web browser.


### Installing in air gapped environments

Some components of the Elastic Stack require additional configuration and local dependencies in order to deploy in environments without internet access.
Refer to [Air gapped install](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/air-gapped-install) to learn how to install Elasticsearch, Kibana, and optional components in an environment without internet access.

### Tools and APIs

Review a list of all of the resources that you can use to interact with your self-managed cluster, including tools, APIs, client libraries, and more.
[Tools and APIs for self-managed clusters](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/tools-apis).

## Other important sections

Review these other sections for critical information about securing and managing your self-managed cluster.

### Secure and control access

Learn how to secure your Elastic environment to restrict access to only authorized parties, and allow communication between your environment and external parties.
- [Security](https://www.elastic.co/docs/deploy-manage/security): Learn about security features that prevent bad actors from tampering with your data, and encrypt communications to, from, and within your cluster.
- [Users and roles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth): Set up authentication and authorization for your cluster, and learn about the underlying security technologies that Elasticsearch uses to authenticate and authorize requests internally and across services.
- [Spaces](https://www.elastic.co/docs/deploy-manage/manage-spaces): Learn how to organize content in Kibana, and restrict access to this content to specific users.
- [Elastic API keys](https://www.elastic.co/docs/deploy-manage/api-keys): Authenticate and authorize programmatic access to your deployments and Elasticsearch resources.
- [Connectors](https://www.elastic.co/docs/deploy-manage/manage-connectors): Manage connection information between Elastic and third-party systems.
- [Remote clusters on self-managed installations](https://www.elastic.co/docs/deploy-manage/remote-clusters/remote-clusters-self-managed): Enable communication between Elasticsearch clusters to support [cross-cluster replication](https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication) and [cross-cluster search](https://www.elastic.co/docs/explore-analyze/cross-cluster-search).


### Administer and maintain

Monitor the performance of your Elastic environment, administer your license, set up backup and resilience tools, and maintain the health of your environment.
- [Backup, high availability, and resilience tools](https://www.elastic.co/docs/deploy-manage/tools): Learn about the tools available to safeguard data, ensure continuous availability, and maintain resilience in your Elasticsearch environment.
- [Monitoring](https://www.elastic.co/docs/deploy-manage/monitor): View health and performance data for Elastic components, and receive recommendations and insights.
- [Licenses and subscriptions](https://www.elastic.co/docs/deploy-manage/license): Learn how to manage your Elastic license.
- [Start and stop services](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services): Learn how to isolate or deactivate parts of your Elastic environment to perform maintenance, or restart parts of Elastic.
- [Add and Remove Elasticsearch nodes](https://www.elastic.co/docs/deploy-manage/maintenance/add-and-remove-elasticsearch-nodes): Learn how to add nodes to a cluster or remove them from a cluster to change the size and capacity of Elasticsearch.


### Upgrade

You can [upgrade your Elastic environment](https://www.elastic.co/docs/deploy-manage/upgrade) to gain access to the latest features.

### Design guidance

Learn how to design a production-ready Elastic environment.
- [Production guidance](https://www.elastic.co/docs/deploy-manage/production-guidance): Review tips and guidance that you can use to design a production environment that matches your workloads, policies, and deployment needs.
- [Reference architectures](https://www.elastic.co/docs/deploy-manage/reference-architectures): Explore blueprints for deploying clusters tailored to different use cases.


### Architectural information

In the [Distributed architecture](https://www.elastic.co/docs/deploy-manage/distributed-architecture) section, learn about the architecture of Elasticsearch and Kibana, and how Elastic stores and retrieves data and executes tasks in clusters with multiple nodes.