﻿---
title: Tools and APIs for Elastic Cloud
description: Review key resources that can be used to interact with and manage your Elastic Cloud organization, Elastic Cloud Hosted deployments, and Elastic Cloud...
url: https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/tools-apis
products:
  - Elastic Cloud Serverless
  - Elastic Cloud Terraform Provider
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# Tools and APIs for Elastic Cloud
Review key resources that can be used to interact with and manage your Elastic Cloud organization, Elastic Cloud Hosted deployments, and Elastic Cloud Serverless projects.

## APIs

You can use the following APIs in an Elastic Cloud environment.
<tip>
  Refer to [Elastic API keys](https://www.elastic.co/docs/deploy-manage/api-keys) to learn how to generate API keys for your environment.
</tip>


### Orchestration APIs

The following REST APIs allow you to manage your Elastic Cloud organization, users, security, billing and resources.

| Area                                                       | API                                                                                          | Tasks                                                                                                                                                                                                                                                                                                                                                                                                                                           |
|------------------------------------------------------------|----------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Elastic Cloud organizationElastic Cloud Hosted deployments | [Elastic Cloud API](https://www.elastic.co/docs/api/doc/cloud/)                              | Manage your Cloud organization, members, costs, billing, and more.Manage your hosted deployments and all of the resources associated with them, including scaling or autoscaling resources, and managing network security, deployment extensions, remote clusters, and Elastic Stack versions.Refer to [Elastic Cloud RESTful API](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-restful) for usage information and examples. |
| Elastic Cloud Serverless projects                          | [Elastic Cloud Serverless API](https://www.elastic.co/docs/api/doc/elastic-cloud-serverless) | Manage Elastic Cloud Serverless projects.                                                                                                                                                                                                                                                                                                                                                                                                       |
| Elastic Cloud services                                     | [Service Status API](https://status.elastic.co/api/)                                         | Programmatically ingest [service status](https://www.elastic.co/docs/deploy-manage/cloud-organization/service-status) updates.                                                                                                                                                                                                                                                                                                                  |
| Elastic Cloud billing information                          | [Cloud Billing API](https://www.elastic.co/docs/api/doc/cloud-billing/)                      | Retrieve additional billing and cost information about your Elastic Cloud organization.                                                                                                                                                                                                                                                                                                                                                         |


### APIs to interact with data and solution features

The following APIs allow you to interact with your Elasticsearch cluster, its data, and the features available to you in your Elastic Cloud Hosted deployments and Elastic Cloud Serverless projects. Separate APIs are used for Elastic Cloud Hosted and Elastic Cloud Serverless.
Note that some [restrictions](/docs/deploy-manage/deploy/elastic-cloud/restrictions-known-problems#ec-restrictions-apis-elasticsearch) apply when using the these APIs on Elastic Cloud.
<tip>
  Refer to [Elasticsearch API conventions](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/api-conventions) to learn about headers, request body conventions, and examples for Elasticsearch Serverless and Elasticsearch REST APIs.
</tip>

<applies-switch>
  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    The following APIs are available for Elasticsearch Serverless users:
    - [Elasticsearch Serverless APIs](https://www.elastic.co/docs/api/doc/elasticsearch-serverless): Use these APIs to index, manage, search, and analyze your data in Elasticsearch Serverless.
      Learn how to [connect to your Elasticsearch Serverless endpoint](https://www.elastic.co/docs/solutions/search/get-started).
    - [Kibana Serverless APIs](https://www.elastic.co/docs/api/doc/serverless): Use these APIs to manage resources such as connectors, data views, and saved objects for your Elastic Cloud Serverless project.
  </applies-item>

  <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
    The following APIs are available for Elastic Cloud Hosted users:
    - [Elasticsearch APIs](https://www.elastic.co/docs/api/doc/elasticsearch/): This set of APIs allows you to interact directly with the Elasticsearch nodes in your deployment. You can ingest data, run search queries, check the health of your clusters, manage snapshots, and more.
    - [Kibana APIs](https://www.elastic.co/docs/api/doc/kibana/): Many Kibana features can be accessed through these APIs, including Kibana objects, patterns, and dashboards, as well as user roles and user sessions. You can use these APIs to configure alerts and actions, and to access health details for the [Kibana Task Manager](https://www.elastic.co/docs/deploy-manage/distributed-architecture/kibana-tasks-management).
  </applies-item>
</applies-switch>


#### APIs for optional products

Some other Elastic products have APIs to support machine-to-machine operations:
- [APM event intake API](https://www.elastic.co/docs/solutions/observability/apm/elastic-apm-events-intake-api)
- [Fleet APIs](https://www.elastic.co/docs/reference/fleet/fleet-api-docs)
- [Logstash APIs](https://www.elastic.co/docs/reference/logstash/monitoring-logstash)


## Elastic Cloud API console

<applies-to>
  - Elastic Cloud Serverless: Unavailable
  - Elastic Cloud Hosted: Generally available
</applies-to>

With the Elasticsearch API console, you can interact with a specific Elasticsearch deployment directly from the Elastic Cloud Console or Cloud UI without having to authenticate again. This RESTful API access is limited to the specific cluster and works only for Elasticsearch API calls.
You can find this console in the Elastic Cloud Console or Cloud UI when selecting a specific deployment to manage. From the Elasticsearch menu, select **API Console**.
<note>
  This API Console is different from the [Dev Tools Console](https://www.elastic.co/docs/explore-analyze/query-filter/tools/console) available in Kibana, from which you can call Elasticsearch and Kibana APIs. On the Elasticsearch API Console, you cannot run Kibana APIs.This API console is intended for admin purposes. Avoid running normal workload like indexing or search requests.
</note>


## Elastic Cloud Control: command-line interface for Elastic Cloud

<applies-to>
  - Elastic Cloud Serverless: Unavailable
  - Elastic Cloud Hosted: Generally available
</applies-to>

Elastic Cloud Control (ECCTL) is the command-line interface for Elastic Cloud APIs. It wraps typical operations commonly needed by operators within a single command line tool.
ECCTL provides the following benefits:
- Easier to use than the Elastic Cloud Console, Cloud UI, or using the RESTful API directly
- Helps you automate the deployment lifecycle
- Provides a foundation for integration with other tools

Find more details in the [ECCTL documentation](https://www.elastic.co/docs/reference/ecctl).

## Provision projects and deployments with Terraform

The Elastic Cloud Terraform provider allows you to provision and manage Elastic Cloud Serverless projects, Elastic Cloud Hosted and Elastic Cloud Enterprise deployments as code, and introduce DevOps-driven methodologies to manage and deploy the Elastic Stack and solutions.
To get started, review the [Elastic Cloud Terraform provider documentation](https://registry.terraform.io/providers/elastic/ec/latest/docs) and [Elastic Cloud Terraform GitHub repository](https://github.com/elastic/terraform-provider-ec) for more guidance.

## Elastic Cloud email service

Elastic Cloud provides a built-in email service used by the preconfigured [email connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type), available in both Elastic Cloud Hosted deployments and Elastic Cloud Serverless projects. This service can be used to send [alert](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts) notifications and is also supported in Elastic Cloud Hosted by [Watcher](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/enable-watcher).

### Email service limits

The following quotas apply to both Elastic Cloud Hosted deployments and Elastic Cloud Serverless projects when using the Elastic email service:
- Email sending quota: 500 emails per 15 minute period.
- Maximum number of recipients per message: 30 recipients per email (To, CC, and BCC all count as recipients).
- Maximum message size (including attachments): 10 MB per message (after Base64 encoding).
- The email-sender can't be customized (Any custom `From:` header will be removed).