﻿---
title: Restrictions and known problems
description: When using Elastic Cloud, there are some limitations you should be aware of: Stack versions, Security, APIs, Transport client, Elasticsearch and Kibana...
url: https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/restrictions-known-problems
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Restrictions and known problems
When using Elastic Cloud, there are some limitations you should be aware of:
- [Stack versions](#ec-stack-versions)
- [Security](#ec-restrictions-security)
- [APIs](#ec-restrictions-apis)
- [Transport client](#ec-restrictions-transport-client)
- [Elasticsearch and Kibana plugins](#ec-restrictions-plugins)
- [Watcher](#ec-restrictions-watcher)
- [Private connectivity and SSO to Kibana URLs](#ec-restrictions-network-security-kibana-sso)
- [PDF report generation using Alerts or Watcher webhooks](#ec-restrictions-network-security-watcher)
- [Kibana](#ec-restrictions-kibana)
- [Fleet with network security](#ec-restrictions-fleet-network-security)
- [Restoring a snapshot across deployments](#ec-snapshot-restore-enterprise-search-kibana-across-deployments)
- [Migrate Fleet-managed Elastic Agents across deployments by restoring a snapshot](#ec-migrate-elastic-agent)
- [Regions and Availability Zones](#ec-regions-and-availability-zone)
- [Node count and size](#ec-node-count-size)
- [Repository analysis API is unavailable in Elastic Cloud](#ec-repository-analyis-unavailable)
- [Service status](#ec-service-status)

For limitations related to logging and monitoring, check the [Restrictions and limitations](/docs/deploy-manage/monitor/stack-monitoring/ece-ech-stack-monitoring#restrictions-monitoring) section of the logging and monitoring page.
To learn more about the features that are supported by Elastic Cloud, check [Elastic Cloud Subscriptions](https://www.elastic.co/cloud/elasticsearch-service/subscriptions?page=docs&placement=docs-body).

## Stack versions

- Due to a known issue with the Elastic Stack, certain upgrade paths to and from version 8.17 are currently blocked or disabled. Review [this KB article](https://support.elastic.co/knowledge/7c3ad709) for more guidance on the known issue. Additionally, review [this KB article](https://support.elastic.co/knowledge/e87d76a5) for detailed information regarding the specific versions affected.
- Due to a known issue with the Elastic Stack, the upgrade path from 9.1.10 to 9.2.4 is unavailable. Refer to [Elasticsearch known issues](https://www.elastic.co/docs/release-notes/elasticsearch/known-issues#elasticsearch-9.2.4-known-issues) for more information on the underlying issue.


## Security

- File and LDAP realms cannot be used. The Native realm is enabled, but the realm configuration itself is fixed in Elastic Cloud. Alternatively, authentication protocols such as SAML, OpenID Connect, or Kerberos can be used.
- Client certificates, such as PKI certificates, are not supported.
- IPv6 is not supported.


## APIs

The following restrictions apply when using APIs in Elastic Cloud:
<definitions>
  <definition term="Elastic Cloud API">
    The Elastic Cloud API is subject to a restriction on the volume of API requests that can be submitted per user, per second. Check [Rate limiting](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-rate-limiting) for details.
  </definition>
</definitions>


<definitions>
  <definition term="Elasticsearch APIs">
    The Elasticsearch APIs do not natively enforce rate limiting. However, all requests to the Elasticsearch cluster are subject to Elasticsearch configuration settings, such as the [network HTTP setting](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/networking-settings#http-settings) `http:max_content_length` which restricts the maximum size of an HTTP request body. This setting has a default value of 100MB, hence restricting API request payloads to that size. This setting is not currently configurable in Elastic Cloud. For a list of which Elasticsearch settings are supported on Cloud, check [Add Elasticsearch user settings](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/edit-stack-settings). To learn about using the Elasticsearch APIs in Elastic Cloud, check [Access the Elasticsearch API console](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-console). And, for full details about the Elasticsearch APIs and their endpoints, check the [Elasticsearch API reference documentation](https://www.elastic.co/docs/reference/elasticsearch/rest-apis).
  </definition>
</definitions>


<definitions>
  <definition term="Kibana APIs">
    There are no rate limits restricting your use of the Kibana APIs. However, Kibana features are affected by the [Kibana configuration settings](https://www.elastic.co/docs/reference/kibana/configuration-reference), not all of which are supported in Elastic Cloud. For a list of what settings are currently supported, check [Add Kibana user settings](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/edit-stack-settings). For all details about using the Kibana APIs, check the [Kibana API reference documentation](https://www.elastic.co/docs/api/doc/kibana/).
  </definition>
</definitions>


## Transport client

- The transport client is not considered thread safe in a cloud environment. We recommend that you use the Java REST client instead. This restriction relates to the fact that your deployments hosted on Elastic Cloud are behind proxies, which prevent the transport client from communicating directly with Elasticsearch clusters.
- The transport client is not supported over [private connections](https://www.elastic.co/docs/deploy-manage/security/private-connectivity). Use the Java REST client instead, or connect over the public internet.


## Elasticsearch and Kibana plugins

- Kibana plugins are not supported.
- Elasticsearch plugins, are not enabled by default for security purposes. Reach out to support if you would like to enable Elasticsearch plugins support on your account.
- Some Elasticsearch plugins do not apply to Elastic Cloud. For example, you won’t ever need to change discovery, as Elastic Cloud handles how nodes discover one another.


## Watcher

Watcher encryption Key Setup is not supported.
Changing the default throttle period is not possible. You can specify a throttle period per watch, however.
Watcher comes preconfigured with a directly usable email account provided by Elastic. However, this account can’t be reconfigured and is subject to some limitations. For more information on the limits of the Elastic mail server, check the [cloud email service limits](/docs/deploy-manage/deploy/elastic-cloud/tools-apis#email-service-limits).
Alternatively, a custom mail server can be configured as described in [Configuring a custom mail server](/docs/explore-analyze/alerts-cases/watcher/enable-watcher#watcher-custom-mail-server)

## Private connectivity and SSO to Kibana URLs

Currently you can’t use SSO to login directly from Elastic Cloud into Kibana endpoints that are protected by private connections. However, you can still SSO into private Kibana endpoints individually using the [SAML](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/saml) or [OIDC](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/openid-connect) protocol from your own identity provider, just not through the Elastic Cloud console. Stack level authentication using the Elasticsearch username and password should also work with `{{kibana-id}}.{vpce|privatelink|psc}.domain` URLs.

## PDF report generation using Alerts or Watcher webhooks

- PDF report automatic generation via Alerts is not possible on Elastic Cloud.
- PDF report generation isn’t possible for deployments running on Elastic Stack version 8.7.0 or before that are protected by network security. This limitation doesn’t apply to public webhooks such as Slack, PagerDuty, and email. For deployments running on Elastic Stack version 8.7.1 and beyond, [PDF report automatic generation via Watcher webhook](/docs/explore-analyze/report-and-share/automating-report-generation#use-watcher) is possible using the `xpack.notification.webhook.additional_token_enabled` configuration setting to bypass network security.


## Kibana

- The maximum size of a single Kibana instance is 8GB. This means, Kibana instances can be scaled up to 8GB before they are scaled out. For example, when creating a deployment with a Kibana instance of size 16GB, then 2x8GB instances are created. If you face performance issues with Kibana PNG or PDF reports, the recommendations are to create multiple, smaller dashboards to export the data, or to use a third party browser extension for exporting the dashboard in the format you need.
- Running an external Kibana in parallel to Elastic Cloud’s Kibana instances may cause errors, for example [`Unable to decrypt attribute`](/docs/explore-analyze/alerts-cases/alerts/alerting-common-issues#rule-cannot-decrypt-api-key), due to a mismatched [`xpack.encryptedSavedObjects.encryptionKey`](https://www.elastic.co/docs/reference/kibana/configuration-reference/security-settings#security-encrypted-saved-objects-settings) as Elastic Cloud does not [allow users to set](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/edit-stack-settings) nor expose this value. While workarounds are possible, this is not officially supported nor generally recommended.
- Workflows using the `elasticsearch.bulk` step might mishandle bulk operations in Elastic Cloud Hosted. Bulk action metadata (such as `index`, `create`, `update`, or `delete`) can be interpreted as document data, which might cause unexpected behavior for bulk operations beyond basic indexing. The workaround is to use a generic Elasticsearch request action in the workflow to call the Bulk API directly instead of using the `elasticsearch.bulk` step. For more information, refer to [Generic request actions](https://www.elastic.co/docs/explore-analyze/workflows/steps/elasticsearch#generic-request-actions). This issue is fixed in Serverless deployments.


## Fleet with network security

- If you are using Fleet 8.12+, using a remote Elasticsearch output with a target cluster that has network security enabled is not currently supported.


## Restoring a snapshot across deployments

Kibana does not currently support restoring a snapshot of their indices across Elastic Cloud deployments.
- [Kibana uses encryption keys](https://www.elastic.co/docs/deploy-manage/security/secure-your-cluster-deployment) in various places, ranging from encrypting data in some areas of reporting, alerts, actions, connector tokens, ingest outputs used in Fleet and Synthetics monitoring to user sessions.
- Currently, there is not a way to retrieve the values of Kibana encryption keys, or set them in the target deployment before restoring a snapshot. As a result, once a snapshot is restored, Kibana will not be able to decrypt the data required for some features to function properly in the target deployment.
- If you have already restored a snapshot across deployments and now have broken Kibana saved objects in the target deployment, you will have to recreate all broken configurations and objects, or create a new setup in the target deployment instead of using snapshot restore.

A snapshot taken using the default `found-snapshots` repository can only be restored to deployments in the same region. If you need to restore snapshots across regions, create the destination deployment, connect to the [custom repository](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/elastic-cloud-hosted), and then [restore from a snapshot](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/restore-snapshot).
When restoring from a deployment that’s using searchable snapshots, you must not delete the snapshots in the source deployment even after they are successfully restored in the destination deployment. Refer to [Restore snapshots containing searchable snapshots indices across clusters](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/ece-restore-snapshots-containing-searchable-snapshots-indices-across-clusters) for more information.

## Migrate Fleet-managed Elastic Agents across deployments by restoring a snapshot

There are situations where you may need or want to move your installed Elastic Agents from being managed in one deployment to being managed in another deployment.
In Elastic Cloud, you can migrate your Elastic Agents by taking a snapshot of your source deployment, and restoring it on a target deployment.
To make a seamless migration, after restoring from a snapshot there are some additional steps required, such as updating settings and resetting the agent policy. Check [Migrate Elastic Agents](https://www.elastic.co/docs/reference/fleet/migrate-elastic-agent) for details.

## Regions and Availability Zones

- The AWS `us-west-1` region is limited to two availability zones for ES data nodes and one (tiebreaker only) virtual zone (as depicted by the `-z` in the AZ (`us-west-1z`). Deployment creation with three availability zones for Elasticsearch data nodes for hot, warm, and cold tiers is not possible. This includes scaling an existing deployment with one or two AZs to three availability zones. The virtual zone `us-west-1z` can only hold an Elasticsearch tiebreaker node (no data nodes). The workaround is to use a different AWS US region that allows three availability zones, or to scale existing nodes up within the two availability zones.
- The AWS `eu-central-2` region is limited to two availability zones for CPU Optimized (ARM) Hardware profile ES data node and warm/cold tier. Deployment creation with three availability zones for Elasticsearch data nodes for hot (for CPU Optimized (ARM) profile), warm and cold tiers is not possible. This includes scaling an existing deployment with one or two AZs to three availability zones. The workaround is to use a different AWS region that allows three availability zones, or to scale existing nodes up within the two availability zones.


## Node count and size

- In the Elastic Cloud console UI, the maximum configurable node count is 32.
  The total RAM for `Size per zone` is calculated by multiplying the maximum RAM size of the [instance configuration](https://www.elastic.co/docs/reference/cloud/cloud-hosted/hardware) in use by 32. For example, for the instance configuration [`aws.es.datahot.c6gd`](https://www.elastic.co/docs/reference/cloud/cloud-hosted/aws-default), the maximum RAM size is 60GB. Therefore, the total RAM for `Size per zone` is `60GB x 32 = 1.875TB` (displayed as `1.88TB` in the Elastic Cloud console UI).
  This maximum node count limitation applies to the UI and affects both the maximum `Size per zone` during manual scaling and the `Maximum size per zone` in autoscaling. This limit is in place to prevent users from inadvertently deploying excessive capacity.
  This limitation does not apply when using the API for manual scaling or autoscaling. If you require additional capacity, you can use the [Elastic Cloud API](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-restful) to scale up or configure the maximum size for autoscaling, in a self-sufficient way. Refer to the [Update a deployment](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-deployment-crud#ec_update_a_deployment) example to learn how to make a deployment update request using the API.
- Apart from the maximum node count configurable in the Elastic Cloud console UI, there are other service limits based on each instance configuration. These service limits are typically greater than 32. For more details, please [contact Elastic support for assistance](https://www.elastic.co/docs/troubleshoot).


## Repository analysis API is unavailable in Elastic Cloud

- The Elasticsearch [Repository analysis API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-snapshot-repository-analyze) is not available in Elastic Cloud due to deployments defaulting to having [operator privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/operator-privileges) enabled that prevent non-operator privileged users from using it along with a number of other APIs.


## Service status

- To ensure we can continue evolving our status page to best serve our customers, we cannot guarantee consistency of API implementation or component API identifiers. However, we communicate changes which might impact status page subscribers on a best-effort basis. Review [Service status](/docs/deploy-manage/cloud-organization/service-status#service-status-support-limitations) for more guidance.