﻿---
title: Manage deployments in Elastic Cloud Hosted
description: Elastic Cloud Hosted allows you to configure and maintain your deployments with a high level of control on every component of the Elastic Stack. You can...
url: https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/manage-deployments
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Manage deployments in Elastic Cloud Hosted
Elastic Cloud Hosted allows you to configure and maintain your deployments with a high level of control on every component of the Elastic Stack. You can adjust the settings of any of your deployments at any time.
- Define the [core configuration](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/configure) of your deployment, including available features, hardware settings and capacity, autoscaling, and high availability.
  - Select a [hardware profile](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/ec-change-hardware-profile) optimized for your use case.
- Make adjustments to specific [deployment components](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/ec-customize-deployment-components), such as the Elasticsearch cluster or an Integrations Server.
- [Manage data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers).
- Ensure the health of your deployment over time
  - [Keep track of your deployment's activity](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/keep-track-of-deployment-activity) or [Enable logging and monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/ece-ech-stack-monitoring) of the deployment performance.
- Perform maintenance operations to ensure the health of your deployment, such as [restarting your deployment](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/restart-cloud-hosted-deployment) or [stopping routing](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-routing-requests).
- Manage the lifecycle of your deployment:
  - [Upgrade your deployment](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster) and its components to a newer version of the Elastic Stack.
- [Delete your deployment](https://www.elastic.co/docs/deploy-manage/uninstall/delete-a-cloud-deployment).